/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.leastsquares;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.CholeskyDecomposer;
import org.hipparchus.linear.CholeskyDecomposition;
import org.hipparchus.linear.LUDecomposer;
import org.hipparchus.linear.LUDecomposition;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposer;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.linear.SingularValueDecomposer;
import org.hipparchus.linear.SingularValueDecomposition;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.LocalizedOptimFormats;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.util.Incrementor;
import org.hipparchus.util.Pair;

public class GaussNewtonOptimizer
implements LeastSquaresOptimizer {
    private static final double SINGULARITY_THRESHOLD = 1.0E-11;
    @Deprecated
    private final Decomposition decomposition;
    private final MatrixDecomposer decomposer;
    private final boolean formNormalEquations;

    public GaussNewtonOptimizer() {
        this(Decomposition.QR);
    }

    @Deprecated
    public GaussNewtonOptimizer(Decomposition decomposition) {
        this(decomposition, decomposition.getDecomposer(), decomposition.isFormNormalEquations());
    }

    public GaussNewtonOptimizer(MatrixDecomposer decomposer, boolean formNormalEquations) {
        this(null, decomposer, formNormalEquations);
    }

    @Deprecated
    private GaussNewtonOptimizer(Decomposition decomposition, MatrixDecomposer decomposer, boolean formNormalEquations) {
        this.decomposition = decomposition;
        this.decomposer = decomposer;
        this.formNormalEquations = formNormalEquations;
    }

    @Deprecated
    public Decomposition getDecomposition() {
        return this.decomposition;
    }

    @Deprecated
    public GaussNewtonOptimizer withDecomposition(Decomposition newDecomposition) {
        return new GaussNewtonOptimizer(newDecomposition);
    }

    public MatrixDecomposer getDecomposer() {
        return this.decomposer;
    }

    public GaussNewtonOptimizer withDecomposer(MatrixDecomposer newDecomposer) {
        return new GaussNewtonOptimizer(newDecomposer, this.isFormNormalEquations());
    }

    public boolean isFormNormalEquations() {
        return this.formNormalEquations;
    }

    public GaussNewtonOptimizer withFormNormalEquations(boolean newFormNormalEquations) {
        return new GaussNewtonOptimizer(this.getDecomposer(), newFormNormalEquations);
    }

    @Override
    public LeastSquaresOptimizer.Optimum optimize(LeastSquaresProblem lsp) {
        Incrementor evaluationCounter = lsp.getEvaluationCounter();
        Incrementor iterationCounter = lsp.getIterationCounter();
        ConvergenceChecker<LeastSquaresProblem.Evaluation> checker = lsp.getConvergenceChecker();
        if (checker == null) {
            throw new NullArgumentException();
        }
        RealVector currentPoint = lsp.getStart();
        LeastSquaresProblem.Evaluation current = null;
        while (true) {
            RealVector dX;
            RealVector rhs;
            RealMatrix lhs;
            iterationCounter.increment();
            LeastSquaresProblem.Evaluation previous = current;
            evaluationCounter.increment();
            current = lsp.evaluate(currentPoint);
            RealVector currentResiduals = current.getResiduals();
            RealMatrix weightedJacobian = current.getJacobian();
            currentPoint = current.getPoint();
            if (previous != null && checker.converged(iterationCounter.getCount(), previous, current)) {
                return LeastSquaresOptimizer.Optimum.of(current, evaluationCounter.getCount(), iterationCounter.getCount());
            }
            if (this.formNormalEquations) {
                Pair<RealMatrix, RealVector> normalEquation = GaussNewtonOptimizer.computeNormalMatrix(weightedJacobian, currentResiduals);
                lhs = (RealMatrix)normalEquation.getFirst();
                rhs = (RealVector)normalEquation.getSecond();
            } else {
                lhs = weightedJacobian;
                rhs = currentResiduals;
            }
            try {
                dX = this.decomposer.decompose(lhs).solve(rhs);
            }
            catch (MathIllegalArgumentException e) {
                throw new MathIllegalStateException((Localizable)LocalizedOptimFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, new Object[]{e});
            }
            currentPoint = currentPoint.add(dX);
        }
    }

    public String toString() {
        return "GaussNewtonOptimizer{decomposer=" + this.decomposer + ", formNormalEquations=" + this.formNormalEquations + '}';
    }

    private static Pair<RealMatrix, RealVector> computeNormalMatrix(RealMatrix jacobian, RealVector residuals) {
        int j;
        int i;
        int nR = jacobian.getRowDimension();
        int nC = jacobian.getColumnDimension();
        RealMatrix normal = MatrixUtils.createRealMatrix((int)nC, (int)nC);
        ArrayRealVector jTr = new ArrayRealVector(nC);
        for (i = 0; i < nR; ++i) {
            for (j = 0; j < nC; ++j) {
                jTr.setEntry(j, jTr.getEntry(j) + residuals.getEntry(i) * jacobian.getEntry(i, j));
            }
            for (int k = 0; k < nC; ++k) {
                for (int l = k; l < nC; ++l) {
                    normal.setEntry(k, l, normal.getEntry(k, l) + jacobian.getEntry(i, k) * jacobian.getEntry(i, l));
                }
            }
        }
        for (i = 0; i < nC; ++i) {
            for (j = 0; j < i; ++j) {
                normal.setEntry(i, j, normal.getEntry(j, i));
            }
        }
        return new Pair((Object)normal, (Object)jTr);
    }

    @Deprecated
    public static enum Decomposition {
        LU{

            @Override
            protected RealVector solve(RealMatrix jacobian, RealVector residuals) {
                try {
                    Pair normalEquation = GaussNewtonOptimizer.computeNormalMatrix(jacobian, residuals);
                    RealMatrix normal = (RealMatrix)normalEquation.getFirst();
                    RealVector jTr = (RealVector)normalEquation.getSecond();
                    return new LUDecomposition(normal, 1.0E-11).getSolver().solve(jTr);
                }
                catch (MathIllegalArgumentException e) {
                    throw new MathIllegalStateException((Localizable)LocalizedOptimFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, new Object[]{e});
                }
            }

            @Override
            protected MatrixDecomposer getDecomposer() {
                return new LUDecomposer(1.0E-11);
            }

            @Override
            protected boolean isFormNormalEquations() {
                return true;
            }
        }
        ,
        QR{

            @Override
            protected RealVector solve(RealMatrix jacobian, RealVector residuals) {
                try {
                    return new QRDecomposition(jacobian, 1.0E-11).getSolver().solve(residuals);
                }
                catch (MathIllegalArgumentException e) {
                    throw new MathIllegalStateException((Localizable)LocalizedOptimFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, new Object[]{e});
                }
            }

            @Override
            protected MatrixDecomposer getDecomposer() {
                return new QRDecomposer(1.0E-11);
            }

            @Override
            protected boolean isFormNormalEquations() {
                return false;
            }
        }
        ,
        CHOLESKY{

            @Override
            protected RealVector solve(RealMatrix jacobian, RealVector residuals) {
                try {
                    Pair normalEquation = GaussNewtonOptimizer.computeNormalMatrix(jacobian, residuals);
                    RealMatrix normal = (RealMatrix)normalEquation.getFirst();
                    RealVector jTr = (RealVector)normalEquation.getSecond();
                    return new CholeskyDecomposition(normal, 1.0E-11, 1.0E-11).getSolver().solve(jTr);
                }
                catch (MathIllegalArgumentException e) {
                    if (e.getSpecifier() == LocalizedCoreFormats.NOT_POSITIVE_DEFINITE_MATRIX) {
                        throw new MathIllegalStateException((Localizable)LocalizedOptimFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, new Object[]{e});
                    }
                    throw e;
                }
            }

            @Override
            protected MatrixDecomposer getDecomposer() {
                return new CholeskyDecomposer(1.0E-11, 1.0E-11);
            }

            @Override
            protected boolean isFormNormalEquations() {
                return true;
            }
        }
        ,
        SVD{

            @Override
            protected RealVector solve(RealMatrix jacobian, RealVector residuals) {
                return new SingularValueDecomposition(jacobian).getSolver().solve(residuals);
            }

            @Override
            protected MatrixDecomposer getDecomposer() {
                return new SingularValueDecomposer();
            }

            @Override
            protected boolean isFormNormalEquations() {
                return false;
            }
        };


        protected abstract RealVector solve(RealMatrix var1, RealVector var2);

        protected abstract MatrixDecomposer getDecomposer();

        protected abstract boolean isFormNormalEquations();
    }
}

