/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.IntPredicate;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.enclosing.WelzlEncloser;
import org.hipparchus.geometry.euclidean.threed.Euclidean3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.SphereGenerator;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.AbstractRegion;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BoundaryProjection;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.geometry.spherical.oned.Arc;
import org.hipparchus.geometry.spherical.oned.S1Point;
import org.hipparchus.geometry.spherical.oned.Sphere1D;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.Edge;
import org.hipparchus.geometry.spherical.twod.EdgeWithNodeInfo;
import org.hipparchus.geometry.spherical.twod.EdgesWithNodeInfoBuilder;
import org.hipparchus.geometry.spherical.twod.PropertiesComputer;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.Vertex;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;

public class SphericalPolygonsSet
extends AbstractRegion<Sphere2D, Sphere1D> {
    private List<Vertex> loops;

    public SphericalPolygonsSet(double tolerance) throws MathIllegalArgumentException {
        super(tolerance);
        Sphere2D.checkTolerance(tolerance);
    }

    public SphericalPolygonsSet(Vector3D pole, double tolerance) throws MathIllegalArgumentException {
        super(new BSPTree<Sphere2D>(new Circle(pole, tolerance).wholeHyperplane(), new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null), tolerance);
        Sphere2D.checkTolerance(tolerance);
    }

    public SphericalPolygonsSet(Vector3D center, Vector3D meridian, double outsideRadius, int n, double tolerance) throws MathIllegalArgumentException {
        this(tolerance, SphericalPolygonsSet.createRegularPolygonVertices(center, meridian, outsideRadius, n));
    }

    public SphericalPolygonsSet(BSPTree<Sphere2D> tree, double tolerance) throws MathIllegalArgumentException {
        super(tree, tolerance);
        Sphere2D.checkTolerance(tolerance);
    }

    public SphericalPolygonsSet(Collection<SubHyperplane<Sphere2D>> boundary, double tolerance) throws MathIllegalArgumentException {
        super(boundary, tolerance);
        Sphere2D.checkTolerance(tolerance);
    }

    public SphericalPolygonsSet(double hyperplaneThickness, S2Point ... vertices) throws MathIllegalArgumentException {
        super(SphericalPolygonsSet.verticesToTree(hyperplaneThickness, vertices), hyperplaneThickness);
        Sphere2D.checkTolerance(hyperplaneThickness);
    }

    private static S2Point[] createRegularPolygonVertices(Vector3D center, Vector3D meridian, double outsideRadius, int n) {
        S2Point[] array = new S2Point[n];
        Rotation r0 = new Rotation(Vector3D.crossProduct(center, meridian), outsideRadius, RotationConvention.VECTOR_OPERATOR);
        array[0] = new S2Point(r0.applyTo(center));
        Rotation r = new Rotation(center, Math.PI * 2 / (double)n, RotationConvention.VECTOR_OPERATOR);
        for (int i = 1; i < n; ++i) {
            array[i] = new S2Point(r.applyTo(array[i - 1].getVector()));
        }
        return array;
    }

    private static BSPTree<Sphere2D> verticesToTree(double hyperplaneThickness, S2Point ... vertices) {
        int n = (vertices = SphericalPolygonsSet.reduce(hyperplaneThickness, vertices).toArray(new S2Point[0])).length;
        if (n == 0) {
            return new BSPTree<Sphere2D>(Boolean.TRUE);
        }
        Vertex[] vArray = new Vertex[n];
        for (int i = 0; i < n; ++i) {
            vArray[i] = new Vertex(vertices[i]);
        }
        ArrayList<Edge> edges = new ArrayList<Edge>(n);
        Vertex end = vArray[n - 1];
        for (int i = 0; i < n; ++i) {
            Vertex start = end;
            end = vArray[i];
            Circle circle = new Circle(start.getLocation(), end.getLocation(), hyperplaneThickness);
            edges.add(new Edge(start, end, Vector3D.angle(start.getLocation().getVector(), end.getLocation().getVector()), circle));
        }
        BSPTree<Sphere2D> tree = new BSPTree<Sphere2D>();
        SphericalPolygonsSet.insertEdges(hyperplaneThickness, tree, edges);
        return tree;
    }

    private static List<S2Point> reduce(double hyperplaneThickness, S2Point[] vertices) {
        int lastFinal;
        IntPredicate onCircle;
        int n = vertices.length;
        if (n <= 3) {
            return Arrays.asList((Object[])vertices.clone());
        }
        ArrayList<S2Point> points = new ArrayList<S2Point>();
        IntPredicate onCircleBackward = j -> {
            int i = n - 2 - j;
            Circle circle = new Circle(vertices[0], vertices[i], hyperplaneThickness);
            Arc arc = circle.getArc(vertices[0], vertices[i]);
            if (arc.getSize() >= Math.PI) {
                return false;
            }
            for (int k = i + 1; k < n; ++k) {
                S2Point vertex = vertices[k];
                if (!(FastMath.abs((double)circle.getOffset(vertex)) > hyperplaneThickness) && !(arc.getOffset((S1Point)circle.toSubSpace((Point)vertex)) > 0.0)) continue;
                return false;
            }
            return true;
        };
        int last = n - 2 - SphericalPolygonsSet.searchHelper(onCircleBackward, 0, n - 2);
        if (last <= 1) {
            return Arrays.asList(Arrays.copyOfRange(vertices, 0, 3));
        }
        points.add(vertices[last]);
        int first = last;
        int j2 = 1;
        while ((j2 = SphericalPolygonsSet.searchHelper(onCircle = arg_0 -> SphericalPolygonsSet.lambda$reduce$1(vertices, lastFinal = last, hyperplaneThickness, n, arg_0), j2, first + 1)) < first) {
            last = j2;
            points.add(vertices[last]);
            j2 += 2;
        }
        S2Point swap = (S2Point)points.remove(0);
        points.add(swap);
        return points;
    }

    private static int searchHelper(IntPredicate predicate, int a, int b) {
        if (a > b) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, new Object[]{a, b});
        }
        if (a == b) {
            return a;
        }
        if (!predicate.test(a)) {
            return a - 1;
        }
        int start = a;
        int end = b;
        int i = 2;
        while (a + i < b) {
            if (!predicate.test(a + i)) {
                end = a + i;
                break;
            }
            start = a + i;
            i *= 2;
        }
        int low = start;
        int high = end - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (predicate.test(mid)) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low - 1;
    }

    private static void insertEdges(double hyperplaneThickness, BSPTree<Sphere2D> node, List<Edge> edges) {
        int index = 0;
        Edge inserted = null;
        while (inserted == null && index < edges.size()) {
            if (node.insertCut((inserted = edges.get(index++)).getCircle())) continue;
            inserted = null;
        }
        if (inserted == null) {
            BSPTree<Sphere2D> parent = node.getParent();
            if (parent == null || node == parent.getMinus()) {
                node.setAttribute(Boolean.TRUE);
            } else {
                node.setAttribute(Boolean.FALSE);
            }
            return;
        }
        ArrayList<Edge> outsideList = new ArrayList<Edge>();
        ArrayList<Edge> insideList = new ArrayList<Edge>();
        for (Edge edge : edges) {
            if (edge == inserted) continue;
            edge.split(inserted.getCircle(), outsideList, insideList);
        }
        if (!outsideList.isEmpty()) {
            SphericalPolygonsSet.insertEdges(hyperplaneThickness, node.getPlus(), outsideList);
        } else {
            node.getPlus().setAttribute(Boolean.FALSE);
        }
        if (!insideList.isEmpty()) {
            SphericalPolygonsSet.insertEdges(hyperplaneThickness, node.getMinus(), insideList);
        } else {
            node.getMinus().setAttribute(Boolean.TRUE);
        }
    }

    public SphericalPolygonsSet buildNew(BSPTree<Sphere2D> tree) {
        return new SphericalPolygonsSet(tree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() throws MathIllegalStateException {
        BSPTree<Sphere2D> tree = this.getTree(true);
        if (tree.getCut() == null) {
            if (tree.getCut() == null && ((Boolean)tree.getAttribute()).booleanValue()) {
                this.setSize(Math.PI * 4);
                this.setBarycenter(new S2Point(0.0, 0.0));
            } else {
                this.setSize(0.0);
                this.setBarycenter(S2Point.NaN);
            }
        } else {
            PropertiesComputer pc = new PropertiesComputer(this.getTolerance());
            tree.visit(pc);
            this.setSize(pc.getArea());
            this.setBarycenter(pc.getBarycenter());
        }
    }

    public List<Vertex> getBoundaryLoops() throws MathIllegalStateException {
        if (this.loops == null) {
            if (this.getTree(false).getCut() == null) {
                this.loops = Collections.emptyList();
            } else {
                EdgesWithNodeInfoBuilder visitor = new EdgesWithNodeInfoBuilder(this.getTolerance());
                this.getTree(true).visit(visitor);
                List<EdgeWithNodeInfo> edges = visitor.getEdges();
                int pending = edges.size();
                if ((pending -= this.naturalFollowerConnections(edges)) > 0) {
                    pending -= this.splitEdgeConnections(edges);
                }
                if (pending > 0) {
                    pending -= this.closeVerticesConnections(edges);
                }
                this.loops = new ArrayList<Vertex>();
                EdgeWithNodeInfo s = this.getUnprocessed(edges);
                while (s != null) {
                    this.loops.add(s.getStart());
                    this.followLoop(s);
                    s = this.getUnprocessed(edges);
                }
            }
        }
        return Collections.unmodifiableList(this.loops);
    }

    private int naturalFollowerConnections(List<EdgeWithNodeInfo> edges) {
        int connected = 0;
        block0: for (EdgeWithNodeInfo edge : edges) {
            if (edge.getEnd().getOutgoing() != null) continue;
            for (EdgeWithNodeInfo candidateNext : edges) {
                if (!EdgeWithNodeInfo.areNaturalFollowers(edge, candidateNext)) continue;
                edge.setNextEdge(candidateNext);
                ++connected;
                continue block0;
            }
        }
        return connected;
    }

    private int splitEdgeConnections(List<EdgeWithNodeInfo> edges) {
        int connected = 0;
        block0: for (EdgeWithNodeInfo edge : edges) {
            if (edge.getEnd().getOutgoing() != null) continue;
            for (EdgeWithNodeInfo candidateNext : edges) {
                if (!EdgeWithNodeInfo.resultFromASplit(edge, candidateNext)) continue;
                edge.setNextEdge(candidateNext);
                ++connected;
                continue block0;
            }
        }
        return connected;
    }

    private int closeVerticesConnections(List<EdgeWithNodeInfo> edges) {
        int connected = 0;
        for (EdgeWithNodeInfo edge : edges) {
            if (edge.getEnd().getOutgoing() != null || edge.getEnd() == null) continue;
            Vector3D end = edge.getEnd().getLocation().getVector();
            EdgeWithNodeInfo selectedNext = null;
            double min = Double.POSITIVE_INFINITY;
            for (EdgeWithNodeInfo candidateNext : edges) {
                double distance;
                if (candidateNext.getStart().getIncoming() != null || !((distance = Vector3D.distance(end, candidateNext.getStart().getLocation().getVector())) < min)) continue;
                selectedNext = candidateNext;
                min = distance;
            }
            if (!(min <= this.getTolerance())) continue;
            edge.setNextEdge(selectedNext);
            ++connected;
        }
        return connected;
    }

    private EdgeWithNodeInfo getUnprocessed(List<EdgeWithNodeInfo> edges) {
        for (EdgeWithNodeInfo edge : edges) {
            if (edge.isProcessed()) continue;
            return edge;
        }
        return null;
    }

    private void followLoop(EdgeWithNodeInfo defining) {
        defining.setProcessed(true);
        EdgeWithNodeInfo previous = defining;
        EdgeWithNodeInfo next = (EdgeWithNodeInfo)defining.getEnd().getOutgoing();
        while (next != defining) {
            if (next == null) {
                throw new MathIllegalStateException((Localizable)LocalizedGeometryFormats.OUTLINE_BOUNDARY_LOOP_OPEN, new Object[0]);
            }
            next.setProcessed(true);
            if (Vector3D.angle(previous.getCircle().getPole(), next.getCircle().getPole()) <= Precision.EPSILON) {
                previous.setNextEdge(next.getEnd().getOutgoing());
                previous.setLength(previous.getLength() + next.getLength());
            }
            previous = next;
            next = (EdgeWithNodeInfo)next.getEnd().getOutgoing();
        }
    }

    public EnclosingBall<Sphere2D, S2Point> getEnclosingCap() {
        if (this.isEmpty()) {
            return new EnclosingBall((Point)S2Point.PLUS_K, Double.NEGATIVE_INFINITY, (Point[])new S2Point[0]);
        }
        if (this.isFull()) {
            return new EnclosingBall((Point)S2Point.PLUS_K, Double.POSITIVE_INFINITY, (Point[])new S2Point[0]);
        }
        BSPTree root = this.getTree(false);
        if (this.isEmpty(root.getMinus()) && this.isFull(root.getPlus())) {
            Circle circle = (Circle)root.getCut().getHyperplane();
            return new EnclosingBall((Point)new S2Point(circle.getPole()).negate(), 1.5707963267948966, (Point[])new S2Point[0]);
        }
        if (this.isFull(root.getMinus()) && this.isEmpty(root.getPlus())) {
            Circle circle = (Circle)root.getCut().getHyperplane();
            return new EnclosingBall((Point)new S2Point(circle.getPole()), 1.5707963267948966, (Point[])new S2Point[0]);
        }
        List<Vector3D> points = this.getInsidePoints();
        List<Vertex> boundary = this.getBoundaryLoops();
        for (Vertex loopStart : boundary) {
            Vertex v = loopStart;
            for (int count = 0; count == 0 || v != loopStart; ++count) {
                points.add(v.getLocation().getVector());
                v = v.getOutgoing().getEnd();
            }
        }
        SphereGenerator generator = new SphereGenerator();
        WelzlEncloser<Euclidean3D, Vector3D> encloser = new WelzlEncloser<Euclidean3D, Vector3D>(this.getTolerance(), generator);
        EnclosingBall<Euclidean3D, Vector3D> enclosing3D = encloser.enclose(points);
        Vector3D[] support3D = (Vector3D[])enclosing3D.getSupport();
        double r = enclosing3D.getRadius();
        double h = enclosing3D.getCenter().getNorm();
        if (h < this.getTolerance()) {
            EnclosingBall enclosingS2 = new EnclosingBall((Point)S2Point.PLUS_K, Double.POSITIVE_INFINITY, (Point[])new S2Point[0]);
            for (Vector3D outsidePoint : this.getOutsidePoints()) {
                S2Point outsideS2 = new S2Point(outsidePoint);
                BoundaryProjection<Sphere2D> projection = this.projectToBoundary(outsideS2);
                if (!(Math.PI - projection.getOffset() < enclosingS2.getRadius())) continue;
                enclosingS2 = new EnclosingBall((Point)outsideS2.negate(), Math.PI - projection.getOffset(), (Point[])new S2Point[]{(S2Point)projection.getProjected()});
            }
            return enclosingS2;
        }
        Point[] support = new S2Point[support3D.length];
        for (int i = 0; i < support3D.length; ++i) {
            support[i] = new S2Point(support3D[i]);
        }
        return new EnclosingBall((Point)new S2Point(enclosing3D.getCenter()), FastMath.acos((double)((1.0 + h * h - r * r) / (2.0 * h))), support);
    }

    private List<Vector3D> getInsidePoints() {
        PropertiesComputer pc = new PropertiesComputer(this.getTolerance());
        this.getTree(true).visit(pc);
        return pc.getConvexCellsInsidePoints();
    }

    private List<Vector3D> getOutsidePoints() {
        SphericalPolygonsSet complement = (SphericalPolygonsSet)new RegionFactory<Sphere2D>().getComplement(this);
        PropertiesComputer pc = new PropertiesComputer(this.getTolerance());
        complement.getTree(true).visit(pc);
        return pc.getConvexCellsInsidePoints();
    }

    private static /* synthetic */ boolean lambda$reduce$1(S2Point[] vertices, int lastFinal, double hyperplaneThickness, int n, int i) {
        Circle circle = new Circle(vertices[lastFinal], vertices[i], hyperplaneThickness);
        Arc arc = circle.getArc(vertices[lastFinal], vertices[i]);
        if (arc.getSize() >= Math.PI) {
            return false;
        }
        int end = lastFinal < i ? i : i + n;
        for (int k = lastFinal + 1; k < end; ++k) {
            S2Point vertex = vertices[k % n];
            if (!(FastMath.abs((double)circle.getOffset(vertex)) > hyperplaneThickness) && !(arc.getOffset((S1Point)circle.toSubSpace((Point)vertex)) > 0.0)) continue;
            return false;
        }
        return true;
    }
}

