/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.raster;

import java.lang.reflect.Array;
import org.hipparchus.util.FastMath;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.raster.Tile;
import org.orekit.rugged.raster.TileFactory;
import org.orekit.rugged.raster.TileUpdater;
import org.orekit.rugged.raster.UpdatableTile;

public class TilesCache<T extends Tile> {
    private final TileFactory<T> factory;
    private final TileUpdater updater;
    private final T[] tiles;

    public TilesCache(TileFactory<T> factory, TileUpdater updater, int maxTiles) {
        this.factory = factory;
        this.updater = updater;
        Tile[] array = (Tile[])Array.newInstance(Tile.class, maxTiles);
        this.tiles = array;
    }

    public T getTile(double latitude, double longitude) {
        int i;
        for (i = 0; i < this.tiles.length; ++i) {
            T tile = this.tiles[i];
            if (tile == null || tile.getLocation(latitude, longitude) != Tile.Location.HAS_INTERPOLATION_NEIGHBORS) continue;
            while (i > 0) {
                this.tiles[i] = this.tiles[i - 1];
                --i;
            }
            this.tiles[0] = tile;
            return tile;
        }
        for (i = this.tiles.length - 1; i > 0; --i) {
            this.tiles[i] = this.tiles[i - 1];
        }
        T tile = this.factory.createTile();
        Boolean wasSuspended = DumpManager.suspend();
        this.updater.updateTile(latitude, longitude, (UpdatableTile)tile);
        DumpManager.resume(wasSuspended);
        tile.tileUpdateCompleted();
        if (tile.getLocation(latitude, longitude) != Tile.Location.HAS_INTERPOLATION_NEIGHBORS) {
            throw new RuggedException(RuggedMessages.TILE_WITHOUT_REQUIRED_NEIGHBORS_SELECTED, FastMath.toDegrees((double)latitude), FastMath.toDegrees((double)longitude));
        }
        this.tiles[0] = tile;
        return tile;
    }
}

