/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.los;

import java.util.stream.Stream;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.rugged.los.TimeIndependentLOSTransform;
import org.orekit.rugged.utils.DerivativeGenerator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;

public class FixedRotation
implements TimeIndependentLOSTransform {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-20);
    private final Vector3D axis;
    private Rotation rotation;
    private FieldRotation<?> rDS;
    private final ParameterDriver angleDriver;

    public FixedRotation(String name, Vector3D axis, double angle) {
        this.axis = axis;
        this.rotation = null;
        this.rDS = null;
        this.angleDriver = new ParameterDriver(name, angle, this.SCALE, Math.PI * -2, Math.PI * 2);
        this.angleDriver.addObserver(new ParameterObserver(){

            public void valueChanged(double previousValue, ParameterDriver driver) {
                FixedRotation.this.rotation = null;
                FixedRotation.this.rDS = null;
            }
        });
    }

    @Override
    public Stream<ParameterDriver> getParametersDrivers() {
        return Stream.of(this.angleDriver);
    }

    @Override
    public Vector3D transformLOS(int i, Vector3D los) {
        if (this.rotation == null) {
            this.rotation = new Rotation(this.axis, this.angleDriver.getValue(), RotationConvention.VECTOR_OPERATOR);
        }
        return this.rotation.applyTo(los);
    }

    @Override
    public <T extends Derivative<T>> FieldVector3D<T> transformLOS(int i, FieldVector3D<T> los, DerivativeGenerator<T> generator) {
        FieldRotation rD;
        if (this.rDS == null || !this.rDS.getQ0().getField().equals(generator.getField())) {
            FieldVector3D axisDS = new FieldVector3D(generator.constant(this.axis.getX()), generator.constant(this.axis.getY()), generator.constant(this.axis.getZ()));
            T angleDS = generator.variable(this.angleDriver);
            this.rDS = rD = new FieldRotation(axisDS, angleDS, RotationConvention.VECTOR_OPERATOR);
        } else {
            rD = this.rDS;
        }
        return rD.applyTo(los);
    }
}

