/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.RealFieldElement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TDBScale;
import org.orekit.time.TimeScale;

public class TCBScale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private static final double LB_RATE = 1.550519768E-8;
    private final AbsoluteDate referenceDate;
    private final TDBScale tdb;

    TCBScale(TDBScale tdb, TimeScale tai) {
        this.tdb = tdb;
        this.referenceDate = new AbsoluteDate(1977, 1, 1, tai);
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        return this.tdb.offsetFromTAI(date) + 1.550519768E-8 * date.durationFrom(this.referenceDate);
    }

    @Override
    public <T extends RealFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        return (T)((RealFieldElement)this.tdb.offsetFromTAI(date).add(date.durationFrom(this.referenceDate).multiply(1.550519768E-8)));
    }

    @Override
    public String getName() {
        return "TCB";
    }

    public String toString() {
        return this.getName();
    }
}

