/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AggregateBoundedPropagator
extends AbstractAnalyticalPropagator
implements BoundedPropagator {
    private final NavigableMap<AbsoluteDate, BoundedPropagator> propagators = new TreeMap<AbsoluteDate, BoundedPropagator>();

    public AggregateBoundedPropagator(Collection<? extends BoundedPropagator> propagators) {
        super(AggregateBoundedPropagator.defaultAttitude(propagators));
        for (BoundedPropagator boundedPropagator : propagators) {
            this.propagators.put(boundedPropagator.getMinDate(), boundedPropagator);
        }
        super.resetInitialState(this.propagators.firstEntry().getValue().getInitialState());
    }

    private static AttitudeProvider defaultAttitude(Collection<? extends BoundedPropagator> propagators) {
        if (propagators.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_PROPAGATORS, new Object[0]);
        }
        return new InertialProvider(propagators.iterator().next().getFrame());
    }

    @Override
    protected SpacecraftState basicPropagate(AbsoluteDate date) {
        SpacecraftState state = this.getPropagator(date).propagate(date);
        Attitude attitude = this.getAttitudeProvider().getAttitude(this, date, state.getFrame());
        if (state.isOrbitDefined()) {
            return new SpacecraftState(state.getOrbit(), attitude, state.getMass(), state.getAdditionalStates());
        }
        return new SpacecraftState(state.getAbsPVA(), attitude, state.getMass(), state.getAdditionalStates());
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        return this.getPropagator(date).getPVCoordinates(date, frame);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        return this.getPropagator(date).propagate(date).getOrbit();
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.propagators.firstEntry().getValue().getMinDate();
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.propagators.lastEntry().getValue().getMaxDate();
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.getPropagator(date).propagate(date).getMass();
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.propagators.firstEntry().getValue().getInitialState();
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    private BoundedPropagator getPropagator(AbsoluteDate date) {
        Map.Entry<AbsoluteDate, BoundedPropagator> entry = this.propagators.floorEntry(date);
        if (entry != null) {
            return entry.getValue();
        }
        return this.propagators.firstEntry().getValue();
    }
}

