/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.nonstiff.DormandPrince853Integrator;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.bodies.CR3BPSystem;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.LibrationOrbitType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.HaloXZPlaneCrossingDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.cr3bp.CR3BPForceModel;
import org.orekit.propagation.numerical.cr3bp.STMEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.PVCoordinates;

public class CR3BPDifferentialCorrection {
    private boolean cross;
    private final PVCoordinates firstGuess;
    private final CR3BPSystem syst;
    private final double orbitalPeriodApprox;
    private double orbitalPeriod;
    private final NumericalPropagator propagator;
    private final TimeScale utc;

    @DefaultDataContext
    public CR3BPDifferentialCorrection(PVCoordinates firstguess, CR3BPSystem syst, double orbitalPeriod) {
        this(firstguess, syst, orbitalPeriod, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()), DataContext.getDefault().getTimeScales().getUTC());
    }

    public CR3BPDifferentialCorrection(PVCoordinates firstguess, CR3BPSystem syst, double orbitalPeriod, AttitudeProvider attitudeProvider, TimeScale utc) {
        this.firstGuess = firstguess;
        this.syst = syst;
        this.orbitalPeriodApprox = orbitalPeriod;
        this.utc = utc;
        double minStep = 1.0E-12;
        double maxstep = 0.001;
        double positionTolerance = 1.0E-5;
        double velocityTolerance = 1.0E-5;
        double massTolerance = 1.0E-6;
        double[] vecAbsoluteTolerances = new double[]{1.0E-5, 1.0E-5, 1.0E-5, 1.0E-5, 1.0E-5, 1.0E-5, 1.0E-6};
        double[] vecRelativeTolerances = new double[vecAbsoluteTolerances.length];
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(1.0E-12, 0.001, vecAbsoluteTolerances, vecRelativeTolerances);
        this.propagator = new NumericalPropagator((ODEIntegrator)integrator, attitudeProvider);
    }

    public PVCoordinates compute(LibrationOrbitType type) {
        double maxcheck = 10.0;
        double threshold = 1.0E-10;
        HaloXZPlaneCrossingDetector XZPlaneCrossing = new HaloXZPlaneCrossingDetector(10.0, 1.0E-10).withHandler(new PlaneCrossingHandler());
        STMEquations stm = new STMEquations(this.syst);
        this.propagator.setOrbitType(null);
        this.propagator.setIgnoreCentralAttraction(true);
        this.propagator.addForceModel(new CR3BPForceModel(this.syst));
        this.propagator.addAdditionalEquations(stm);
        this.propagator.addEventDetector(XZPlaneCrossing);
        return type == LibrationOrbitType.HALO ? this.computeHalo(stm) : this.computeLyapunov(stm);
    }

    private PVCoordinates computeHalo(STMEquations stm) {
        double iHalo = 0.0;
        AbsoluteDate startDateHalo = new AbsoluteDate(1996, 6, 25, 0, 0, 0.0, this.utc);
        PVCoordinates pvHalo = this.firstGuess;
        do {
            AbsolutePVCoordinates initialAbsPVHalo = new AbsolutePVCoordinates(this.syst.getRotatingFrame(), startDateHalo, pvHalo);
            SpacecraftState initialStateHalo = new SpacecraftState(initialAbsPVHalo);
            SpacecraftState augmentedInitialStateHalo = stm.setInitialPhi(initialStateHalo);
            this.cross = false;
            this.propagator.setInitialState(augmentedInitialStateHalo);
            SpacecraftState finalStateHalo = this.propagator.propagate(startDateHalo.shiftedBy(this.orbitalPeriodApprox));
            if (!this.cross) {
                throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_NOT_CROSSING_XZPLANE, new Object[0]);
            }
            RealMatrix phiHalo = stm.getStateTransitionMatrix(finalStateHalo);
            double dvxf = -finalStateHalo.getPVCoordinates().getVelocity().getX();
            double dvzf = -finalStateHalo.getPVCoordinates().getVelocity().getZ();
            this.orbitalPeriod = 2.0 * finalStateHalo.getDate().durationFrom(startDateHalo);
            if (!(FastMath.abs((double)dvxf) > 1.0E-8) && !(FastMath.abs((double)dvzf) > 1.0E-8)) break;
            double vy = finalStateHalo.getPVCoordinates().getVelocity().getY();
            Vector3D acc = finalStateHalo.getPVCoordinates().getAcceleration();
            double accx = acc.getX();
            double accz = acc.getZ();
            double a11 = phiHalo.getEntry(3, 0) - accx * phiHalo.getEntry(1, 0) / vy;
            double a12 = phiHalo.getEntry(3, 4) - accx * phiHalo.getEntry(1, 4) / vy;
            double a21 = phiHalo.getEntry(5, 0) - accz * phiHalo.getEntry(1, 0) / vy;
            double a22 = phiHalo.getEntry(5, 4) - accz * phiHalo.getEntry(1, 4) / vy;
            double aDet = a11 * a22 - a21 * a12;
            double deltax0 = (a22 * dvxf - a12 * dvzf) / aDet;
            double deltavy0 = (-a21 * dvxf + a11 * dvzf) / aDet;
            double newx = pvHalo.getPosition().getX() + deltax0;
            double newvy = pvHalo.getVelocity().getY() + deltavy0;
            pvHalo = new PVCoordinates(new Vector3D(newx, pvHalo.getPosition().getY(), pvHalo.getPosition().getZ()), new Vector3D(pvHalo.getVelocity().getX(), newvy, pvHalo.getVelocity().getZ()));
        } while ((iHalo += 1.0) < 30.0);
        return pvHalo;
    }

    public PVCoordinates computeLyapunov(STMEquations stm) {
        double iLyapunov = 0.0;
        AbsoluteDate startDateLyapunov = new AbsoluteDate(1996, 6, 25, 0, 0, 0.0, this.utc);
        PVCoordinates pvLyapunov = this.firstGuess;
        do {
            AbsolutePVCoordinates initialAbsPVLyapunov = new AbsolutePVCoordinates(this.syst.getRotatingFrame(), startDateLyapunov, pvLyapunov);
            SpacecraftState initialStateLyapunov = new SpacecraftState(initialAbsPVLyapunov);
            SpacecraftState augmentedInitialStateLyapunov = stm.setInitialPhi(initialStateLyapunov);
            this.cross = false;
            this.propagator.setInitialState(augmentedInitialStateLyapunov);
            SpacecraftState finalStateLyapunov = this.propagator.propagate(startDateLyapunov.shiftedBy(this.orbitalPeriodApprox));
            if (!this.cross) {
                throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_NOT_CROSSING_XZPLANE, new Object[0]);
            }
            RealMatrix phi = stm.getStateTransitionMatrix(finalStateLyapunov);
            double dvxf = -finalStateLyapunov.getPVCoordinates().getVelocity().getX();
            this.orbitalPeriod = 2.0 * finalStateLyapunov.getDate().durationFrom(startDateLyapunov);
            if (!(FastMath.abs((double)dvxf) > 1.0E-14)) break;
            double vy = finalStateLyapunov.getPVCoordinates().getVelocity().getY();
            double accy = finalStateLyapunov.getPVCoordinates().getAcceleration().getY();
            double deltavy0 = dvxf / (phi.getEntry(3, 4) - accy * phi.getEntry(1, 4) / vy);
            double newvy = pvLyapunov.getVelocity().getY() + deltavy0;
            pvLyapunov = new PVCoordinates(new Vector3D(pvLyapunov.getPosition().getX(), pvLyapunov.getPosition().getY(), 0.0), new Vector3D(pvLyapunov.getVelocity().getX(), newvy, 0.0));
        } while ((iLyapunov += 1.0) < 30.0);
        return pvLyapunov;
    }

    public double getOrbitalPeriod() {
        return this.orbitalPeriod;
    }

    private class PlaneCrossingHandler
    implements EventHandler<HaloXZPlaneCrossingDetector> {
        private PlaneCrossingHandler() {
        }

        @Override
        public Action eventOccurred(SpacecraftState s, HaloXZPlaneCrossingDetector detector, boolean increasing) {
            CR3BPDifferentialCorrection.this.cross = true;
            return Action.STOP;
        }
    }
}

