/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import java.io.Serializable;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.frames.TopocentricFrame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public interface IonosphericModel
extends Serializable {
    public double pathDelay(SpacecraftState var1, TopocentricFrame var2, double var3, double[] var5);

    public <T extends RealFieldElement<T>> T pathDelay(FieldSpacecraftState<T> var1, TopocentricFrame var2, double var3, T[] var5);

    public List<ParameterDriver> getParametersDrivers();

    default public double[] getParameters() {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        double[] parameters = new double[drivers.size()];
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = drivers.get(i).getValue();
        }
        return parameters;
    }

    default public <T extends RealFieldElement<T>> T[] getParameters(Field<T> field) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        RealFieldElement[] parameters = (RealFieldElement[])MathArrays.buildArray(field, (int)drivers.size());
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(drivers.get(i).getValue());
        }
        return parameters;
    }
}

