/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.forces.radiation.AbstractRadiationForceModel;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class SolarRadiationPressure
extends AbstractRadiationForceModel {
    private static final double D_REF = 1.4959787E11;
    private static final double P_REF = 4.56E-6;
    private static final double ANGULAR_MARGIN = 1.0E-10;
    private final double kRef;
    private final ExtendedPVCoordinatesProvider sun;
    private final RadiationSensitive spacecraft;

    public SolarRadiationPressure(ExtendedPVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft) {
        this(1.4959787E11, 4.56E-6, sun, equatorialRadius, spacecraft);
    }

    public SolarRadiationPressure(double dRef, double pRef, ExtendedPVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft) {
        super(sun, equatorialRadius);
        this.kRef = pRef * dRef * dRef;
        this.sun = sun;
        this.spacecraft = spacecraft;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D position = s.getPVCoordinates().getPosition();
        Vector3D sunSatVector = position.subtract((Vector)this.sun.getPVCoordinates(date, frame).getPosition());
        double r2 = sunSatVector.getNormSq();
        double ratio = this.getLightingRatio(position, frame, date);
        double rawP = ratio * this.kRef / r2;
        Vector3D flux = new Vector3D(rawP / FastMath.sqrt((double)r2), sunSatVector);
        return this.spacecraft.radiationPressureAcceleration(date, frame, position, s.getAttitude().getRotation(), s.getMass(), flux, parameters);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldAbsoluteDate<T> date = s.getDate();
        Frame frame = s.getFrame();
        FieldVector3D position = s.getPVCoordinates().getPosition();
        FieldVector3D sunSatVector = position.subtract(this.sun.getPVCoordinates(date.toAbsoluteDate(), frame).getPosition());
        RealFieldElement r2 = sunSatVector.getNormSq();
        Object ratio = this.getLightingRatio(position, frame, date);
        RealFieldElement rawP = (RealFieldElement)((RealFieldElement)ratio.divide((Object)r2)).multiply(this.kRef);
        FieldVector3D flux = new FieldVector3D((RealFieldElement)rawP.divide(r2.sqrt()), sunSatVector);
        return this.spacecraft.radiationPressureAcceleration(date, frame, position, (FieldRotation)s.getAttitude().getRotation(), (RealFieldElement)s.getMass(), flux, (RealFieldElement[])parameters);
    }

    public double getLightingRatio(Vector3D position, Frame frame, AbsoluteDate date) {
        Vector3D sunPosition = this.sun.getPVCoordinates(date, frame).getPosition();
        if (sunPosition.getNorm() < 1.391E9) {
            return 1.0;
        }
        double[] angle = this.getEclipseAngles(sunPosition, position);
        double sunSatCentralBodyAngle = angle[0];
        double alphaCentral = angle[1];
        double alphaSun = angle[2];
        double result = 1.0;
        if (sunSatCentralBodyAngle - alphaCentral + alphaSun <= 1.0E-10) {
            result = 0.0;
        } else if (sunSatCentralBodyAngle - alphaCentral - alphaSun < -1.0E-10) {
            double sEA2 = sunSatCentralBodyAngle * sunSatCentralBodyAngle;
            double oo2sEA = 1.0 / (2.0 * sunSatCentralBodyAngle);
            double aS2 = alphaSun * alphaSun;
            double aE2 = alphaCentral * alphaCentral;
            double aE2maS2 = aE2 - aS2;
            double alpha1 = (sEA2 - aE2maS2) * oo2sEA;
            double alpha2 = (sEA2 + aE2maS2) * oo2sEA;
            double almost0 = Precision.SAFE_MIN;
            double almost1 = FastMath.nextDown((double)1.0);
            double a1oaS = FastMath.min((double)almost1, (double)FastMath.max((double)(-almost1), (double)(alpha1 / alphaSun)));
            double aS2ma12 = FastMath.max((double)almost0, (double)(aS2 - alpha1 * alpha1));
            double a2oaE = FastMath.min((double)almost1, (double)FastMath.max((double)(-almost1), (double)(alpha2 / alphaCentral)));
            double aE2ma22 = FastMath.max((double)almost0, (double)(aE2 - alpha2 * alpha2));
            double P1 = aS2 * FastMath.acos((double)a1oaS) - alpha1 * FastMath.sqrt((double)aS2ma12);
            double P2 = aE2 * FastMath.acos((double)a2oaE) - alpha2 * FastMath.sqrt((double)aE2ma22);
            result = 1.0 - (P1 + P2) / (Math.PI * aS2);
        }
        return result;
    }

    public <T extends RealFieldElement<T>> T getLightingRatio(FieldVector3D<T> position, Frame frame, FieldAbsoluteDate<T> date) {
        RealFieldElement one = (RealFieldElement)date.getField().getOne();
        FieldVector3D sunPosition = this.sun.getPVCoordinates(date, frame).getPosition();
        if (sunPosition.getNorm().getReal() < 1.391E9) {
            return (T)one;
        }
        RealFieldElement[] angle = this.getEclipseAngles(sunPosition, position);
        RealFieldElement sunsatCentralBodyAngle = angle[0];
        RealFieldElement alphaCentral = angle[1];
        RealFieldElement alphaSun = angle[2];
        RealFieldElement result = one;
        if (sunsatCentralBodyAngle.getReal() - alphaCentral.getReal() + alphaSun.getReal() <= 1.0E-10) {
            result = (RealFieldElement)date.getField().getZero();
        } else if (sunsatCentralBodyAngle.getReal() - alphaCentral.getReal() - alphaSun.getReal() < -1.0E-10) {
            RealFieldElement sEA2 = (RealFieldElement)sunsatCentralBodyAngle.multiply((Object)sunsatCentralBodyAngle);
            RealFieldElement oo2sEA = (RealFieldElement)((RealFieldElement)sunsatCentralBodyAngle.multiply(2)).reciprocal();
            RealFieldElement aS2 = (RealFieldElement)alphaSun.multiply((Object)alphaSun);
            RealFieldElement aE2 = (RealFieldElement)alphaCentral.multiply((Object)alphaCentral);
            RealFieldElement aE2maS2 = (RealFieldElement)aE2.subtract((Object)aS2);
            RealFieldElement alpha1 = (RealFieldElement)((RealFieldElement)sEA2.subtract((Object)aE2maS2)).multiply((Object)oo2sEA);
            RealFieldElement alpha2 = (RealFieldElement)((RealFieldElement)sEA2.add((Object)aE2maS2)).multiply((Object)oo2sEA);
            double almost0 = Precision.SAFE_MIN;
            double almost1 = FastMath.nextDown((double)1.0);
            RealFieldElement a1oaS = this.min(almost1, this.max(-almost1, (RealFieldElement)alpha1.divide((Object)alphaSun)));
            RealFieldElement aS2ma12 = this.max(almost0, (RealFieldElement)aS2.subtract(alpha1.multiply((Object)alpha1)));
            RealFieldElement a2oaE = this.min(almost1, this.max(-almost1, (RealFieldElement)alpha2.divide((Object)alphaCentral)));
            RealFieldElement aE2ma22 = this.max(almost0, (RealFieldElement)aE2.subtract(alpha2.multiply((Object)alpha2)));
            RealFieldElement P1 = (RealFieldElement)((RealFieldElement)aS2.multiply(a1oaS.acos())).subtract(alpha1.multiply(aS2ma12.sqrt()));
            RealFieldElement P2 = (RealFieldElement)((RealFieldElement)aE2.multiply(a2oaE.acos())).subtract(alpha2.multiply(aE2ma22.sqrt()));
            result = (RealFieldElement)one.subtract(((RealFieldElement)P1.add((Object)P2)).divide(aS2.multiply(Math.PI)));
        }
        return (T)result;
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return this.spacecraft.getRadiationParametersDrivers();
    }

    private <T extends RealFieldElement<T>> T min(double d, T f) {
        return (T)(f.getReal() > d ? (RealFieldElement)((RealFieldElement)f.getField().getZero()).add(d) : f);
    }

    private <T extends RealFieldElement<T>> T max(double d, T f) {
        return (T)(f.getReal() <= d ? (RealFieldElement)((RealFieldElement)f.getField().getZero()).add(d) : f);
    }
}

