/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.trigger;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.ode.events.Action;
import org.orekit.forces.maneuvers.trigger.ManeuverTriggers;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldDateDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class DateBasedManeuverTriggers
implements ManeuverTriggers {
    private final AbsoluteDate startDate;
    private final AbsoluteDate endDate;
    private AbsoluteDate triggeredStart;
    private AbsoluteDate triggeredEnd;
    private boolean forward;

    public DateBasedManeuverTriggers(AbsoluteDate date, double duration) {
        if (duration >= 0.0) {
            this.startDate = date;
            this.endDate = date.shiftedBy(duration);
        } else {
            this.endDate = date;
            this.startDate = this.endDate.shiftedBy(duration);
        }
        this.triggeredStart = null;
        this.triggeredEnd = null;
    }

    public AbsoluteDate getStartDate() {
        return this.startDate;
    }

    public AbsoluteDate getEndDate() {
        return this.endDate;
    }

    public double getDuration() {
        return this.endDate.durationFrom(this.startDate);
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        AbsoluteDate sDate = initialState.getDate();
        this.forward = sDate.compareTo(target) < 0;
        boolean isBetween = sDate.isBetween(this.startDate, this.endDate);
        boolean isOnStart = this.startDate.compareTo(sDate) == 0;
        boolean isOnEnd = this.endDate.compareTo(sDate) == 0;
        this.triggeredStart = null;
        this.triggeredEnd = null;
        if (this.forward) {
            if (isBetween || isOnStart) {
                this.triggeredStart = this.startDate;
            }
        } else if (isBetween || isOnEnd) {
            this.triggeredEnd = this.endDate;
        }
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        DateDetector startDetector = new DateDetector(this.startDate).withHandler((state, d, increasing) -> {
            this.triggeredStart = state.getDate();
            return Action.RESET_DERIVATIVES;
        });
        DateDetector endDetector = new DateDetector(this.endDate).withHandler((state, d, increasing) -> {
            this.triggeredEnd = state.getDate();
            return Action.RESET_DERIVATIVES;
        });
        return Stream.of(startDetector, endDetector);
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        FieldDateDetector startDetector = new FieldDateDetector(new FieldAbsoluteDate<T>(field, this.startDate)).withHandler((state, d, increasing) -> {
            this.triggeredStart = state.getDate().toAbsoluteDate();
            return Action.RESET_DERIVATIVES;
        });
        FieldDateDetector endDetector = new FieldDateDetector(new FieldAbsoluteDate<T>(field, this.endDate)).withHandler((state, d, increasing) -> {
            this.triggeredEnd = state.getDate().toAbsoluteDate();
            return Action.RESET_DERIVATIVES;
        });
        return Stream.of(startDetector, endDetector);
    }

    @Override
    public boolean isFiring(AbsoluteDate date, double[] parameters) {
        return this.isFiring(date);
    }

    @Override
    public <T extends RealFieldElement<T>> boolean isFiring(FieldAbsoluteDate<T> date, T[] parameters) {
        return this.isFiring(date.toAbsoluteDate());
    }

    public boolean isFiring(AbsoluteDate date) {
        if (this.forward) {
            if (this.triggeredStart == null) {
                return false;
            }
            if (date.durationFrom(this.triggeredStart) < 0.0) {
                return false;
            }
            if (this.triggeredEnd == null) {
                return true;
            }
            return date.durationFrom(this.triggeredEnd) < 0.0;
        }
        if (this.triggeredEnd == null) {
            return false;
        }
        if (date.durationFrom(this.triggeredEnd) > 0.0) {
            return false;
        }
        if (this.triggeredStart == null) {
            return true;
        }
        return date.durationFrom(this.triggeredStart) > 0.0;
    }
}

