/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.inertia;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.AbstractForceModel;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.utils.ParameterDriver;

public class InertialForces
extends AbstractForceModel {
    private Frame referenceInertialFrame;

    public InertialForces(Frame referenceInertialFrame) throws OrekitIllegalArgumentException {
        if (!referenceInertialFrame.isPseudoInertial()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_PSEUDO_INERTIAL_FRAME_NOT_SUITABLE_AS_REFERENCE_FOR_INERTIAL_FORCES, referenceInertialFrame.getName());
        }
        this.referenceInertialFrame = referenceInertialFrame;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        Transform inertToStateFrame = this.referenceInertialFrame.getTransformTo(s.getFrame(), s.getDate());
        Vector3D a1 = inertToStateFrame.getCartesian().getAcceleration();
        Rotation r1 = inertToStateFrame.getAngular().getRotation();
        Vector3D o1 = inertToStateFrame.getAngular().getRotationRate();
        Vector3D oDot1 = inertToStateFrame.getAngular().getRotationAcceleration();
        Vector3D p2 = s.getPVCoordinates().getPosition();
        Vector3D v2 = s.getPVCoordinates().getVelocity();
        Vector3D crossCrossP = Vector3D.crossProduct((Vector3D)o1, (Vector3D)Vector3D.crossProduct((Vector3D)o1, (Vector3D)p2));
        Vector3D crossV = Vector3D.crossProduct((Vector3D)o1, (Vector3D)v2);
        Vector3D crossDotP = Vector3D.crossProduct((Vector3D)oDot1, (Vector3D)p2);
        return r1.applyTo(a1).subtract((Vector)new Vector3D(2.0, crossV, 1.0, crossCrossP, 1.0, crossDotP));
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldTransform<T> inertToStateFrame = this.referenceInertialFrame.getTransformTo(s.getFrame(), s.getDate());
        FieldVector3D<T> a1 = inertToStateFrame.getCartesian().getAcceleration();
        FieldRotation<T> r1 = inertToStateFrame.getAngular().getRotation();
        FieldVector3D<T> o1 = inertToStateFrame.getAngular().getRotationRate();
        FieldVector3D<T> oDot1 = inertToStateFrame.getAngular().getRotationAcceleration();
        FieldVector3D p2 = s.getPVCoordinates().getPosition();
        FieldVector3D v2 = s.getPVCoordinates().getVelocity();
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(o1, (FieldVector3D)FieldVector3D.crossProduct(o1, p2));
        FieldVector3D crossV = FieldVector3D.crossProduct(o1, v2);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(oDot1, p2);
        return r1.applyTo(a1).subtract(new FieldVector3D(2.0, crossV, 1.0, crossCrossP, 1.0, crossDotP));
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[0];
    }

    @Override
    public ParameterDriver getParameterDriver(String name) {
        throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, "<none>");
    }
}

