/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.empirical;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.forces.AbstractForceModel;
import org.orekit.forces.empirical.AccelerationModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class ParametricAcceleration
extends AbstractForceModel {
    private final Vector3D direction;
    private final boolean isInertial;
    private final AttitudeProvider attitudeOverride;
    private final AccelerationModel accelerationModel;

    public ParametricAcceleration(Vector3D direction, boolean isInertial, AccelerationModel accelerationModel) {
        this(direction, isInertial, null, accelerationModel);
    }

    public ParametricAcceleration(Vector3D direction, AttitudeProvider attitudeOverride, AccelerationModel accelerationModel) {
        this(direction, false, attitudeOverride, accelerationModel);
    }

    private ParametricAcceleration(Vector3D direction, boolean isInertial, AttitudeProvider attitudeOverride, AccelerationModel accelerationModel) {
        this.direction = direction;
        this.isInertial = isInertial;
        this.attitudeOverride = attitudeOverride;
        this.accelerationModel = accelerationModel;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return this.isInertial;
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return this.accelerationModel.getParametersDrivers();
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        this.accelerationModel.init(initialState, target);
    }

    @Override
    public Vector3D acceleration(SpacecraftState state, double[] parameters) {
        Vector3D inertialDirection;
        if (this.isInertial) {
            inertialDirection = this.direction;
        } else {
            Attitude attitude = this.attitudeOverride == null ? state.getAttitude() : this.attitudeOverride.getAttitude(state.getOrbit(), state.getDate(), state.getFrame());
            inertialDirection = attitude.getRotation().applyInverseTo(this.direction);
        }
        return new Vector3D(this.accelerationModel.signedAmplitude(state, parameters), inertialDirection);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> state, T[] parameters) {
        FieldVector3D inertialDirection;
        if (this.isInertial) {
            inertialDirection = new FieldVector3D(state.getDate().getField(), this.direction);
        } else {
            FieldAttitude<T> attitude = this.attitudeOverride == null ? state.getAttitude() : this.attitudeOverride.getAttitude(state.getOrbit(), state.getDate(), state.getFrame());
            inertialDirection = attitude.getRotation().applyInverseTo(this.direction);
        }
        return new FieldVector3D(this.accelerationModel.signedAmplitude(state, (RealFieldElement[])parameters), inertialDirection);
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }
}

