/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sinex;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.time.AbsoluteDate;

public class Station {
    private String siteCode;
    private String domes;
    private AbsoluteDate validFrom;
    private AbsoluteDate validUntil;
    private ReferenceSystem eccRefSystem;
    private Vector3D eccentricities = Vector3D.ZERO;
    private Vector3D position = Vector3D.ZERO;
    private Vector3D velocity = Vector3D.ZERO;
    private AbsoluteDate epoch;

    public String getSiteCode() {
        return this.siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getDomes() {
        return this.domes;
    }

    public void setDomes(String domes) {
        this.domes = domes;
    }

    public AbsoluteDate getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(AbsoluteDate validFrom) {
        this.validFrom = validFrom;
    }

    public AbsoluteDate getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(AbsoluteDate validUntil) {
        this.validUntil = validUntil;
    }

    public ReferenceSystem getEccRefSystem() {
        return this.eccRefSystem;
    }

    public void setEccRefSystem(ReferenceSystem eccRefSystem) {
        this.eccRefSystem = eccRefSystem;
    }

    public Vector3D getEccentricities() {
        return this.eccentricities;
    }

    public void setEccentricities(Vector3D eccentricities) {
        this.eccentricities = eccentricities;
    }

    public Vector3D getPosition() {
        return this.position;
    }

    public void setPosition(Vector3D position) {
        this.position = position;
    }

    public Vector3D getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3D velocity) {
        this.velocity = velocity;
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public void setEpoch(AbsoluteDate epoch) {
        this.epoch = epoch;
    }

    public static enum ReferenceSystem {
        UNE("UNE"),
        XYZ("XYZ");

        private static final Map<String, ReferenceSystem> CODES_MAP;
        private final String name;

        private ReferenceSystem(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static ReferenceSystem getEccRefSystem(String value) {
            return CODES_MAP.get(value);
        }

        static {
            CODES_MAP = new HashMap<String, ReferenceSystem>();
            for (ReferenceSystem type : ReferenceSystem.values()) {
                CODES_MAP.put(type.getName(), type);
            }
        }
    }
}

