/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.io.IOException;
import java.util.List;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFile;
import org.orekit.files.general.EphemerisFileWriter;
import org.orekit.files.ilrs.CPFHeader;
import org.orekit.files.ilrs.StreamingCpfWriter;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeStampedPVCoordinates;

public class CPFWriter
implements EphemerisFileWriter {
    private final CPFHeader header;

    public CPFWriter(CPFHeader header) {
        this.header = header;
    }

    @Override
    public void write(Appendable writer, EphemerisFile ephemerisFile) throws IOException {
        if (writer == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "writer");
        }
        if (ephemerisFile == null) {
            return;
        }
        EphemerisFile.SatelliteEphemeris satEphem = ephemerisFile.getSatellites().get(this.header.getIlrsSatelliteId());
        List<? extends EphemerisFile.EphemerisSegment> segments = satEphem.getSegments();
        EphemerisFile.EphemerisSegment firstSegment = segments.get(0);
        TimeScale timeScale = firstSegment.getTimeScale();
        StreamingCpfWriter cpfWriter = new StreamingCpfWriter(writer, timeScale, this.header);
        cpfWriter.writeHeader();
        for (EphemerisFile.EphemerisSegment ephemerisSegment : segments) {
            StreamingCpfWriter.Segment segmentWriter = cpfWriter.newSegment(this.header.getRefFrame());
            for (TimeStampedPVCoordinates timeStampedPVCoordinates : ephemerisSegment.getCoordinates()) {
                segmentWriter.writeEphemerisLine(timeStampedPVCoordinates);
            }
        }
        cpfWriter.writeEndOfFile();
    }
}

