/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.gnss.OneWayGNSSRange;
import org.orekit.frames.Transform;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OnBoardAntennaOneWayGNSSRangeModifier
implements EstimationModifier<OneWayGNSSRange> {
    private final Vector3D antennaPhaseCenter1;
    private final Vector3D antennaPhaseCenter2;
    private final AttitudeProvider attitude;

    public OnBoardAntennaOneWayGNSSRangeModifier(Vector3D antennaPhaseCenter1, Vector3D antennaPhaseCenter2, AttitudeProvider attitude) {
        this.antennaPhaseCenter1 = antennaPhaseCenter1;
        this.antennaPhaseCenter2 = antennaPhaseCenter2;
        this.attitude = attitude;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<OneWayGNSSRange> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        AbsoluteDate emissionDate = participants[0].getDate();
        AbsoluteDate receptionDate = participants[1].getDate();
        SpacecraftState refStateLocal = estimated.getStates()[0];
        SpacecraftState receptionState = refStateLocal.shiftedBy(receptionDate.durationFrom(refStateLocal.getDate()));
        Transform receptionSpacecraftToInert = receptionState.toTransform().getInverse();
        CartesianOrbit orbitRemote = new CartesianOrbit(participants[0], refStateLocal.getFrame(), receptionState.getMu());
        SpacecraftState refStateRemote = new SpacecraftState((Orbit)orbitRemote, this.attitude.getAttitude(orbitRemote, orbitRemote.getDate(), orbitRemote.getFrame()));
        SpacecraftState emissionState = refStateRemote.shiftedBy(emissionDate.durationFrom(refStateRemote.getDate()));
        Transform emissionSpacecraftToInert = emissionState.toTransform().getInverse();
        Vector3D pSpacecraftReception = receptionSpacecraftToInert.transformPosition(Vector3D.ZERO);
        Vector3D pSpacecraftEmission = emissionSpacecraftToInert.transformPosition(Vector3D.ZERO);
        double oneWayGNSSRangeUsingSpacecraftCenter = Vector3D.distance((Vector3D)pSpacecraftEmission, (Vector3D)pSpacecraftReception);
        Vector3D pAPCReception = receptionSpacecraftToInert.transformPosition(this.antennaPhaseCenter1);
        Vector3D pAPCEmission = emissionSpacecraftToInert.transformPosition(this.antennaPhaseCenter2);
        double oneWayGNSSRangeUsingAntennaPhaseCenter = Vector3D.distance((Vector3D)pAPCEmission, (Vector3D)pAPCReception);
        double[] value = estimated.getEstimatedValue();
        value[0] = value[0] + (oneWayGNSSRangeUsingAntennaPhaseCenter - oneWayGNSSRangeUsingSpacecraftCenter);
        estimated.setEstimatedValue(value);
    }
}

