/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TurnAroundRange
extends AbstractMeasurement<TurnAroundRange> {
    private final GroundStation masterStation;
    private final GroundStation slaveStation;

    public TurnAroundRange(GroundStation masterStation, GroundStation slaveStation, AbsoluteDate date, double turnAroundRange, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(date, turnAroundRange, sigma, baseWeight, Arrays.asList(satellite));
        this.addParameterDriver(masterStation.getClockOffsetDriver());
        this.addParameterDriver(masterStation.getEastOffsetDriver());
        this.addParameterDriver(masterStation.getNorthOffsetDriver());
        this.addParameterDriver(masterStation.getZenithOffsetDriver());
        this.addParameterDriver(masterStation.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(masterStation.getPrimeMeridianDriftDriver());
        this.addParameterDriver(masterStation.getPolarOffsetXDriver());
        this.addParameterDriver(masterStation.getPolarDriftXDriver());
        this.addParameterDriver(masterStation.getPolarOffsetYDriver());
        this.addParameterDriver(masterStation.getPolarDriftYDriver());
        this.addParameterDriver(slaveStation.getEastOffsetDriver());
        this.addParameterDriver(slaveStation.getNorthOffsetDriver());
        this.addParameterDriver(slaveStation.getZenithOffsetDriver());
        this.addParameterDriver(slaveStation.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(slaveStation.getPrimeMeridianDriftDriver());
        this.addParameterDriver(slaveStation.getPolarOffsetXDriver());
        this.addParameterDriver(slaveStation.getPolarDriftXDriver());
        this.addParameterDriver(slaveStation.getPolarOffsetYDriver());
        this.addParameterDriver(slaveStation.getPolarDriftYDriver());
        this.masterStation = masterStation;
        this.slaveStation = slaveStation;
    }

    public GroundStation getMasterStation() {
        return this.masterStation;
    }

    public GroundStation getSlaveStation() {
        return this.slaveStation;
    }

    @Override
    protected EstimatedMeasurement<TurnAroundRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected() || indices.containsKey(driver.getName())) continue;
            indices.put(driver.getName(), nbParams++);
        }
        GradientField field = GradientField.getField((int)nbParams);
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        TimeStampedFieldPVCoordinates<Gradient> pvaDS = TurnAroundRange.getCoordinates(state, 0, nbParams);
        double delta = this.getDate().durationFrom(state.getDate());
        FieldTransform<Gradient> masterToInert = this.masterStation.getOffsetToInertial(state.getFrame(), this.getDate(), nbParams, indices);
        FieldAbsoluteDate<Gradient> measurementDateDS = masterToInert.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> masterArrival = masterToInert.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(measurementDateDS, zero, zero, zero));
        Gradient masterTauD = TurnAroundRange.signalTimeOfFlight(pvaDS, masterArrival.getPosition(), measurementDateDS);
        Gradient dtLeg2 = masterTauD.negate().add(delta);
        SpacecraftState transitStateLeg2 = state.shiftedBy(dtLeg2.getValue());
        FieldPVCoordinates transitStateLeg2PV = pvaDS.shiftedBy((RealFieldElement)dtLeg2);
        TimeShiftable approxReboundDate = measurementDateDS.shiftedBy(-delta);
        FieldTransform<Gradient> slaveToInertApprox = this.slaveStation.getOffsetToInertial(state.getFrame(), (FieldAbsoluteDate<Gradient>)approxReboundDate, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> QSlaveApprox = slaveToInertApprox.transformPVCoordinates(new TimeStampedFieldPVCoordinates(approxReboundDate, zero, zero, zero));
        Gradient slaveTauU = TurnAroundRange.signalTimeOfFlight(QSlaveApprox, transitStateLeg2PV.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateLeg2PV).getDate());
        Gradient tauLeg2 = masterTauD.add(slaveTauU);
        FieldAbsoluteDate<Gradient> reboundDateDS = measurementDateDS.shiftedBy(tauLeg2.negate());
        FieldTransform<Gradient> slaveToInert = this.slaveStation.getOffsetToInertial(state.getFrame(), reboundDateDS, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> slaveRebound = slaveToInert.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(reboundDateDS, FieldPVCoordinates.getZero(field)));
        Gradient slaveTauD = TurnAroundRange.signalTimeOfFlight(transitStateLeg2PV, slaveRebound.getPosition(), reboundDateDS);
        Gradient dtLeg1 = dtLeg2.subtract(slaveTauU).subtract(slaveTauD);
        FieldPVCoordinates transitStateLeg1PV = pvaDS.shiftedBy((RealFieldElement)dtLeg1);
        TimeShiftable approxEmissionDate = measurementDateDS.shiftedBy(-2.0 * (slaveTauU.getValue() + masterTauD.getValue()));
        FieldTransform<Gradient> masterToInertApprox = this.masterStation.getOffsetToInertial(state.getFrame(), (FieldAbsoluteDate<Gradient>)approxEmissionDate, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> QMasterApprox = masterToInertApprox.transformPVCoordinates(new TimeStampedFieldPVCoordinates(approxEmissionDate, zero, zero, zero));
        Gradient masterTauU = TurnAroundRange.signalTimeOfFlight(QMasterApprox, transitStateLeg1PV.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).getDate());
        AbsoluteDate emissionDate = ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).getDate().toAbsoluteDate().shiftedBy(-masterTauU.getValue());
        TimeStampedPVCoordinates masterDeparture = ((FieldTransform)masterToInertApprox.shiftedBy(emissionDate.durationFrom(masterToInertApprox.getDate()))).transformPVCoordinates(new TimeStampedPVCoordinates(emissionDate, PVCoordinates.ZERO)).toTimeStampedPVCoordinates();
        Gradient tauLeg1 = slaveTauD.add(masterTauU);
        EstimatedMeasurement<TurnAroundRange> estimated = new EstimatedMeasurement<TurnAroundRange>(this, iteration, evaluation, new SpacecraftState[]{transitStateLeg2.shiftedBy(-slaveTauU.getValue())}, new TimeStampedPVCoordinates[]{masterDeparture, ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).toTimeStampedPVCoordinates(), slaveRebound.toTimeStampedPVCoordinates(), transitStateLeg2.getPVCoordinates(), masterArrival.toTimeStampedPVCoordinates()});
        double cOver2 = 1.49896229E8;
        Gradient turnAroundRange = tauLeg2.add(tauLeg1).multiply(1.49896229E8);
        estimated.setEstimatedValue(turnAroundRange.getValue());
        double[] derivatives = turnAroundRange.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index]);
        }
        return estimated;
    }
}

