/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.random;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.random.BaseRandomGenerator;

abstract class IntRandomGenerator
extends BaseRandomGenerator {
    IntRandomGenerator() {
    }

    @Override
    public abstract int nextInt();

    @Override
    public boolean nextBoolean() {
        return this.nextInt() >>> 31 != 0;
    }

    @Override
    public double nextDouble() {
        long high = (long)(this.nextInt() >>> 6) << 26;
        int low = this.nextInt() >>> 6;
        return (double)(high | (long)low) * 2.220446049250313E-16;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextInt() >>> 9) * 1.1920929E-7f;
    }

    @Override
    public long nextLong() {
        return (long)this.nextInt() << 32 | (long)this.nextInt() & 0xFFFFFFFFL;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.nextBytesFill(bytes, 0, bytes.length);
    }

    @Override
    public void nextBytes(byte[] bytes, int start, int len) {
        if (start < 0 || start >= bytes.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, start, 0, bytes.length);
        }
        if (len < 0 || len > bytes.length - start) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, len, 0, bytes.length - start);
        }
        this.nextBytesFill(bytes, start, len);
    }

    private void nextBytesFill(byte[] bytes, int offset, int len) {
        int index = offset;
        int indexLoopLimit = index + (len & 0x7FFFFFFC);
        while (index < indexLoopLimit) {
            int random = this.nextInt();
            bytes[index++] = (byte)random;
            bytes[index++] = (byte)(random >>> 8);
            bytes[index++] = (byte)(random >>> 16);
            bytes[index++] = (byte)(random >>> 24);
        }
        int indexLimit = offset + len;
        if (index < indexLimit) {
            int random = this.nextInt();
            while (true) {
                bytes[index++] = (byte)random;
                if (index >= indexLimit) break;
                random >>>= 8;
            }
        }
    }
}

