/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.distribution.EnumeratedDistribution;
import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Pair;

public class EnumeratedRealDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20130308L;
    private final EnumeratedDistribution<Double> innerDistribution;

    public EnumeratedRealDistribution(double[] data) {
        HashMap<Double, Integer> dataMap = new HashMap<Double, Integer>();
        for (double value : data) {
            Integer count = (Integer)dataMap.get(value);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            dataMap.put(value, count);
        }
        int massPoints = dataMap.size();
        double denom = data.length;
        double[] values = new double[massPoints];
        double[] probabilities = new double[massPoints];
        int index = 0;
        for (Map.Entry entry : dataMap.entrySet()) {
            values[index] = (Double)entry.getKey();
            probabilities[index] = (double)((Integer)entry.getValue()).intValue() / denom;
            ++index;
        }
        this.innerDistribution = new EnumeratedDistribution(EnumeratedRealDistribution.createDistribution(values, probabilities));
    }

    public EnumeratedRealDistribution(double[] singletons, double[] probabilities) throws MathIllegalArgumentException {
        this.innerDistribution = new EnumeratedDistribution(EnumeratedRealDistribution.createDistribution(singletons, probabilities));
    }

    private static List<Pair<Double, Double>> createDistribution(double[] singletons, double[] probabilities) {
        MathArrays.checkEqualLength(singletons, probabilities);
        ArrayList<Pair<Double, Double>> samples = new ArrayList<Pair<Double, Double>>(singletons.length);
        double[] normalizedProbabilities = EnumeratedDistribution.checkAndNormalize(probabilities);
        for (int i = 0; i < singletons.length; ++i) {
            samples.add(new Pair<Double, Double>(singletons[i], normalizedProbabilities[i]));
        }
        return samples;
    }

    public double probability(double x) {
        return this.innerDistribution.probability(x);
    }

    @Override
    public double density(double x) {
        return this.probability(x);
    }

    @Override
    public double cumulativeProbability(double x) {
        double probability = 0.0;
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            if (!(sample.getKey() <= x)) continue;
            probability += sample.getValue().doubleValue();
        }
        return probability;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        double probability = 0.0;
        double x = this.getSupportLowerBound();
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            if (sample.getValue() == 0.0) continue;
            probability += sample.getValue().doubleValue();
            x = sample.getKey();
            if (!(probability >= p)) continue;
            break;
        }
        return x;
    }

    @Override
    public double getNumericalMean() {
        double mean = 0.0;
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            mean += sample.getValue() * sample.getKey();
        }
        return mean;
    }

    @Override
    public double getNumericalVariance() {
        double mean = 0.0;
        double meanOfSquares = 0.0;
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            mean += sample.getValue() * sample.getKey();
            meanOfSquares += sample.getValue() * sample.getKey() * sample.getKey();
        }
        return meanOfSquares - mean * mean;
    }

    @Override
    public double getSupportLowerBound() {
        double min = Double.POSITIVE_INFINITY;
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            if (!(sample.getKey() < min) || !(sample.getValue() > 0.0)) continue;
            min = sample.getKey();
        }
        return min;
    }

    @Override
    public double getSupportUpperBound() {
        double max = Double.NEGATIVE_INFINITY;
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            if (!(sample.getKey() > max) || !(sample.getValue() > 0.0)) continue;
            max = sample.getKey();
        }
        return max;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    public List<Pair<Double, Double>> getPmf() {
        return this.innerDistribution.getPmf();
    }
}

