/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.errors;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.OpenIntToDoubleHashMap;
import org.hipparchus.util.Pair;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.rugged.api.AlgorithmId;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedInternalError;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.linesensor.SensorMeanPlaneCrossing;
import org.orekit.rugged.linesensor.SensorPixel;
import org.orekit.rugged.raster.Tile;
import org.orekit.rugged.utils.ExtendedEllipsoid;
import org.orekit.rugged.utils.SpacecraftToObservedBody;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;

class Dump {
    private final PrintWriter writer;
    private final List<DumpedTileData> tiles;
    private final List<DumpedSensorData> sensors;
    private boolean algorithmDumped;
    private boolean ellipsoidDumped;
    private boolean[] tranformsDumped;

    Dump(PrintWriter writer) {
        this.writer = writer;
        this.tiles = new ArrayList<DumpedTileData>();
        this.sensors = new ArrayList<DumpedSensorData>();
        this.algorithmDumped = false;
        this.ellipsoidDumped = false;
        this.tranformsDumped = null;
        this.dumpHeader();
    }

    private void dumpHeader() {
        this.writer.format(Locale.US, "# Rugged library dump file, created on %1$tFT%1$tTZ%n", Calendar.getInstance(TimeZone.getTimeZone("Etc/UTC"), Locale.US));
        this.writer.format(Locale.US, "# all units are SI units (m, m/s, rad ...)%n", new Object[0]);
    }

    public void dumpTileCell(Tile tile, int latitudeIndex, int longitudeIndex, double elevation) {
        this.getTileData(tile).setElevation(latitudeIndex, longitudeIndex, elevation);
    }

    public void dumpAlgorithm(AlgorithmId algorithmId) {
        if (!this.algorithmDumped) {
            this.writer.format(Locale.US, "algorithm: %s%n", algorithmId.name());
            this.algorithmDumped = true;
        }
    }

    public void dumpAlgorithm(AlgorithmId algorithmId, double specific) {
        if (!this.algorithmDumped) {
            this.writer.format(Locale.US, "algorithm: %s elevation %22.15e%n", algorithmId.name(), specific);
            this.algorithmDumped = true;
        }
    }

    public void dumpEllipsoid(ExtendedEllipsoid ellipsoid) {
        if (!this.ellipsoidDumped) {
            this.writer.format(Locale.US, "ellipsoid: ae %22.15e f %22.15e frame %s%n", ellipsoid.getA(), ellipsoid.getFlattening(), this.getKeyOrName(ellipsoid.getBodyFrame()));
            this.ellipsoidDumped = true;
        }
    }

    public void dumpDirectLocation(AbsoluteDate date, Vector3D sensorPosition, Vector3D los, boolean lightTimeCorrection, boolean aberrationOfLightCorrection, boolean refractionCorrection) {
        this.writer.format(Locale.US, "direct location: date %s position %22.15e %22.15e %22.15e los %22.15e %22.15e %22.15e lightTime %b aberration %b refraction %b %n", this.convertDate(date), sensorPosition.getX(), sensorPosition.getY(), sensorPosition.getZ(), los.getX(), los.getY(), los.getZ(), lightTimeCorrection, aberrationOfLightCorrection, refractionCorrection);
    }

    public void dumpDirectLocationResult(GeodeticPoint gp) {
        if (gp != null) {
            this.writer.format(Locale.US, "direct location result: latitude %22.15e longitude %22.15e elevation %22.15e%n", gp.getLatitude(), gp.getLongitude(), gp.getAltitude());
        } else {
            this.writer.format(Locale.US, "direct location result: NULL", new Object[0]);
        }
    }

    public void dumpInverseLocation(LineSensor sensor, GeodeticPoint point, int minLine, int maxLine, boolean lightTimeCorrection, boolean aberrationOfLightCorrection, boolean refractionCorrection) {
        DumpedSensorData ds = this.getSensorData(sensor);
        this.writer.format(Locale.US, "inverse location: sensorName %s latitude %22.15e longitude %22.15e elevation %22.15e minLine %d maxLine %d lightTime %b aberration %b refraction %b %n", ds.getDumpName(), point.getLatitude(), point.getLongitude(), point.getAltitude(), minLine, maxLine, lightTimeCorrection, aberrationOfLightCorrection, refractionCorrection);
    }

    public void dumpInverseLocationResult(SensorPixel pixel) {
        if (pixel != null) {
            this.writer.format(Locale.US, "inverse location result: lineNumber %22.15e pixelNumber %22.15e%n", pixel.getLineNumber(), pixel.getPixelNumber());
        } else {
            this.writer.format(Locale.US, "inverse location result: NULL", new Object[0]);
        }
    }

    public void dumpTransform(SpacecraftToObservedBody scToBody, int index, Transform bodyToInertial, Transform scToInertial) {
        if (this.tranformsDumped == null) {
            AbsoluteDate minDate = scToBody.getMinDate();
            AbsoluteDate maxDate = scToBody.getMaxDate();
            double tStep = scToBody.getTStep();
            double tolerance = scToBody.getOvershootTolerance();
            int n = (int)FastMath.ceil((double)(maxDate.durationFrom(minDate) / tStep));
            this.writer.format(Locale.US, "span: minDate %s maxDate %s tStep %22.15e tolerance %22.15e inertialFrame %s%n", this.convertDate(minDate), this.convertDate(maxDate), tStep, tolerance, this.getKeyOrName(scToBody.getInertialFrame()));
            this.tranformsDumped = new boolean[n];
        }
        if (!this.tranformsDumped[index]) {
            this.writer.format(Locale.US, "transform: index %d body %s spacecraft %s %s%n", index, this.convertRotation(bodyToInertial.getRotation(), bodyToInertial.getRotationRate(), bodyToInertial.getRotationAcceleration()), this.convertTranslation(scToInertial.getTranslation(), scToInertial.getVelocity(), scToInertial.getAcceleration()), this.convertRotation(scToInertial.getRotation(), scToInertial.getRotationRate(), scToInertial.getRotationAcceleration()));
            this.tranformsDumped[index] = true;
        }
    }

    public void dumpSensorMeanPlane(SensorMeanPlaneCrossing meanPlane) {
        this.getSensorData(meanPlane.getSensor()).setMeanPlane(meanPlane);
    }

    public void dumpSensorLOS(LineSensor sensor, AbsoluteDate date, int i, Vector3D los) {
        this.getSensorData(sensor).setLOS(date, i, los);
    }

    public void dumpSensorDatation(LineSensor sensor, double lineNumber, AbsoluteDate date) {
        this.getSensorData(sensor).setDatation(lineNumber, date);
    }

    public void dumpSensorRate(LineSensor sensor, double lineNumber, double rate) {
        this.getSensorData(sensor).setRate(lineNumber, rate);
    }

    private String getKeyOrName(Frame frame) {
        if (frame instanceof FactoryManagedFrame) {
            return ((FactoryManagedFrame)frame).getFactoryKey().toString();
        }
        return frame.getName();
    }

    private DumpedTileData getTileData(Tile tile) {
        for (DumpedTileData dumpedTileData : this.tiles) {
            if (tile != dumpedTileData.getTile()) continue;
            return dumpedTileData;
        }
        DumpedTileData dumpedTileData = new DumpedTileData("t" + this.tiles.size(), tile);
        this.tiles.add(dumpedTileData);
        dumpedTileData.setElevation(tile.getMinElevationLatitudeIndex(), tile.getMinElevationLongitudeIndex(), tile.getMinElevation());
        dumpedTileData.setElevation(tile.getMaxElevationLatitudeIndex(), tile.getMaxElevationLongitudeIndex(), tile.getMaxElevation());
        return dumpedTileData;
    }

    private DumpedSensorData getSensorData(LineSensor sensor) {
        for (DumpedSensorData dumpedSensorData : this.sensors) {
            if (sensor != dumpedSensorData.getSensor()) continue;
            return dumpedSensorData;
        }
        DumpedSensorData dumpedSensorData = new DumpedSensorData("s" + this.sensors.size(), sensor);
        this.sensors.add(dumpedSensorData);
        return dumpedSensorData;
    }

    private String convertDate(AbsoluteDate date) {
        DateTimeComponents dt = date.getComponents((TimeScale)TimeScalesFactory.getUTC());
        return String.format(Locale.US, "%04d-%02d-%02dT%02d:%02d:%017.14fZ", dt.getDate().getYear(), dt.getDate().getMonth(), dt.getDate().getDay(), dt.getTime().getHour(), dt.getTime().getMinute(), dt.getTime().getSecond());
    }

    private String convertTranslation(Vector3D translation, Vector3D velocity, Vector3D acceleration) {
        return String.format(Locale.US, "p %22.15e %22.15e %22.15e v %22.15e %22.15e %22.15e a %22.15e %22.15e %22.15e", translation.getX(), translation.getY(), translation.getZ(), velocity.getX(), velocity.getY(), velocity.getZ(), acceleration.getX(), acceleration.getY(), acceleration.getZ());
    }

    private String convertRotation(Rotation rotation, Vector3D rate, Vector3D acceleration) {
        return String.format(Locale.US, "r %22.15e %22.15e %22.15e %22.15e \u03a9 %22.15e %22.15e %22.15e \u03a9Dot %22.15e %22.15e %22.15e", rotation.getQ0(), rotation.getQ1(), rotation.getQ2(), rotation.getQ3(), rate.getX(), rate.getY(), rate.getZ(), acceleration.getX(), acceleration.getY(), acceleration.getZ());
    }

    public void deactivate() {
        this.writer.close();
    }

    private class DumpedSensorData {
        private final String dumpName;
        private final LineSensor sensor;
        private final Map<Integer, List<Pair<AbsoluteDate, Vector3D>>> losMap;
        private final List<Pair<Double, AbsoluteDate>> datation;
        private final List<Pair<Double, Double>> rates;
        private SensorMeanPlaneCrossing meanPlane;

        DumpedSensorData(String dumpName, LineSensor sensor) {
            this.dumpName = dumpName;
            this.sensor = sensor;
            this.losMap = new HashMap<Integer, List<Pair<AbsoluteDate, Vector3D>>>();
            this.datation = new ArrayList<Pair<Double, AbsoluteDate>>();
            this.rates = new ArrayList<Pair<Double, Double>>();
            Dump.this.writer.format(Locale.US, "sensor: sensorName %s nbPixels %d position %22.15e %22.15e %22.15e%n", dumpName, sensor.getNbPixels(), sensor.getPosition().getX(), sensor.getPosition().getY(), sensor.getPosition().getZ());
        }

        public String getDumpName() {
            return this.dumpName;
        }

        public LineSensor getSensor() {
            return this.sensor;
        }

        public void setMeanPlane(SensorMeanPlaneCrossing meanPlane) {
            if (this.meanPlane == null) {
                this.meanPlane = meanPlane;
                long nbResults = meanPlane.getCachedResults().count();
                Dump.this.writer.format(Locale.US, "sensor mean plane: sensorName %s minLine %d maxLine %d maxEval %d accuracy %22.15e normal %22.15e %22.15e %22.15e cachedResults %d", this.dumpName, meanPlane.getMinLine(), meanPlane.getMaxLine(), meanPlane.getMaxEval(), meanPlane.getAccuracy(), meanPlane.getMeanPlaneNormal().getX(), meanPlane.getMeanPlaneNormal().getY(), meanPlane.getMeanPlaneNormal().getZ(), nbResults);
                meanPlane.getCachedResults().forEach(result -> {
                    try {
                        Dump.this.writer.format(Locale.US, " lineNumber %22.15e date %s target %22.15e %22.15e %22.15e targetDirection %22.15e %22.15e %22.15e %22.15e %22.15e %22.15e", result.getLine(), Dump.this.convertDate(result.getDate()), result.getTarget().getX(), result.getTarget().getY(), result.getTarget().getZ(), result.getTargetDirection().getX(), result.getTargetDirection().getY(), result.getTargetDirection().getZ(), result.getTargetDirectionDerivative().getZ(), result.getTargetDirectionDerivative().getY(), result.getTargetDirectionDerivative().getZ());
                    }
                    catch (RuggedException re) {
                        throw new RuggedInternalError(re);
                    }
                });
                Dump.this.writer.format(Locale.US, "%n", new Object[0]);
                AbsoluteDate midDate = meanPlane.getSensor().getDate(0.5 * (double)(meanPlane.getMinLine() + meanPlane.getMaxLine()));
                meanPlane.getScToBody().getBodyToInertial(midDate);
                meanPlane.getScToBody().getScToInertial(midDate);
            }
        }

        public void setLOS(AbsoluteDate date, int pixelNumber, Vector3D los) {
            List<Pair<AbsoluteDate, Vector3D>> list = this.losMap.get(pixelNumber);
            if (list == null) {
                list = new ArrayList<Pair<AbsoluteDate, Vector3D>>();
                this.losMap.put(pixelNumber, list);
            }
            for (Pair<AbsoluteDate, Vector3D> alreadyDumped : list) {
                if (!(FastMath.abs((double)date.durationFrom((AbsoluteDate)alreadyDumped.getFirst())) < 1.0E-12) || !(Vector3D.angle((Vector3D)los, (Vector3D)((Vector3D)alreadyDumped.getSecond())) < 1.0E-12)) continue;
                return;
            }
            list.add((Pair<AbsoluteDate, Vector3D>)new Pair((Object)date, (Object)los));
            Dump.this.writer.format(Locale.US, "sensor LOS: sensorName %s date %s pixelNumber %d los %22.15e %22.15e %22.15e%n", this.dumpName, Dump.this.convertDate(date), pixelNumber, los.getX(), los.getY(), los.getZ());
        }

        public void setDatation(double lineNumber, AbsoluteDate date) {
            for (Pair<Double, AbsoluteDate> alreadyDumped : this.datation) {
                if (!(FastMath.abs((double)date.durationFrom((AbsoluteDate)alreadyDumped.getSecond())) < 1.0E-12) || !(FastMath.abs((double)(lineNumber - (Double)alreadyDumped.getFirst())) < 1.0E-12)) continue;
                return;
            }
            this.datation.add((Pair<Double, AbsoluteDate>)new Pair((Object)lineNumber, (Object)date));
            Dump.this.writer.format(Locale.US, "sensor datation: sensorName %s lineNumber %22.15e date %s%n", this.dumpName, lineNumber, Dump.this.convertDate(date));
        }

        public void setRate(double lineNumber, double rate) {
            for (Pair<Double, Double> alreadyDumped : this.rates) {
                if (!(FastMath.abs((double)(rate - (Double)alreadyDumped.getSecond())) < 1.0E-12) || !(FastMath.abs((double)(lineNumber - (Double)alreadyDumped.getFirst())) < 1.0E-12)) continue;
                return;
            }
            this.rates.add((Pair<Double, Double>)new Pair((Object)lineNumber, (Object)rate));
            Dump.this.writer.format(Locale.US, "sensor rate: sensorName %s lineNumber %22.15e rate %22.15e%n", this.dumpName, lineNumber, rate);
        }
    }

    private class DumpedTileData {
        private final String name;
        private final Tile tile;
        private final OpenIntToDoubleHashMap elevations;

        DumpedTileData(String name, Tile tile) {
            this.name = name;
            this.tile = tile;
            this.elevations = new OpenIntToDoubleHashMap();
            Dump.this.writer.format(Locale.US, "DEM tile: %s latMin %22.15e latStep %22.15e latRows %d lonMin %22.15e lonStep %22.15e lonCols %d%n", name, tile.getMinimumLatitude(), tile.getLatitudeStep(), tile.getLatitudeRows(), tile.getMinimumLongitude(), tile.getLongitudeStep(), tile.getLongitudeColumns());
        }

        public Tile getTile() {
            return this.tile;
        }

        public void setElevation(int latitudeIndex, int longitudeIndex, double elevation) {
            int key = latitudeIndex * this.tile.getLongitudeColumns() + longitudeIndex;
            if (!this.elevations.containsKey(key)) {
                this.elevations.put(key, elevation);
                Dump.this.writer.format(Locale.US, "DEM cell: %s latIndex %d lonIndex %d elevation %22.15e%n", this.name, latitudeIndex, longitudeIndex, elevation);
            }
        }
    }
}

