/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.util.IdentityHashMap;
import java.util.Map;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.ThirdBodyAttractionEpoch;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.numerical.AbsoluteJacobiansMapper;
import org.orekit.propagation.numerical.NumericalGradientConverter;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class EpochDerivativesEquations
implements AdditionalEquations {
    private final NumericalPropagator propagator;
    private ParameterDriversList selected;
    private Map<ParameterDriver, Integer> map;
    private final String name;
    private boolean initialized;

    public EpochDerivativesEquations(String name, NumericalPropagator propagator) {
        this.name = name;
        this.selected = null;
        this.map = null;
        this.propagator = propagator;
        this.initialized = false;
        propagator.addAdditionalEquations(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void freezeParametersSelection() {
        if (this.selected == null) {
            this.selected = new ParameterDriversList();
            for (ForceModel provider : this.propagator.getAllForceModels()) {
                for (ParameterDriver driver : provider.getParametersDrivers()) {
                    this.selected.add(driver);
                }
            }
            this.selected.filter(true);
            this.selected.sort();
            this.map = new IdentityHashMap<ParameterDriver, Integer>();
            int parameterIndex = 0;
            for (ParameterDriver parameterDriver : this.selected.getDrivers()) {
                for (ForceModel provider : this.propagator.getAllForceModels()) {
                    for (ParameterDriver driver : provider.getParametersDrivers()) {
                        if (!driver.getName().equals(parameterDriver.getName())) continue;
                        this.map.put(driver, parameterIndex);
                    }
                }
                ++parameterIndex;
            }
        }
    }

    public ParameterDriversList getSelectedParameters() {
        this.freezeParametersSelection();
        return this.selected;
    }

    public SpacecraftState setInitialJacobians(SpacecraftState s0) {
        this.freezeParametersSelection();
        int epochStateDimension = 6;
        double[][] dYdY0 = new double[6][6];
        double[][] dYdP = new double[6][this.selected.getNbParams() + 6];
        for (int i = 0; i < 6; ++i) {
            dYdY0[i][i] = 1.0;
        }
        return this.setInitialJacobians(s0, dYdY0, dYdP);
    }

    public SpacecraftState setInitialJacobians(SpacecraftState s1, double[][] dY1dY0, double[][] dY1dP) {
        this.freezeParametersSelection();
        int stateDimEpoch = dY1dY0.length;
        if (stateDimEpoch != 6 || stateDimEpoch != dY1dY0[0].length) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_JACOBIAN_NOT_6X6, stateDimEpoch, dY1dY0[0].length);
        }
        if (dY1dP != null && stateDimEpoch != dY1dP.length) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_AND_PARAMETERS_JACOBIANS_ROWS_MISMATCH, stateDimEpoch, dY1dP.length);
        }
        this.initialized = true;
        AbsoluteJacobiansMapper absoluteMapper = this.getMapper();
        double[] p = new double[absoluteMapper.getAdditionalStateDimension() + 6];
        absoluteMapper.setInitialJacobians(s1, dY1dY0, dY1dP, p);
        return s1.addAdditionalState(this.name, p);
    }

    public AbsoluteJacobiansMapper getMapper() {
        if (!this.initialized) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_JACOBIAN_NOT_INITIALIZED, new Object[0]);
        }
        return new AbsoluteJacobiansMapper(this.name, this.selected);
    }

    @Override
    public double[] computeDerivatives(SpacecraftState s, double[] pDot) {
        int paramDimEpoch = this.selected.getNbParams() + 1;
        int dimEpoch = 3;
        double[][] dAccdParam = new double[3][paramDimEpoch];
        double[][] dAccdPos = new double[3][3];
        double[][] dAccdVel = new double[3][3];
        NumericalGradientConverter fullConverter = new NumericalGradientConverter(s, 6, this.propagator.getAttitudeProvider());
        NumericalGradientConverter posOnlyConverter = new NumericalGradientConverter(s, 3, this.propagator.getAttitudeProvider());
        for (ForceModel forceModel : this.propagator.getAllForceModels()) {
            NumericalGradientConverter converter = forceModel.dependsOnPositionOnly() ? posOnlyConverter : fullConverter;
            FieldSpacecraftState<Gradient> dsState = converter.getState(forceModel);
            Gradient[] parameters = converter.getParameters(dsState, forceModel);
            FieldVector3D acceleration = forceModel.acceleration(dsState, (RealFieldElement[])parameters);
            double[] derivativesX = ((Gradient)acceleration.getX()).getGradient();
            double[] derivativesY = ((Gradient)acceleration.getY()).getGradient();
            double[] derivativesZ = ((Gradient)acceleration.getZ()).getGradient();
            this.addToRow(derivativesX, 0, converter.getFreeStateParameters(), dAccdPos, dAccdVel);
            this.addToRow(derivativesY, 1, converter.getFreeStateParameters(), dAccdPos, dAccdVel);
            this.addToRow(derivativesZ, 2, converter.getFreeStateParameters(), dAccdPos, dAccdVel);
            int index = converter.getFreeStateParameters();
            for (ParameterDriver driver : forceModel.getParametersDrivers()) {
                if (!driver.isSelected()) continue;
                int parameterIndex = this.map.get(driver);
                double[] dArray = dAccdParam[0];
                int n = parameterIndex;
                dArray[n] = dArray[n] + derivativesX[index];
                double[] dArray2 = dAccdParam[1];
                int n2 = parameterIndex;
                dArray2[n2] = dArray2[n2] + derivativesY[index];
                double[] dArray3 = dAccdParam[2];
                int n3 = parameterIndex;
                dArray3[n3] = dArray3[n3] + derivativesZ[index];
                ++index;
            }
            if (!(forceModel instanceof ThirdBodyAttractionEpoch)) continue;
            double[] parametersValues = new double[]{parameters[0].getValue()};
            double[] derivatives = ((ThirdBodyAttractionEpoch)forceModel).getDerivativesToEpoch(s, parametersValues);
            double[] dArray = dAccdParam[0];
            int n = paramDimEpoch - 1;
            dArray[n] = dArray[n] + derivatives[0];
            double[] dArray4 = dAccdParam[1];
            int n4 = paramDimEpoch - 1;
            dArray4[n4] = dArray4[n4] + derivatives[1];
            double[] dArray5 = dAccdParam[2];
            int n5 = paramDimEpoch - 1;
            dArray5[n5] = dArray5[n5] + derivatives[2];
        }
        int stateDim = 6;
        double[] p = s.getAdditionalState(this.getName());
        System.arraycopy(p, 18, pDot, 0, 18);
        for (int i = 0; i < 3; ++i) {
            double[] dAdPi = dAccdPos[i];
            double[] dAdVi = dAccdVel[i];
            for (int j = 0; j < 6; ++j) {
                pDot[(3 + i) * 6 + j] = dAdPi[0] * p[j] + dAdPi[1] * p[j + 6] + dAdPi[2] * p[j + 12] + dAdVi[0] * p[j + 18] + dAdVi[1] * p[j + 24] + dAdVi[2] * p[j + 30];
            }
        }
        for (int k = 0; k < paramDimEpoch; ++k) {
            int columnTop = 36 + k;
            pDot[columnTop] = p[columnTop + 3 * paramDimEpoch];
            pDot[columnTop + paramDimEpoch] = p[columnTop + 4 * paramDimEpoch];
            pDot[columnTop + 2 * paramDimEpoch] = p[columnTop + 5 * paramDimEpoch];
            for (int i = 0; i < 3; ++i) {
                double[] dAdP = dAccdPos[i];
                double[] dAdV = dAccdVel[i];
                pDot[columnTop + (3 + i) * paramDimEpoch] = dAccdParam[i][k] + dAdP[0] * p[columnTop] + dAdP[1] * p[columnTop + paramDimEpoch] + dAdP[2] * p[columnTop + 2 * paramDimEpoch] + dAdV[0] * p[columnTop + 3 * paramDimEpoch] + dAdV[1] * p[columnTop + 4 * paramDimEpoch] + dAdV[2] * p[columnTop + 5 * paramDimEpoch];
            }
        }
        return null;
    }

    private void addToRow(double[] derivatives, int index, int freeStateParameters, double[][] dAccdPos, double[][] dAccdVel) {
        int i;
        for (i = 0; i < 3; ++i) {
            double[] dArray = dAccdPos[index];
            int n = i;
            dArray[n] = dArray[n] + derivatives[i];
        }
        if (freeStateParameters > 3) {
            for (i = 0; i < 3; ++i) {
                double[] dArray = dAccdVel[index];
                int n = i;
                dArray[n] = dArray[n] + derivatives[i + 3];
            }
        }
    }
}

