/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.ITRFVersion;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

public class EOPEntry
implements TimeStamped,
Serializable {
    private static final long serialVersionUID = 20180330L;
    private final int mjd;
    private final AbsoluteDate date;
    private final double dt;
    private final double lod;
    private final double x;
    private final double y;
    private final double ddPsi;
    private final double ddEps;
    private final double dx;
    private final double dy;
    private final ITRFVersion itrfType;

    @Deprecated
    @DefaultDataContext
    public EOPEntry(int mjd, double dt, double lod, double x, double y, double ddPsi, double ddEps, double dx, double dy, ITRFVersion itrfType) {
        this(mjd, dt, lod, x, y, ddPsi, ddEps, dx, dy, itrfType, AbsoluteDate.createMJDDate(mjd, 0.0, DataContext.getDefault().getTimeScales().getUTC()));
    }

    public EOPEntry(int mjd, double dt, double lod, double x, double y, double ddPsi, double ddEps, double dx, double dy, ITRFVersion itrfType, AbsoluteDate date) {
        this.mjd = mjd;
        this.date = date;
        this.dt = dt;
        this.lod = lod;
        this.x = x;
        this.y = y;
        this.ddPsi = ddPsi;
        this.ddEps = ddEps;
        this.dx = dx;
        this.dy = dy;
        this.itrfType = itrfType;
    }

    public int getMjd() {
        return this.mjd;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public double getUT1MinusUTC() {
        return this.dt;
    }

    public double getLOD() {
        return this.lod;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getDdPsi() {
        return this.ddPsi;
    }

    public double getDdEps() {
        return this.ddEps;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public ITRFVersion getITRFType() {
        return this.itrfType;
    }
}

