/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.RealFieldElement;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.BoundedAttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.files.general.AttitudeEphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class EphemerisSegmentAttitudeProvider
implements BoundedAttitudeProvider {
    private final transient ImmutableTimeStampedCache<TimeStampedAngularCoordinates> table;
    private final AttitudeEphemerisFile.AttitudeEphemerisSegment segment;

    public EphemerisSegmentAttitudeProvider(AttitudeEphemerisFile.AttitudeEphemerisSegment segment) {
        this.segment = segment;
        this.table = new ImmutableTimeStampedCache<TimeStampedAngularCoordinates>(segment.getInterpolationSamples(), segment.getAngularCoordinates());
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        List<TimeStampedAngularCoordinates> attitudeSample = this.table.getNeighbors(date).collect(Collectors.toList());
        TimeStampedAngularCoordinates interpolatedAttitude = TimeStampedAngularCoordinates.interpolate(date, this.segment.getAvailableDerivatives(), attitudeSample);
        return new Attitude(this.segment.getReferenceFrame(), interpolatedAttitude);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        List attitudeSample = this.table.getNeighbors(date.toAbsoluteDate()).map(ac -> new TimeStampedFieldAngularCoordinates(date.getField(), (TimeStampedAngularCoordinates)ac)).collect(Collectors.toList());
        TimeStampedFieldAngularCoordinates<T> interpolatedAttitude = TimeStampedFieldAngularCoordinates.interpolate(date, this.segment.getAvailableDerivatives(), attitudeSample);
        return new FieldAttitude<T>(this.segment.getReferenceFrame(), interpolatedAttitude);
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.segment.getStart();
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.segment.getStop();
    }
}

