/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.estimation.measurements.gnss.InterSatellitesPhase;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class InterSatellitesPhaseBuilder
extends AbstractMeasurementBuilder<InterSatellitesPhase> {
    private final double wavelength;

    public InterSatellitesPhaseBuilder(CorrelatedRandomVectorGenerator noiseSource, ObservableSatellite local, ObservableSatellite remote, double wavelength, double sigma, double baseWeight) {
        super(noiseSource, sigma, baseWeight, local, remote);
        this.wavelength = wavelength;
    }

    @Override
    public InterSatellitesPhase build(SpacecraftState[] states) {
        ObservableSatellite[] satellites = this.getSatellites();
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{states[satellites[0].getPropagatorIndex()], states[satellites[1].getPropagatorIndex()]};
        SpacecraftState state = states[satellites[0].getPropagatorIndex()];
        InterSatellitesPhase dummy = new InterSatellitesPhase(satellites[0], satellites[1], state.getDate(), Double.NaN, this.wavelength, sigma, baseWeight);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double phase = dummy.estimate(0, 0, relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            phase += noise[0];
        }
        InterSatellitesPhase measurement = new InterSatellitesPhase(satellites[0], satellites[1], state.getDate(), phase, this.wavelength, sigma, baseWeight);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

