/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataFilter;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvider;
import org.orekit.data.DirectoryCrawler;
import org.orekit.data.GzipFilter;
import org.orekit.data.NamedData;
import org.orekit.data.UnixCompressFilter;
import org.orekit.data.ZipJarCrawler;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.HatanakaCompressFilter;

public class DataProvidersManager {
    public static final String OREKIT_DATA_PATH = "orekit.data.path";
    private final List<DataProvider> providers = new ArrayList<DataProvider>();
    private final List<DataFilter> filters = new ArrayList<DataFilter>();
    private final int predefinedFilters;
    private final Set<String> loaded = new LinkedHashSet<String>();

    public DataProvidersManager() {
        this.addFilter(new GzipFilter());
        this.addFilter(new UnixCompressFilter());
        this.addFilter(new HatanakaCompressFilter());
        this.predefinedFilters = this.filters.size();
    }

    @Deprecated
    @DefaultDataContext
    public static DataProvidersManager getInstance() {
        return DataContext.getDefault().getDataProvidersManager();
    }

    public void addDefaultProviders() {
        String path = System.getProperty(OREKIT_DATA_PATH);
        if (path != null && !"".equals(path)) {
            for (String name : path.split(System.getProperty("path.separator"))) {
                if ("".equals(name)) continue;
                File file = new File(name);
                if (!file.exists()) {
                    if (DataProvider.ZIP_ARCHIVE_PATTERN.matcher(name).matches()) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, name);
                    }
                    throw new OrekitException((Localizable)OrekitMessages.DATA_ROOT_DIRECTORY_DOES_NOT_EXIST, name);
                }
                if (file.isDirectory()) {
                    this.addProvider(new DirectoryCrawler(file));
                    continue;
                }
                if (DataProvider.ZIP_ARCHIVE_PATTERN.matcher(name).matches()) {
                    this.addProvider(new ZipJarCrawler(file));
                    continue;
                }
                throw new OrekitException((Localizable)OrekitMessages.NEITHER_DIRECTORY_NOR_ZIP_OR_JAR, name);
            }
        }
    }

    public void addProvider(DataProvider provider) {
        this.providers.add(provider);
    }

    public DataProvider removeProvider(DataProvider provider) {
        Iterator<DataProvider> iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            DataProvider current = iterator.next();
            if (current != provider) continue;
            iterator.remove();
            return provider;
        }
        return null;
    }

    public void clearProviders() {
        this.providers.clear();
    }

    public void addFilter(DataFilter filter) {
        this.filters.add(filter);
    }

    public void clearFilters() {
        this.filters.subList(this.predefinedFilters, this.filters.size()).clear();
    }

    public NamedData applyAllFilters(NamedData original) throws IOException {
        NamedData top = original;
        boolean filtering = true;
        block0: while (filtering) {
            filtering = false;
            for (DataFilter filter : this.filters) {
                NamedData filtered = filter.filter(top);
                if (filtered == top) continue;
                top = filtered;
                filtering = true;
                continue block0;
            }
        }
        return top;
    }

    public boolean isSupported(DataProvider provider) {
        for (DataProvider current : this.providers) {
            if (current != provider) continue;
            return true;
        }
        return false;
    }

    public List<DataProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public Set<String> getLoadedDataNames() {
        return Collections.unmodifiableSet(this.loaded);
    }

    public void clearLoadedDataNames() {
        this.loaded.clear();
    }

    public boolean feed(String supportedNames, DataLoader loader) {
        Pattern supported = Pattern.compile(supportedNames);
        if (this.providers.isEmpty()) {
            this.addDefaultProviders();
        }
        MonitoringWrapper monitoredLoader = new MonitoringWrapper(loader);
        OrekitException delayedException = null;
        for (DataProvider provider : this.providers) {
            try {
                if (!provider.feed(supported, monitoredLoader, this)) continue;
                return true;
            }
            catch (OrekitException oe) {
                delayedException = oe;
            }
        }
        if (delayedException != null) {
            throw delayedException;
        }
        return false;
    }

    private class MonitoringWrapper
    implements DataLoader {
        private final DataLoader loader;

        MonitoringWrapper(DataLoader loader) {
            this.loader = loader;
        }

        @Override
        public boolean stillAcceptsData() {
            return this.loader.stillAcceptsData();
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
            this.loader.loadData(input, name);
            DataProvidersManager.this.loaded.add(name);
        }
    }
}

