/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.migration;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.UTF8Control;

@Deprecated
public enum LocalizedMigrationFormats implements Localizable
{
    ARGUMENT_OUTSIDE_DOMAIN("Argument {0} outside domain [{1} ; {2}]"),
    ASSYMETRIC_EIGEN_NOT_SUPPORTED("eigen decomposition of assymetric matrices not supported yet"),
    BOBYQA_BOUND_DIFFERENCE_CONDITION("the difference between the upper and lower bound must be larger than twice the initial trust region radius ({0})"),
    CANNOT_CLEAR_STATISTIC_CONSTRUCTED_FROM_EXTERNAL_MOMENTS("statistics constructed from external moments cannot be cleared"),
    CANNOT_FORMAT_INSTANCE_AS_3D_VECTOR("cannot format a {0} instance as a 3D vector"),
    CANNOT_FORMAT_INSTANCE_AS_REAL_VECTOR("cannot format a {0} instance as a real vector"),
    CANNOT_INCREMENT_STATISTIC_CONSTRUCTED_FROM_EXTERNAL_MOMENTS("statistics constructed from external moments cannot be incremented"),
    CANNOT_RETRIEVE_AT_NEGATIVE_INDEX("elements cannot be retrieved from a negative array index {0}"),
    CANNOT_SET_AT_NEGATIVE_INDEX("cannot set an element at a negative index {0}"),
    CANNOT_TRANSFORM_TO_DOUBLE("Conversion Exception in Transformation: {0}"),
    CLASS_DOESNT_IMPLEMENT_COMPARABLE("class ({0}) does not implement Comparable"),
    COLUMN_INDEX_OUT_OF_RANGE("column index {0} out of allowed range [{1}, {2}]"),
    DIMENSIONS_MISMATCH_SIMPLE("{0} != {1}"),
    EMPTY_STRING_FOR_IMAGINARY_CHARACTER("empty string for imaginary character"),
    FUNCTION_NOT_DIFFERENTIABLE("function is not differentiable"),
    FUNCTION_NOT_POLYNOMIAL("function is not polynomial"),
    INDEX_OUT_OF_RANGE("index {0} out of allowed range [{1}, {2}]"),
    INVALID_BRACKETING_PARAMETERS("invalid bracketing parameters:  lower bound={0},  initial={1}, upper bound={2}"),
    INVALID_INTERVAL_INITIAL_VALUE_PARAMETERS("invalid interval, initial value parameters:  lower={0}, initial={1}, upper={2}"),
    INVALID_ITERATIONS_LIMITS("invalid iteration limits: min={0}, max={1}"),
    INVALID_REGRESSION_ARRAY("input data array length = {0} does not match the number of observations = {1} and the number of regressors = {2}"),
    ITERATOR_EXHAUSTED("iterator exhausted"),
    LOESS_EXPECTS_AT_LEAST_ONE_POINT("Loess expects at least 1 point"),
    MAP_MODIFIED_WHILE_ITERATING("map has been modified while iterating"),
    MAX_ITERATIONS_EXCEEDED("maximal number of iterations ({0}) exceeded"),
    MISMATCHED_LOESS_ABSCISSA_ORDINATE_ARRAYS("Loess expects the abscissa and ordinate arrays to be of the same size, but got {0} abscissae and {1} ordinatae"),
    NEGATIVE_BRIGHTNESS_EXPONENT("brightness exponent should be positive or null, but got {0}"),
    NEGATIVE_ELEMENT_AT_2D_INDEX("element ({0}, {1}) is negative: {2}"),
    NEGATIVE_NUMBER_OF_SUCCESSES("number of successes must be non-negative ({0})"),
    NEGATIVE_NUMBER_OF_TRIALS("number of trials must be non-negative ({0})"),
    NON_POSITIVE_DEFINITE_MATRIX("not positive definite matrix: diagonal element at ({1},{1}) is smaller than {2} ({0})"),
    NON_POSITIVE_MICROSPHERE_ELEMENTS("number of microsphere elements must be positive, but got {0}"),
    NON_POSITIVE_POLYNOMIAL_DEGREE("polynomial degree must be positive: degree={0}"),
    NON_REAL_FINITE_ABSCISSA("all abscissae must be finite real numbers, but {0}-th is {1}"),
    NON_REAL_FINITE_ORDINATE("all ordinatae must be finite real numbers, but {0}-th is {1}"),
    NON_REAL_FINITE_WEIGHT("all weights must be finite real numbers, but {0}-th is {1}"),
    NOT_ADDITION_COMPATIBLE_MATRICES("{0}x{1} and {2}x{3} matrices are not addition compatible"),
    NOT_DECREASING_NUMBER_OF_POINTS("points {0} and {1} are not decreasing ({2} < {3})"),
    NOT_INCREASING_NUMBER_OF_POINTS("points {0} and {1} are not increasing ({2} > {3})"),
    NOT_MULTIPLICATION_COMPATIBLE_MATRICES("{0}x{1} and {2}x{3} matrices are not multiplication compatible"),
    NOT_POSITIVE_DEGREES_OF_FREEDOM("degrees of freedom must be positive ({0})"),
    NOT_POSITIVE_ELEMENT_AT_INDEX("element {0} is not positive: {1}"),
    NOT_POSITIVE_LENGTH("length must be positive ({0})"),
    NOT_POSITIVE_MEAN("mean must be positive ({0})"),
    NOT_POSITIVE_PERMUTATION("permutation k ({0}) must be positive"),
    NOT_POSITIVE_POISSON_MEAN("the Poisson mean must be positive ({0})"),
    NOT_POSITIVE_POPULATION_SIZE("population size must be positive ({0})"),
    NOT_POSITIVE_ROW_DIMENSION("invalid row dimension: {0} (must be positive)"),
    NOT_POSITIVE_SAMPLE_SIZE("sample size must be positive ({0})"),
    NOT_POSITIVE_SHAPE("shape must be positive ({0})"),
    NOT_POSITIVE_STANDARD_DEVIATION("standard deviation must be positive ({0})"),
    NOT_POSITIVE_UPPER_BOUND("upper bound must be positive ({0})"),
    NOT_STRICTLY_DECREASING_NUMBER_OF_POINTS("points {0} and {1} are not strictly decreasing ({2} <= {3})"),
    NOT_STRICTLY_INCREASING_KNOT_VALUES("knot values must be strictly increasing"),
    NOT_STRICTLY_INCREASING_NUMBER_OF_POINTS("points {0} and {1} are not strictly increasing ({2} >= {3})"),
    NOT_SUBTRACTION_COMPATIBLE_MATRICES("{0}x{1} and {2}x{3} matrices are not subtraction compatible"),
    NOT_SYMMETRIC_MATRIX("not symmetric matrix"),
    NO_BIN_SELECTED("no bin selected"),
    NO_DEGREES_OF_FREEDOM("no degrees of freedom ({0} measurements, {1} parameters)"),
    NO_DENSITY_FOR_THIS_DISTRIBUTION("This distribution does not have a density function implemented"),
    NO_RESULT_AVAILABLE("no result available"),
    NO_SUCH_MATRIX_ENTRY("no entry at indices ({0}, {1}) in a {2}x{3} matrix"),
    N_POINTS_GAUSS_LEGENDRE_INTEGRATOR_NOT_SUPPORTED("{0} points Legendre-Gauss integrator not supported, number of points must be in the {1}-{2} range"),
    OBJECT_TRANSFORMATION("conversion exception in transformation"),
    OBSERVED_COUNTS_ALL_ZERO("observed counts are all 0 in observed array {0}"),
    OUT_OF_ORDER_ABSCISSA_ARRAY("the abscissae array must be sorted in a strictly increasing order, but the {0}-th element is {1} whereas {2}-th is {3}"),
    OUT_OF_RANGE_RIGHT("{0} out of [{1}, {2}) range"),
    POLYNOMIAL_INTERPOLANTS_MISMATCH_SEGMENTS("number of polynomial interpolants must match the number of segments ({0} != {1} - 1)"),
    POWER_NEGATIVE_PARAMETERS("cannot raise an integral value to a negative power ({0}^{1})"),
    ROW_INDEX_OUT_OF_RANGE("row index {0} out of allowed range [{1}, {2}]"),
    SAME_SIGN_AT_ENDPOINTS("function values at endpoints do not have different signs, endpoints: [{0}, {1}], values: [{2}, {3}]"),
    UNABLE_TO_BRACKET_OPTIMUM_IN_LINE_SEARCH("unable to bracket optimum in line search"),
    UNABLE_TO_COMPUTE_COVARIANCE_SINGULAR_PROBLEM("unable to compute covariances: singular problem"),
    UNABLE_TO_FIRST_GUESS_HARMONIC_COEFFICIENTS("unable to first guess the harmonic coefficients"),
    UNPARSEABLE_3D_VECTOR("unparseable 3D vector: \"{0}\""),
    UNPARSEABLE_COMPLEX_NUMBER("unparseable complex number: \"{0}\""),
    UNPARSEABLE_REAL_VECTOR("unparseable real vector: \"{0}\""),
    UNSUPPORTED_EXPANSION_MODE("unsupported expansion mode {0}, supported modes are {1} ({2}) and {3} ({4})"),
    VECTOR_LENGTH_MISMATCH("vector length mismatch: got {0} but expected {1}"),
    WRONG_BLOCK_LENGTH("wrong array shape (block length = {0}, expected {1})");

    private final String sourceFormat;

    private LocalizedMigrationFormats(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    public String getSourceString() {
        return this.sourceFormat;
    }

    public String getLocalizedString(Locale locale) {
        try {
            String translated;
            String path = LocalizedMigrationFormats.class.getName().replaceAll("\\.", "/");
            ResourceBundle bundle = ResourceBundle.getBundle("assets/" + path, locale, (ResourceBundle.Control)new UTF8Control());
            if (bundle.getLocale().getLanguage().equals(locale.getLanguage()) && (translated = bundle.getString(this.name())) != null && translated.length() > 0 && !translated.toLowerCase(locale).contains("missing translation")) {
                return translated;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.sourceFormat;
    }
}

