/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.refraction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.intersection.IntersectionAlgorithm;
import org.orekit.rugged.refraction.AtmosphericRefraction;
import org.orekit.rugged.refraction.ConstantRefractionLayer;
import org.orekit.rugged.refraction.IntersectionLOS;
import org.orekit.rugged.utils.ExtendedEllipsoid;
import org.orekit.rugged.utils.NormalizedGeodeticPoint;

public class MultiLayerModel
extends AtmosphericRefraction {
    private final ExtendedEllipsoid ellipsoid;
    private final List<ConstantRefractionLayer> refractionLayers;
    private final double atmosphereLowestAltitude;

    public MultiLayerModel(ExtendedEllipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
        this.refractionLayers = new ArrayList<ConstantRefractionLayer>(15);
        this.refractionLayers.add(new ConstantRefractionLayer(100000.0, 1.0));
        this.refractionLayers.add(new ConstantRefractionLayer(50000.0, 1.0));
        this.refractionLayers.add(new ConstantRefractionLayer(40000.0, 1.000001));
        this.refractionLayers.add(new ConstantRefractionLayer(30000.0, 1.000004));
        this.refractionLayers.add(new ConstantRefractionLayer(23000.0, 1.000012));
        this.refractionLayers.add(new ConstantRefractionLayer(18000.0, 1.000028));
        this.refractionLayers.add(new ConstantRefractionLayer(14000.0, 1.000052));
        this.refractionLayers.add(new ConstantRefractionLayer(11000.0, 1.000083));
        this.refractionLayers.add(new ConstantRefractionLayer(9000.0, 1.000106));
        this.refractionLayers.add(new ConstantRefractionLayer(7000.0, 1.000134));
        this.refractionLayers.add(new ConstantRefractionLayer(5000.0, 1.000167));
        this.refractionLayers.add(new ConstantRefractionLayer(3000.0, 1.000206));
        this.refractionLayers.add(new ConstantRefractionLayer(1000.0, 1.000252));
        this.refractionLayers.add(new ConstantRefractionLayer(0.0, 1.000278));
        this.refractionLayers.add(new ConstantRefractionLayer(-1000.0, 1.000306));
        this.atmosphereLowestAltitude = this.refractionLayers.get(this.refractionLayers.size() - 1).getLowestAltitude();
    }

    public MultiLayerModel(ExtendedEllipsoid ellipsoid, List<ConstantRefractionLayer> refractionLayers) {
        this.ellipsoid = ellipsoid;
        this.refractionLayers = new ArrayList<ConstantRefractionLayer>(refractionLayers);
        Collections.sort(this.refractionLayers, (l1, l2) -> Double.compare(l2.getLowestAltitude(), l1.getLowestAltitude()));
        this.atmosphereLowestAltitude = this.refractionLayers.get(this.refractionLayers.size() - 1).getLowestAltitude();
    }

    private IntersectionLOS computeToLowestAtmosphereLayer(Vector3D satPos, Vector3D satLos, NormalizedGeodeticPoint rawIntersection) {
        if (rawIntersection.getAltitude() < this.atmosphereLowestAltitude) {
            throw new RuggedException(RuggedMessages.NO_LAYER_DATA, rawIntersection.getAltitude(), this.atmosphereLowestAltitude);
        }
        Vector3D pos = satPos;
        Vector3D los = satLos.normalize();
        double n1 = -1.0;
        GeodeticPoint gp = this.ellipsoid.transform(satPos, this.ellipsoid.getBodyFrame(), null);
        for (ConstantRefractionLayer refractionLayer : this.refractionLayers) {
            if (refractionLayer.getLowestAltitude() > gp.getAltitude()) continue;
            double n2 = refractionLayer.getRefractiveIndex();
            if (n1 > 0.0) {
                double alpha = n1 / n2;
                double k = alpha * Vector3D.dotProduct((Vector3D)los, (Vector3D)gp.getZenith());
                double zeta = (n1 - n2) * (n1 + n2) / (n2 * n2);
                double beta = zeta / (FastMath.sqrt((double)(k * k - zeta)) - k);
                los = new Vector3D(alpha, los, beta, gp.getZenith());
            }
            if (rawIntersection.getAltitude() > refractionLayer.getLowestAltitude()) break;
            pos = this.ellipsoid.pointAtAltitude(pos, los, refractionLayer.getLowestAltitude());
            gp = this.ellipsoid.transform(pos, this.ellipsoid.getBodyFrame(), null);
            n1 = n2;
        }
        return new IntersectionLOS(pos, los);
    }

    @Override
    public NormalizedGeodeticPoint applyCorrection(Vector3D satPos, Vector3D satLos, NormalizedGeodeticPoint rawIntersection, IntersectionAlgorithm algorithm) {
        IntersectionLOS intersectionLOS = this.computeToLowestAtmosphereLayer(satPos, satLos, rawIntersection);
        Vector3D pos = intersectionLOS.getIntersectionPos();
        Vector3D los = intersectionLOS.getIntersectionLos();
        return algorithm.refineIntersection(this.ellipsoid, pos, los, rawIntersection);
    }
}

