/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.errors;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.hipparchus.exception.Localizable;

public enum RuggedMessages implements Localizable
{
    INTERNAL_ERROR("internal error, please notify development team by creating an issue at {0}"),
    OUT_OF_TILE_INDICES("no data at indices [{0}, {1}], tile only covers from [0, 0] to [{2}, {3}] (inclusive)"),
    OUT_OF_TILE_ANGLES("no data at latitude {0} and longitude {1}, tile covers only latitudes {2} to {3} and longitudes {4} to {5}"),
    NO_DEM_DATA("no Digital Elevation Model data at latitude {0} and longitude {1}"),
    TILE_WITHOUT_REQUIRED_NEIGHBORS_SELECTED("the tile selected for latitude {0} and longitude {1} does not contain required point neighborhood"),
    OUT_OF_TIME_RANGE("date {0} is out of time span [{1}, {2}] (UTC)"),
    UNINITIALIZED_CONTEXT("general context has not been initialized (missing call to {0})"),
    EMPTY_TILE("tile is empty: {0} \u2a09 {1}"),
    UNKNOWN_SENSOR("unknown sensor {0}"),
    LINE_OF_SIGHT_DOES_NOT_REACH_GROUND("line-of-sight does not reach ground"),
    LINE_OF_SIGHT_NEVER_CROSSES_LATITUDE("line-of-sight never crosses latitude {0}"),
    LINE_OF_SIGHT_NEVER_CROSSES_LONGITUDE("line-of-sight never crosses longitude {0}"),
    LINE_OF_SIGHT_NEVER_CROSSES_ALTITUDE("line-of-sight never crosses altitude {0}"),
    DEM_ENTRY_POINT_IS_BEHIND_SPACECRAFT("line-of-sight enters the Digital Elevation Model behind spacecraft!"),
    FRAMES_MISMATCH_WITH_INTERPOLATOR_DUMP("frame {0} does not match frame {1} from interpolator dump"),
    NOT_INTERPOLATOR_DUMP_DATA("data is not an interpolator dump"),
    DEBUG_DUMP_ALREADY_ACTIVE("debug dump is already active for this thread"),
    DEBUG_DUMP_ACTIVATION_ERROR("unable to active debug dump with file {0}: {1}"),
    DEBUG_DUMP_NOT_ACTIVE("debug dump is not active for this thread"),
    CANNOT_PARSE_LINE("cannot parse line {0}, file {1}: {2}"),
    LIGHT_TIME_CORRECTION_REDEFINED("light time correction redefined, line {0}, file {1}: {2}"),
    ABERRATION_OF_LIGHT_CORRECTION_REDEFINED("aberration of light correction redefined, line {0}, file {1}: {2}"),
    ATMOSPHERIC_REFRACTION_REDEFINED("atmospheric refraction correction redefined, line {0}, file {1}: {2}"),
    TILE_ALREADY_DEFINED("tile {0} already defined, line {1}, file {2}: {3}"),
    UNKNOWN_TILE("unknown tile {0}, line {1}, file {2}: {3}"),
    NO_PARAMETERS_SELECTED("no parameters have been selected for estimation"),
    NO_REFERENCE_MAPPINGS("no reference mappings for parameters estimation"),
    DUPLICATED_PARAMETER_NAME("a different parameter with name {0} already exists"),
    INVALID_RUGGED_NAME("invalid rugged name"),
    UNSUPPORTED_REFINING_CONTEXT("refining using {0} rugged instance is not handled"),
    NO_LAYER_DATA("no atmospheric layer data at altitude {0} (lowest altitude: {1})"),
    INVALID_STEP("step {0} is not valid : {1}"),
    INVALID_RANGE_FOR_LINES("range between min line {0} and max line {1} is invalid {2}");

    private static final String RESOURCE_BASE_NAME = "assets/org/orekit/rugged/RuggedMessages";
    private final String sourceFormat;

    private RuggedMessages(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    public String getSourceString() {
        return this.sourceFormat;
    }

    public String getLocalizedString(Locale locale) {
        try {
            String translated;
            ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BASE_NAME, locale, new UTF8Control());
            if (bundle.getLocale().getLanguage().equals(locale.getLanguage()) && (translated = bundle.getString(this.name())) != null && translated.length() > 0 && !translated.toLowerCase(locale).contains("missing translation")) {
                return translated;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.sourceFormat;
    }

    public static class UTF8Control
    extends ResourceBundle.Control {
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "utf8");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try (InputStreamReader inputStreamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    bundle = new PropertyResourceBundle(inputStreamReader);
                }
            }
            return bundle;
        }
    }
}

