/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.util.Arrays;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FieldDerivative;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.differentiation.FieldGradientField;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldGradient<T extends RealFieldElement<T>>
implements FieldDerivative<T, FieldGradient<T>> {
    private final T value;
    private final T[] grad;

    private FieldGradient(T value, int freeParameters) {
        this.value = value;
        this.grad = (RealFieldElement[])MathArrays.buildArray(value.getField(), freeParameters);
    }

    @SafeVarargs
    public FieldGradient(T value, T ... gradient) {
        this(value, gradient.length);
        System.arraycopy(gradient, 0, this.grad, 0, this.grad.length);
    }

    public FieldGradient(FieldDerivativeStructure<T> ds) throws MathIllegalArgumentException {
        this(ds.getValue(), ds.getFreeParameters());
        MathUtils.checkDimension(ds.getOrder(), 1);
        System.arraycopy(ds.getAllDerivatives(), 1, this.grad, 0, this.grad.length);
    }

    public static <T extends RealFieldElement<T>> FieldGradient<T> constant(int freeParameters, T value) {
        FieldGradient<T> g = new FieldGradient<T>(value, freeParameters);
        Arrays.fill(g.grad, value.getField().getZero());
        return g;
    }

    public static <T extends RealFieldElement<T>> FieldGradient<T> variable(int freeParameters, int index, T value) {
        FieldGradient<T> g = new FieldGradient<T>(value, freeParameters);
        Field field = value.getField();
        Arrays.fill(g.grad, field.getZero());
        g.grad[index] = (RealFieldElement)field.getOne();
        return g;
    }

    public Field<T> getValueField() {
        return this.value.getField();
    }

    @Override
    public FieldGradient<T> newInstance(double c) {
        return this.newInstance((RealFieldElement)((RealFieldElement)this.getValueField().getZero()).newInstance(c));
    }

    public FieldGradient<T> newInstance(T c) {
        return new FieldGradient(c, (RealFieldElement[])MathArrays.buildArray(this.value.getField(), this.grad.length));
    }

    @Override
    public double getReal() {
        return this.getValue().getReal();
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public T[] getGradient() {
        return (RealFieldElement[])this.grad.clone();
    }

    @Override
    public int getFreeParameters() {
        return this.grad.length;
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public T getPartialDerivative(int ... orders) throws MathIllegalArgumentException {
        if (orders.length != this.grad.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, orders.length, this.grad.length);
        }
        int selected = -1;
        for (int i = 0; i < orders.length; ++i) {
            if (orders[i] == 0) continue;
            if (selected >= 0 || orders[i] != 1) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DERIVATION_ORDER_NOT_ALLOWED, orders[i]);
            }
            selected = i;
        }
        return selected < 0 ? this.value : this.grad[selected];
    }

    public T getPartialDerivative(int n) throws MathIllegalArgumentException {
        if (n < 0 || n >= this.grad.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, n, 0, this.grad.length - 1);
        }
        return this.grad[n];
    }

    public FieldDerivativeStructure<T> toDerivativeStructure() {
        RealFieldElement[] derivatives = (RealFieldElement[])MathArrays.buildArray(this.getValueField(), 1 + this.grad.length);
        derivatives[0] = this.value;
        System.arraycopy(this.grad, 0, derivatives, 1, this.grad.length);
        return ((FieldGradientField)this.getField()).getConversionFactory().build(derivatives);
    }

    @Override
    public FieldGradient<T> add(T a) {
        return new FieldGradient((RealFieldElement)this.value.add(a), this.grad);
    }

    @Override
    public FieldGradient<T> add(double a) {
        return new FieldGradient((RealFieldElement)this.value.add(a), this.grad);
    }

    @Override
    public FieldGradient<T> add(FieldGradient<T> a) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)this.value.add(a.value));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)this.grad[i].add(a.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> subtract(T a) {
        return new FieldGradient((RealFieldElement)this.value.subtract(a), this.grad);
    }

    @Override
    public FieldGradient<T> subtract(double a) {
        return new FieldGradient((RealFieldElement)this.value.subtract(a), this.grad);
    }

    @Override
    public FieldGradient<T> subtract(FieldGradient<T> a) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)this.value.subtract(a.value));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)this.grad[i].subtract(a.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> multiply(T n) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)this.value.multiply(n));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)this.grad[i].multiply(n);
        }
        return result;
    }

    @Override
    public FieldGradient<T> multiply(int n) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)this.value.multiply((int)n));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)this.grad[i].multiply((int)n);
        }
        return result;
    }

    @Override
    public FieldGradient<T> multiply(double a) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)this.value.multiply(a));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)this.grad[i].multiply(a);
        }
        return result;
    }

    @Override
    public FieldGradient<T> multiply(FieldGradient<T> a) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)this.value.multiply(a.value));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)((RealFieldElement)this.grad[i].multiply(a.value)).add(this.value.multiply(a.grad[i]));
        }
        return result;
    }

    @Override
    public FieldGradient<T> divide(T a) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)this.value.divide(a));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)this.grad[i].divide(a);
        }
        return result;
    }

    @Override
    public FieldGradient<T> divide(double a) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)this.value.divide(a));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)this.grad[i].divide(a);
        }
        return result;
    }

    @Override
    public FieldGradient<T> divide(FieldGradient<T> a) {
        RealFieldElement inv1 = (RealFieldElement)a.value.reciprocal();
        RealFieldElement inv2 = inv1.multiply(inv1);
        FieldGradient<RealFieldElement> result = this.newInstance(this.value.multiply((RealFieldElement)inv1));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = ((RealFieldElement)((RealFieldElement)this.grad[i].multiply(a.value)).subtract(this.value.multiply(a.grad[i]))).multiply(inv2);
        }
        return result;
    }

    @Override
    public FieldGradient<T> remainder(T a) {
        return new FieldGradient(FastMath.IEEEremainder(this.value, a), this.grad);
    }

    @Override
    public FieldGradient<T> remainder(double a) {
        return new FieldGradient((RealFieldElement)FastMath.IEEEremainder(this.value, a), this.grad);
    }

    @Override
    public FieldGradient<T> remainder(FieldGradient<T> a) {
        T rem = FastMath.IEEEremainder(this.value, a.value);
        RealFieldElement k = FastMath.rint((RealFieldElement)((RealFieldElement)this.value.subtract(rem)).divide(a.value));
        FieldGradient<T> result = this.newInstance(rem);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)this.grad[i].subtract(k.multiply(a.grad[i]));
        }
        return result;
    }

    @Override
    public FieldGradient<T> negate() {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)this.value.negate());
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)this.grad[i].negate();
        }
        return result;
    }

    @Override
    public FieldGradient<T> abs() {
        if (Double.doubleToLongBits(this.value.getReal()) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public FieldGradient<T> ceil() {
        return this.newInstance(FastMath.ceil(this.value));
    }

    @Override
    public FieldGradient<T> floor() {
        return this.newInstance(FastMath.floor(this.value));
    }

    @Override
    public FieldGradient<T> rint() {
        return this.newInstance(FastMath.rint(this.value));
    }

    @Override
    public FieldGradient<T> signum() {
        return this.newInstance(FastMath.signum(this.value));
    }

    @Override
    public FieldGradient<T> copySign(T sign) {
        long m = Double.doubleToLongBits(this.value.getReal());
        long s = Double.doubleToLongBits(sign.getReal());
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldGradient<T> copySign(FieldGradient<T> sign) {
        long m = Double.doubleToLongBits(this.value.getReal());
        long s = Double.doubleToLongBits(sign.value.getReal());
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldGradient<T> copySign(double sign) {
        long m = Double.doubleToLongBits(this.value.getReal());
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public int getExponent() {
        return FastMath.getExponent(this.value.getReal());
    }

    @Override
    public FieldGradient<T> scalb(int n) {
        FieldGradient<T> result = this.newInstance(FastMath.scalb(this.value, n));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = FastMath.scalb(this.grad[i], n);
        }
        return result;
    }

    @Override
    public FieldGradient<T> hypot(FieldGradient<T> y) {
        int expY;
        if (Double.isInfinite(this.value.getReal()) || Double.isInfinite(y.value.getReal())) {
            return this.newInstance(Double.POSITIVE_INFINITY);
        }
        if (Double.isNaN(this.value.getReal()) || Double.isNaN(y.value.getReal())) {
            return this.newInstance(Double.NaN);
        }
        int expX = this.getExponent();
        if (expX > (expY = y.getExponent()) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        Object scaledX = this.scalb(-middleExp);
        Object scaledY = y.scalb(-middleExp);
        Object scaledH = ((FieldGradient)scaledX).multiply((FieldGradient<T>)scaledX).add(((FieldGradient)scaledY).multiply((FieldGradient<T>)scaledY)).sqrt();
        return ((FieldGradient)scaledH).scalb(middleExp);
    }

    @Override
    public FieldGradient<T> reciprocal() {
        RealFieldElement inv1 = (RealFieldElement)this.value.reciprocal();
        RealFieldElement mInv2 = (RealFieldElement)inv1.multiply(inv1).negate();
        FieldGradient<RealFieldElement> result = this.newInstance(inv1);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = this.grad[i].multiply((RealFieldElement)mInv2);
        }
        return result;
    }

    public FieldGradient<T> compose(T g0, T g1) {
        FieldGradient<T> result = this.newInstance(g0);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)g1.multiply(this.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> sqrt() {
        T s = FastMath.sqrt(this.value);
        return this.compose(s, (RealFieldElement)((RealFieldElement)s.add(s)).reciprocal());
    }

    @Override
    public FieldGradient<T> cbrt() {
        T c = FastMath.cbrt(this.value);
        return this.compose(c, (RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(c)).multiply(3)).reciprocal());
    }

    @Override
    public FieldGradient<T> rootN(int n) {
        if (n == 2) {
            return this.sqrt();
        }
        if (n == 3) {
            return this.cbrt();
        }
        T r = FastMath.pow(this.value, 1.0 / (double)n);
        return this.compose(r, (RealFieldElement)((RealFieldElement)FastMath.pow(r, n - 1).multiply((int)n)).reciprocal());
    }

    @Override
    public FieldGradientField<T> getField() {
        return FieldGradientField.getField(this.getValueField(), this.getFreeParameters());
    }

    public static <T extends RealFieldElement<T>> FieldGradient<T> pow(double a, FieldGradient<T> x) {
        if (a == 0.0) {
            return ((FieldGradientField)x.getField()).getZero();
        }
        RealFieldElement aX = FastMath.pow((RealFieldElement)x.value.newInstance(a), x.value);
        RealFieldElement aXlnA = (RealFieldElement)aX.multiply(FastMath.log(a));
        FieldGradient<RealFieldElement> result = x.newInstance(aX);
        for (int i = 0; i < x.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)aXlnA.multiply(x.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> pow(double p) {
        if (p == 0.0) {
            return ((FieldGradientField)this.getField()).getOne();
        }
        T f0Pm1 = FastMath.pow(this.value, p - 1.0);
        return this.compose((RealFieldElement)f0Pm1.multiply(this.value), (RealFieldElement)f0Pm1.multiply(p));
    }

    @Override
    public FieldGradient<T> pow(int n) {
        if (n == 0) {
            return ((FieldGradientField)this.getField()).getOne();
        }
        T f0Nm1 = FastMath.pow(this.value, n - 1);
        return this.compose((RealFieldElement)f0Nm1.multiply(this.value), (RealFieldElement)f0Nm1.multiply((int)n));
    }

    @Override
    public FieldGradient<T> pow(FieldGradient<T> e) {
        return ((FieldGradient)this.log()).multiply(e).exp();
    }

    @Override
    public FieldGradient<T> exp() {
        T exp = FastMath.exp(this.value);
        return this.compose(exp, exp);
    }

    @Override
    public FieldGradient<T> expm1() {
        T exp = FastMath.exp(this.value);
        T expM1 = FastMath.expm1(this.value);
        return this.compose(expM1, exp);
    }

    @Override
    public FieldGradient<T> log() {
        return this.compose(FastMath.log(this.value), (RealFieldElement)this.value.reciprocal());
    }

    @Override
    public FieldGradient<T> log1p() {
        return this.compose(FastMath.log1p(this.value), (RealFieldElement)((RealFieldElement)this.value.add(1.0)).reciprocal());
    }

    @Override
    public FieldGradient<T> log10() {
        return this.compose(FastMath.log10(this.value), (RealFieldElement)((RealFieldElement)this.value.multiply(FastMath.log(10.0))).reciprocal());
    }

    @Override
    public FieldGradient<T> cos() {
        FieldSinCos<T> sinCos = FastMath.sinCos(this.value);
        return this.compose((RealFieldElement)sinCos.cos(), (RealFieldElement)((RealFieldElement)sinCos.sin()).negate());
    }

    @Override
    public FieldGradient<T> sin() {
        FieldSinCos<T> sinCos = FastMath.sinCos(this.value);
        return this.compose((RealFieldElement)sinCos.sin(), (RealFieldElement)sinCos.cos());
    }

    @Override
    public FieldSinCos<FieldGradient<T>> sinCos() {
        FieldSinCos<T> sinCos = FastMath.sinCos(this.value);
        FieldGradient<RealFieldElement> sin = this.newInstance((RealFieldElement)sinCos.sin());
        FieldGradient<RealFieldElement> cos = this.newInstance((RealFieldElement)sinCos.cos());
        RealFieldElement mSin = (RealFieldElement)((RealFieldElement)sinCos.sin()).negate();
        for (int i = 0; i < this.grad.length; ++i) {
            sin.grad[i] = (RealFieldElement)this.grad[i].multiply(sinCos.cos());
            cos.grad[i] = this.grad[i].multiply((RealFieldElement)mSin);
        }
        return new FieldSinCos<FieldGradient<T>>(sin, cos);
    }

    @Override
    public FieldGradient<T> tan() {
        T tan = FastMath.tan(this.value);
        return this.compose(tan, (RealFieldElement)((RealFieldElement)tan.multiply(tan)).add(1.0));
    }

    @Override
    public FieldGradient<T> acos() {
        return this.compose(FastMath.acos(this.value), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.value.multiply(this.value)).negate()).add(1.0)).sqrt()).reciprocal()).negate());
    }

    @Override
    public FieldGradient<T> asin() {
        return this.compose(FastMath.asin(this.value), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.value.multiply(this.value)).negate()).add(1.0)).sqrt()).reciprocal());
    }

    @Override
    public FieldGradient<T> atan() {
        return this.compose(FastMath.atan(this.value), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.value.multiply(this.value)).add(1.0)).reciprocal());
    }

    @Override
    public FieldGradient<T> atan2(FieldGradient<T> x) {
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.value.multiply(this.value)).add(x.value.multiply(x.value))).reciprocal();
        FieldGradient<T> result = this.newInstance(FastMath.atan2(this.value, x.value));
        RealFieldElement xValueInv = x.value.multiply((RealFieldElement)inv);
        RealFieldElement mValueInv = ((RealFieldElement)this.value.negate()).multiply(inv);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = ((RealFieldElement)xValueInv.multiply(this.grad[i])).add(x.grad[i].multiply((RealFieldElement)mValueInv));
        }
        return result;
    }

    @Override
    public FieldGradient<T> cosh() {
        return this.compose(FastMath.cosh(this.value), FastMath.sinh(this.value));
    }

    @Override
    public FieldGradient<T> sinh() {
        return this.compose(FastMath.sinh(this.value), FastMath.cosh(this.value));
    }

    @Override
    public FieldGradient<T> tanh() {
        T tanh = FastMath.tanh(this.value);
        return this.compose(tanh, (RealFieldElement)((RealFieldElement)((RealFieldElement)tanh.multiply(tanh)).negate()).add(1.0));
    }

    @Override
    public FieldGradient<T> acosh() {
        return this.compose(FastMath.acosh(this.value), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.value.multiply(this.value)).subtract(1.0)).sqrt()).reciprocal());
    }

    @Override
    public FieldGradient<T> asinh() {
        return this.compose(FastMath.asinh(this.value), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.value.multiply(this.value)).add(1.0)).sqrt()).reciprocal());
    }

    @Override
    public FieldGradient<T> atanh() {
        return this.compose(FastMath.atanh(this.value), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.value.multiply(this.value)).negate()).add(1.0)).reciprocal());
    }

    @Override
    public FieldGradient<T> toDegrees() {
        FieldGradient<T> result = this.newInstance(FastMath.toDegrees(this.value));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = FastMath.toDegrees(this.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> toRadians() {
        FieldGradient<T> result = this.newInstance(FastMath.toRadians(this.value));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = FastMath.toRadians(this.grad[i]);
        }
        return result;
    }

    public T taylor(double ... delta) {
        Object result = this.value;
        for (int i = 0; i < this.grad.length; ++i) {
            result = (RealFieldElement)result.add(this.grad[i].multiply(delta[i]));
        }
        return result;
    }

    public T taylor(T ... delta) {
        Object result = this.value;
        for (int i = 0; i < this.grad.length; ++i) {
            result = (RealFieldElement)result.add(this.grad[i].multiply(delta[i]));
        }
        return result;
    }

    public FieldGradient<T> linearCombination(FieldGradient<T>[] a, FieldGradient<T>[] b) {
        Field field = a[0].value.getField();
        int n = a.length;
        RealFieldElement[] a0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] a1 = (RealFieldElement[])MathArrays.buildArray(field, 2 * n);
        RealFieldElement[] b1 = (RealFieldElement[])MathArrays.buildArray(field, 2 * n);
        for (int i = 0; i < n; ++i) {
            FieldGradient<T> ai = a[i];
            FieldGradient<T> bi = b[i];
            a0[i] = ai.value;
            b0[i] = bi.value;
            a1[2 * i] = ai.value;
            b1[2 * i + 1] = bi.value;
        }
        FieldGradient<RealFieldElement> result = this.newInstance(a[0].value.linearCombination((RealFieldElement[])a0, (RealFieldElement[])b0));
        for (int k = 0; k < this.grad.length; ++k) {
            for (int i = 0; i < n; ++i) {
                a1[2 * i + 1] = a[i].grad[k];
                b1[2 * i] = b[i].grad[k];
            }
            result.grad[k] = a[0].value.linearCombination((RealFieldElement[])a1, (RealFieldElement[])b1);
        }
        return result;
    }

    public FieldGradient<T> linearCombination(T[] a, FieldGradient<T>[] b) {
        Field field = b[0].value.getField();
        int n = b.length;
        RealFieldElement[] b0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b1 = (RealFieldElement[])MathArrays.buildArray(field, n);
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].value;
        }
        FieldGradient<RealFieldElement> result = this.newInstance(b[0].value.linearCombination(a, (RealFieldElement[])b0));
        for (int k = 0; k < this.grad.length; ++k) {
            for (int i = 0; i < n; ++i) {
                b1[i] = b[i].grad[k];
            }
            result.grad[k] = b[0].value.linearCombination(a, (RealFieldElement[])b1);
        }
        return result;
    }

    public FieldGradient<T> linearCombination(double[] a, FieldGradient<T>[] b) {
        Field field = b[0].value.getField();
        int n = b.length;
        RealFieldElement[] b0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b1 = (RealFieldElement[])MathArrays.buildArray(field, n);
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].value;
        }
        FieldGradient<RealFieldElement> result = this.newInstance(b[0].value.linearCombination(a, (T[])b0));
        for (int k = 0; k < this.grad.length; ++k) {
            for (int i = 0; i < n; ++i) {
                b1[i] = b[i].grad[k];
            }
            result.grad[k] = b[0].value.linearCombination(a, (T[])b1);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(FieldGradient<T> a1, FieldGradient<T> b1, FieldGradient<T> a2, FieldGradient<T> b2) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)a1.value.linearCombination(a1.value, b1.value, a2.value, b2.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)a1.value.linearCombination(a1.value, b1.grad[i], a1.grad[i], b1.value, a2.value, b2.grad[i], a2.grad[i], b2.value);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(double a1, FieldGradient<T> b1, double a2, FieldGradient<T> b2) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)b1.value.linearCombination(a1, b1.value, a2, b2.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)b1.value.linearCombination(a1, b1.grad[i], a2, b2.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(FieldGradient<T> a1, FieldGradient<T> b1, FieldGradient<T> a2, FieldGradient<T> b2, FieldGradient<T> a3, FieldGradient<T> b3) {
        Field field = a1.value.getField();
        RealFieldElement[] a = (RealFieldElement[])MathArrays.buildArray(field, 6);
        RealFieldElement[] b = (RealFieldElement[])MathArrays.buildArray(field, 6);
        a[0] = a1.value;
        a[2] = a2.value;
        a[4] = a3.value;
        b[1] = b1.value;
        b[3] = b2.value;
        b[5] = b3.value;
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)a1.value.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            a[1] = a1.grad[i];
            a[3] = a2.grad[i];
            a[5] = a3.grad[i];
            b[0] = b1.grad[i];
            b[2] = b2.grad[i];
            b[4] = b3.grad[i];
            result.grad[i] = a1.value.linearCombination((RealFieldElement[])a, (RealFieldElement[])b);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(T a1, FieldGradient<T> b1, T a2, FieldGradient<T> b2, T a3, FieldGradient<T> b3) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)b1.value.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)b1.value.linearCombination(a1, b1.grad[i], a2, b2.grad[i], a3, b3.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(double a1, FieldGradient<T> b1, double a2, FieldGradient<T> b2, double a3, FieldGradient<T> b3) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)b1.value.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)b1.value.linearCombination(a1, b1.grad[i], a2, b2.grad[i], a3, b3.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(FieldGradient<T> a1, FieldGradient<T> b1, FieldGradient<T> a2, FieldGradient<T> b2, FieldGradient<T> a3, FieldGradient<T> b3, FieldGradient<T> a4, FieldGradient<T> b4) {
        Field field = a1.value.getField();
        RealFieldElement[] a = (RealFieldElement[])MathArrays.buildArray(field, 8);
        RealFieldElement[] b = (RealFieldElement[])MathArrays.buildArray(field, 8);
        a[0] = a1.value;
        a[2] = a2.value;
        a[4] = a3.value;
        a[6] = a4.value;
        b[1] = b1.value;
        b[3] = b2.value;
        b[5] = b3.value;
        b[7] = b4.value;
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)a1.value.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value, a4.value, b4.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            a[1] = a1.grad[i];
            a[3] = a2.grad[i];
            a[5] = a3.grad[i];
            a[7] = a4.grad[i];
            b[0] = b1.grad[i];
            b[2] = b2.grad[i];
            b[4] = b3.grad[i];
            b[6] = b4.grad[i];
            result.grad[i] = a1.value.linearCombination((RealFieldElement[])a, (RealFieldElement[])b);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(double a1, FieldGradient<T> b1, double a2, FieldGradient<T> b2, double a3, FieldGradient<T> b3, double a4, FieldGradient<T> b4) {
        FieldGradient<RealFieldElement> result = this.newInstance((RealFieldElement)b1.value.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value, a4, b4.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = (RealFieldElement)b1.value.linearCombination(a1, b1.grad[i], a2, b2.grad[i], a3, b3.grad[i], a4, b4.grad[i]);
        }
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FieldGradient) {
            FieldGradient rhs = (FieldGradient)other;
            if (!this.value.equals(rhs.value) || this.grad.length != rhs.grad.length) {
                return false;
            }
            for (int i = 0; i < this.grad.length; ++i) {
                if (this.grad[i].equals(rhs.grad[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 129 + 7 * this.value.hashCode() - 15 * Arrays.hashCode(this.grad);
    }
}

