/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalarFunction;
import org.orekit.time.TimeScales;
import org.orekit.utils.IERSConventions;

public class EclipticProvider
implements TransformProvider {
    private static final long serialVersionUID = 20140516L;
    private final IERSConventions conventions;
    private final transient TimeScalarFunction obliquity;

    @DefaultDataContext
    public EclipticProvider(IERSConventions conventions) {
        this(conventions, DataContext.getDefault().getTimeScales());
    }

    public EclipticProvider(IERSConventions conventions, TimeScales timeScales) {
        this.conventions = conventions;
        this.obliquity = conventions.getMeanObliquityFunction(timeScales);
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double epsA = this.obliquity.value(date);
        return new Transform(date, new Rotation(Vector3D.MINUS_I, epsA, RotationConvention.VECTOR_OPERATOR));
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        T epsA = this.obliquity.value(date);
        return new FieldTransform<T>(date, new FieldRotation(FieldVector3D.getMinusI(date.getField()), epsA, RotationConvention.VECTOR_OPERATOR));
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.conventions);
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20140516L;
        private final IERSConventions conventions;

        DataTransferObject(IERSConventions conventions) {
            this.conventions = conventions;
        }

        private Object readResolve() {
            try {
                return new EclipticProvider(this.conventions);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

