/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.clustering.distance;

import org.hipparchus.clustering.distance.DistanceMeasure;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class EarthMoversDistance
implements DistanceMeasure {
    private static final long serialVersionUID = -5406732779747414922L;

    @Override
    public double compute(double[] a, double[] b) throws MathIllegalArgumentException {
        MathArrays.checkEqualLength((double[])a, (double[])b);
        double lastDistance = 0.0;
        double totalDistance = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double currentDistance = a[i] + lastDistance - b[i];
            totalDistance += FastMath.abs((double)currentDistance);
            lastDistance = currentDistance;
        }
        return totalDistance;
    }
}

