/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdaptiveStepsizeIntegrator;
import org.hipparchus.ode.nonstiff.DormandPrince853Integrator;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.util.FastMath;

public abstract class MultistepIntegrator
extends AdaptiveStepsizeIntegrator {
    protected double[] scaled;
    protected Array2DRowRealMatrix nordsieck;
    private ODEIntegrator starter;
    private final int nSteps;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected MultistepIntegrator(String name, int nSteps, int order, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(name, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        if (nSteps < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, new Object[]{nSteps, 2, true});
        }
        this.starter = new DormandPrince853Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow((double)2.0, (double)(-this.exp)));
    }

    protected MultistepIntegrator(String name, int nSteps, int order, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(name, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        if (nSteps < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, new Object[]{nSteps, 2, true});
        }
        this.starter = new DormandPrince853Integrator(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow((double)2.0, (double)(-this.exp)));
    }

    public ODEIntegrator getStarterIntegrator() {
        return this.starter;
    }

    public void setStarterIntegrator(ODEIntegrator starterIntegrator) {
        this.starter = starterIntegrator;
    }

    protected void start(ExpandableODE equations, ODEState initialState, double finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.starter.clearEventHandlers();
        this.starter.clearStepHandlers();
        this.starter.addStepHandler(new NordsieckInitializer((this.nSteps + 3) / 2));
        try {
            this.starter.integrate(this.getEquations(), initialState, finalTime);
            throw new MathIllegalStateException((Localizable)LocalizedODEFormats.MULTISTEP_STARTER_STOPPED_EARLY, new Object[0]);
        }
        catch (InitializationCompletedMarkerException icme) {
            this.getEvaluationsCounter().increment(this.starter.getEvaluations());
            this.starter.clearStepHandlers();
            return;
        }
    }

    protected abstract Array2DRowRealMatrix initializeHighOrderDerivatives(double var1, double[] var3, double[][] var4, double[][] var5);

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double minReduction) {
        this.minReduction = minReduction;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double safety) {
        this.safety = safety;
    }

    public int getNSteps() {
        return this.nSteps;
    }

    protected void rescale(double newStepSize) {
        double ratio = newStepSize / this.getStepSize();
        for (int i = 0; i < this.scaled.length; ++i) {
            this.scaled[i] = this.scaled[i] * ratio;
        }
        double[][] nData = this.nordsieck.getDataRef();
        double power = ratio;
        for (int i = 0; i < nData.length; ++i) {
            power *= ratio;
            double[] nDataI = nData[i];
            for (int j = 0; j < nDataI.length; ++j) {
                nDataI[j] = nDataI[j] * power;
            }
        }
        this.setStepSize(newStepSize);
    }

    protected double computeStepGrowShrinkFactor(double error) {
        return FastMath.min((double)this.maxGrowth, (double)FastMath.max((double)this.minReduction, (double)(this.safety * FastMath.pow((double)error, (double)this.exp))));
    }

    private static class InitializationCompletedMarkerException
    extends RuntimeException {
        private static final long serialVersionUID = -1914085471038046418L;

        InitializationCompletedMarkerException() {
            super((Throwable)null);
        }
    }

    private class NordsieckInitializer
    implements ODEStepHandler {
        private int count = 0;
        private ODEStateAndDerivative savedStart;
        private final double[] t;
        private final double[][] y;
        private final double[][] yDot;

        NordsieckInitializer(int nbStartPoints) {
            this.t = new double[nbStartPoints];
            this.y = new double[nbStartPoints][];
            this.yDot = new double[nbStartPoints][];
        }

        @Override
        public void handleStep(ODEStateInterpolator interpolator, boolean isLast) throws MathIllegalStateException {
            if (this.count == 0) {
                this.savedStart = interpolator.getPreviousState();
                this.t[0] = this.savedStart.getTime();
                this.y[0] = this.savedStart.getCompleteState();
                this.yDot[0] = this.savedStart.getCompleteDerivative();
            }
            ++this.count;
            ODEStateAndDerivative curr = interpolator.getCurrentState();
            this.t[this.count] = curr.getTime();
            this.y[this.count] = curr.getCompleteState();
            this.yDot[this.count] = curr.getCompleteDerivative();
            if (this.count == this.t.length - 1) {
                MultistepIntegrator.this.setStepStart(this.savedStart);
                double rawStep = (this.t[this.t.length - 1] - this.t[0]) / (double)(this.t.length - 1);
                MultistepIntegrator.this.setStepSize(MultistepIntegrator.this.filterStep(rawStep, rawStep >= 0.0, true));
                MultistepIntegrator.this.scaled = (double[])this.yDot[0].clone();
                int j = 0;
                while (j < MultistepIntegrator.this.scaled.length) {
                    int n = j++;
                    MultistepIntegrator.this.scaled[n] = MultistepIntegrator.this.scaled[n] * MultistepIntegrator.this.getStepSize();
                }
                MultistepIntegrator.this.nordsieck = MultistepIntegrator.this.initializeHighOrderDerivatives(MultistepIntegrator.this.getStepSize(), this.t, this.y, this.yDot);
                throw new InitializationCompletedMarkerException();
            }
        }
    }
}

