/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.transform;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.UTF8Control;

public enum LocalizedFFTFormats implements Localizable
{
    FIRST_ELEMENT_NOT_ZERO("first element is not 0: {0}"),
    NOT_POWER_OF_TWO("{0} is not a power of 2"),
    NOT_POWER_OF_TWO_CONSIDER_PADDING("{0} is not a power of 2, consider padding for fix"),
    NOT_POWER_OF_TWO_PLUS_ONE("{0} is not a power of 2 plus one");

    private final String sourceFormat;

    private LocalizedFFTFormats(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    public String getSourceString() {
        return this.sourceFormat;
    }

    public String getLocalizedString(Locale locale) {
        try {
            String translated;
            String path = LocalizedFFTFormats.class.getName().replaceAll("\\.", "/");
            ResourceBundle bundle = ResourceBundle.getBundle("assets/" + path, locale, (ResourceBundle.Control)new UTF8Control());
            if (bundle.getLocale().getLanguage().equals(locale.getLanguage()) && (translated = bundle.getString(this.name())) != null && translated.length() > 0 && !translated.toLowerCase(locale).contains("missing translation")) {
                return translated;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.sourceFormat;
    }
}

