/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.transform;

import java.io.Serializable;
import org.hipparchus.analysis.FunctionUtils;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.transform.LocalizedFFTFormats;
import org.hipparchus.transform.RealTransformer;
import org.hipparchus.transform.TransformType;
import org.hipparchus.transform.TransformUtils;
import org.hipparchus.util.ArithmeticUtils;

public class FastHadamardTransformer
implements RealTransformer,
Serializable {
    static final long serialVersionUID = 20120211L;

    @Override
    public double[] transform(double[] f, TransformType type) {
        if (type == TransformType.FORWARD) {
            return this.fht(f);
        }
        return TransformUtils.scaleArray(this.fht(f), 1.0 / (double)f.length);
    }

    @Override
    public double[] transform(UnivariateFunction f, double min, double max, int n, TransformType type) {
        return this.transform(FunctionUtils.sample((UnivariateFunction)f, (double)min, (double)max, (int)n), type);
    }

    public int[] transform(int[] f) {
        return this.fht(f);
    }

    protected double[] fht(double[] x) throws MathIllegalArgumentException {
        int n = x.length;
        int halfN = n / 2;
        if (!ArithmeticUtils.isPowerOfTwo((long)n)) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFFTFormats.NOT_POWER_OF_TWO, new Object[]{n});
        }
        double[] yPrevious = new double[n];
        double[] yCurrent = (double[])x.clone();
        for (int j = 1; j < n; j <<= 1) {
            int twoI;
            int i;
            double[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i = 0; i < halfN; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i = halfN; i < n; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI - n] - yPrevious[twoI - n + 1];
            }
        }
        return yCurrent;
    }

    protected int[] fht(int[] x) throws MathIllegalArgumentException {
        int n = x.length;
        int halfN = n / 2;
        if (!ArithmeticUtils.isPowerOfTwo((long)n)) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFFTFormats.NOT_POWER_OF_TWO, new Object[]{n});
        }
        int[] yPrevious = new int[n];
        int[] yCurrent = (int[])x.clone();
        for (int j = 1; j < n; j <<= 1) {
            int twoI;
            int i;
            int[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i = 0; i < halfN; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i = halfN; i < n; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI - n] - yPrevious[twoI - n + 1];
            }
        }
        return yCurrent;
    }
}

