/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.propagation.semianalytical.dsst.forces.ForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;

class DSSTZonalContext
extends ForceModelContext {
    private final double A;
    private double X;
    private double XX;
    private double XXX;
    private double ooAB;
    private double BoA;
    private double BoABpo;
    private double mCo2AB;
    private double m2aoA;
    private double muoa;
    private double roa;
    private final double n;
    private double hk;
    private double k2mh2;
    private double k2mh2o2;
    private double oon2a2;
    private double oon2a;
    private double x3on2a;
    private double xon2a2;
    private double cxo2n2a2;
    private double x2on2a2xp1;
    private double BB;

    DSSTZonalContext(AuxiliaryElements auxiliaryElements, UnnormalizedSphericalHarmonicsProvider provider, double[] parameters) {
        super(auxiliaryElements);
        double mu = parameters[0];
        double absA = FastMath.abs((double)auxiliaryElements.getSma());
        this.n = FastMath.sqrt((double)(mu / absA)) / absA;
        this.A = FastMath.sqrt((double)(mu * auxiliaryElements.getSma()));
        this.X = 1.0 / auxiliaryElements.getB();
        this.XX = this.X * this.X;
        this.XXX = this.X * this.XX;
        this.ooAB = 1.0 / (this.A * auxiliaryElements.getB());
        this.BoA = auxiliaryElements.getB() / this.A;
        this.mCo2AB = -auxiliaryElements.getC() * this.ooAB / 2.0;
        this.BoABpo = this.BoA / (1.0 + auxiliaryElements.getB());
        this.m2aoA = -2.0 * auxiliaryElements.getSma() / this.A;
        this.muoa = mu / auxiliaryElements.getSma();
        this.roa = provider.getAe() / auxiliaryElements.getSma();
        this.hk = auxiliaryElements.getH() * auxiliaryElements.getK();
        this.k2mh2 = auxiliaryElements.getK() * auxiliaryElements.getK() - auxiliaryElements.getH() * auxiliaryElements.getH();
        this.k2mh2o2 = this.k2mh2 / 2.0;
        this.oon2a2 = 1.0 / (this.A * this.n);
        this.oon2a = auxiliaryElements.getSma() * this.oon2a2;
        this.x3on2a = this.XXX * this.oon2a;
        this.xon2a2 = this.X * this.oon2a2;
        this.cxo2n2a2 = this.xon2a2 * auxiliaryElements.getC() / 2.0;
        this.x2on2a2xp1 = this.xon2a2 * this.X / (this.X + 1.0);
        this.BB = auxiliaryElements.getB() * auxiliaryElements.getB();
    }

    public double getX() {
        return this.X;
    }

    public double getXX() {
        return this.XX;
    }

    public double getXXX() {
        return this.XXX;
    }

    public double getM2aoA() {
        return this.m2aoA;
    }

    public double getBoA() {
        return this.BoA;
    }

    public double getOoAB() {
        return this.ooAB;
    }

    public double getMCo2AB() {
        return this.mCo2AB;
    }

    public double getBoABpo() {
        return this.BoABpo;
    }

    public double getMuoa() {
        return this.muoa;
    }

    public double getRoa() {
        return this.roa;
    }

    public double getMeanMotion() {
        return this.n;
    }

    public double getHK() {
        return this.hk;
    }

    public double getK2MH2() {
        return this.k2mh2;
    }

    public double getK2MH2O2() {
        return this.k2mh2o2;
    }

    public double getOON2A2() {
        return this.oon2a2;
    }

    public double getX3ON2A() {
        return this.x3on2a;
    }

    public double getXON2A2() {
        return this.xon2a2;
    }

    public double getCXO2N2A2() {
        return this.cxo2n2a2;
    }

    public double getX2ON2A2XP1() {
        return this.x2on2a2xp1;
    }

    public double getBB() {
        return this.BB;
    }
}

