/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.gnss.AbstractGNSSPropagator;
import org.orekit.propagation.analytical.gnss.BeidouOrbitalElements;
import org.orekit.utils.IERSConventions;

public class BeidouPropagator
extends AbstractGNSSPropagator {
    private static final double BEIDOU_AV = 7.292115E-5;
    private static final double BEIDOU_CYCLE_DURATION = 4.9545216E9;
    private final BeidouOrbitalElements bdsOrbit;

    private BeidouPropagator(Builder builder) {
        super(builder.orbit, builder.attitudeProvider, builder.eci, builder.ecef, builder.mass, 7.292115E-5, 4.9545216E9, 3.986004418E14);
        this.bdsOrbit = builder.orbit;
    }

    public BeidouOrbitalElements getBeidouOrbitalElements() {
        return this.bdsOrbit;
    }

    public static class Builder {
        private final BeidouOrbitalElements orbit;
        private AttitudeProvider attitudeProvider;
        private double mass = 1000.0;
        private Frame eci = null;
        private Frame ecef = null;

        @DefaultDataContext
        public Builder(BeidouOrbitalElements bdsOrbElt) {
            this(bdsOrbElt, DataContext.getDefault().getFrames());
        }

        public Builder(BeidouOrbitalElements bdsOrbElt, Frames frames) {
            this.orbit = bdsOrbElt;
            this.eci = frames.getEME2000();
            this.ecef = frames.getITRF(IERSConventions.IERS_2010, true);
            this.attitudeProvider = Propagator.getDefaultLaw(frames);
        }

        public Builder attitudeProvider(AttitudeProvider userProvider) {
            this.attitudeProvider = userProvider;
            return this;
        }

        public Builder mass(double userMass) {
            this.mass = userMass;
            return this;
        }

        public Builder eci(Frame inertial) {
            this.eci = inertial;
            return this;
        }

        public Builder ecef(Frame bodyFixed) {
            this.ecef = bodyFixed;
            return this;
        }

        public BeidouPropagator build() {
            return new BeidouPropagator(this);
        }
    }
}

