/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.SinCos;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;

class FieldNeQuickParameters<T extends RealFieldElement<T>> {
    private static final double X0 = 86.23292796211615;
    private final T nmF2;
    private final T hmF2;
    private final T hmF1;
    private final T hmE;
    private final T b2Bot;
    private final T b1Top;
    private final T b1Bot;
    private final T beTop;
    private final T beBot;
    private final T h0;
    private final T[] amplitudes;

    FieldNeQuickParameters(Field<T> field, DateTimeComponents dateTime, double[][][] f2, double[][][] fm3, T latitude, T longitude, double[] alpha, double[][] modipGrip) {
        RealFieldElement nmF1;
        RealFieldElement zero = (RealFieldElement)field.getZero();
        T modip = this.computeMODIP(latitude, longitude, modipGrip);
        T az = this.computeAz(modip, alpha);
        RealFieldElement azr = (RealFieldElement)FastMath.sqrt((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)az.subtract(63.7)).multiply(1123.6)).add(167273.0))).subtract(408.99);
        DateComponents date = dateTime.getDate();
        TimeComponents time = dateTime.getTime();
        double hours = time.getSecondsInUTCDay() / 3600.0;
        T xeff = this.computeEffectiveSolarAngle(date.getMonth(), hours, latitude, longitude);
        RealFieldElement[][] af2 = (RealFieldElement[][])MathArrays.buildArray(field, (int)76, (int)13);
        for (int j = 0; j < 76; ++j) {
            for (int k = 0; k < 13; ++k) {
                af2[j][k] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)azr.multiply(0.01)).negate()).add(1.0)).multiply(f2[0][j][k])).add(((RealFieldElement)azr.multiply(0.01)).multiply(f2[1][j][k]));
            }
        }
        RealFieldElement[][] am3 = (RealFieldElement[][])MathArrays.buildArray(field, (int)49, (int)9);
        for (int j = 0; j < 49; ++j) {
            for (int k = 0; k < 9; ++k) {
                am3[j][k] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)azr.multiply(0.01)).negate()).add(1.0)).multiply(fm3[0][j][k])).add(((RealFieldElement)azr.multiply(0.01)).multiply(fm3[1][j][k]));
            }
        }
        this.hmE = (RealFieldElement)((RealFieldElement)field.getZero()).add(120.0);
        T foE = this.computefoE(date.getMonth(), az, xeff, latitude);
        RealFieldElement nmE = (RealFieldElement)((RealFieldElement)foE.multiply(foE)).multiply(0.124);
        double t = FastMath.toRadians((double)(15.0 * hours)) - Math.PI;
        RealFieldElement[] cf2 = this.computeCF2(field, af2, t);
        RealFieldElement[] cm3 = this.computeCm3(field, am3, t);
        RealFieldElement foF2 = this.computefoF2((Field)field, (RealFieldElement)modip, cf2, (RealFieldElement)latitude, (RealFieldElement)longitude);
        RealFieldElement mF2 = this.computeMF2((Field)field, (RealFieldElement)modip, cm3, (RealFieldElement)latitude, (RealFieldElement)longitude);
        this.nmF2 = (RealFieldElement)((RealFieldElement)foF2.multiply((Object)foF2)).multiply(0.124);
        this.hmF2 = this.computehmF2(field, foE, foF2, mF2);
        RealFieldElement foF1 = this.computefoF1(field, foE, foF2);
        if (foF1.getReal() <= 0.0 && foE.getReal() > 2.0) {
            RealFieldElement foEpopf = (RealFieldElement)foE.add(0.5);
            nmF1 = (RealFieldElement)((RealFieldElement)foEpopf.multiply((Object)foEpopf)).multiply(0.124);
        } else {
            nmF1 = (RealFieldElement)((RealFieldElement)foF1.multiply((Object)foF1)).multiply(0.124);
        }
        this.hmF1 = (RealFieldElement)((RealFieldElement)this.hmF2.add(this.hmE)).multiply(0.5);
        RealFieldElement a = (RealFieldElement)this.clipExp((RealFieldElement)((RealFieldElement)((RealFieldElement)FastMath.log((RealFieldElement)((RealFieldElement)foF2.multiply((Object)foF2))).multiply(0.857)).add(FastMath.log((RealFieldElement)mF2).multiply(2.02))).add(-3.467)).multiply(0.01);
        this.b2Bot = (RealFieldElement)((RealFieldElement)this.nmF2.divide((Object)a)).multiply(0.385);
        this.b1Top = (RealFieldElement)((RealFieldElement)this.hmF2.subtract(this.hmF1)).multiply(0.3);
        this.b1Bot = (RealFieldElement)((RealFieldElement)this.hmF1.subtract(this.hmE)).multiply(0.5);
        this.beTop = FastMath.max(this.b1Bot, (RealFieldElement)((RealFieldElement)zero.add(7.0)));
        this.beBot = (RealFieldElement)zero.add(5.0);
        this.amplitudes = this.computeLayerAmplitudes(field, nmE, nmF1, foF1);
        this.h0 = this.computeH0(field, date.getMonth(), azr);
    }

    public T getNmF2() {
        return this.nmF2;
    }

    public T getHmF2() {
        return this.hmF2;
    }

    public T getHmF1() {
        return this.hmF1;
    }

    public T getHmE() {
        return this.hmE;
    }

    public T getB2Bot() {
        return this.b2Bot;
    }

    public T getB1Top() {
        return this.b1Top;
    }

    public T getB1Bot() {
        return this.b1Bot;
    }

    public T getBEBot() {
        return this.beBot;
    }

    public T getBETop() {
        return this.beTop;
    }

    public T[] getLayerAmplitudes() {
        return (RealFieldElement[])this.amplitudes.clone();
    }

    public T getH0() {
        return this.h0;
    }

    private T computeMODIP(T lat, T lon, double[][] stModip) {
        RealFieldElement zero = (RealFieldElement)lat.getField().getZero();
        RealFieldElement latitude = FastMath.toDegrees(lat);
        RealFieldElement longitude = FastMath.toDegrees(lon);
        if (latitude.getReal() == 90.0 || latitude.getReal() == -90.0) {
            return (T)latitude;
        }
        int lF = (int)((longitude.getReal() + 180.0) * 0.1);
        int l = lF - 2;
        if (l < 0) {
            l += 36;
        } else if (l > 33) {
            l -= 36;
        }
        RealFieldElement a = (RealFieldElement)((RealFieldElement)((RealFieldElement)latitude.add(90.0)).multiply(0.2)).add(1.0);
        RealFieldElement aF = FastMath.floor((RealFieldElement)a);
        RealFieldElement x = (RealFieldElement)a.subtract((Object)aF);
        int i = (int)aF.getReal() - 2;
        RealFieldElement z1 = this.interpolate((RealFieldElement)zero.add(stModip[i + 1][l + 2]), (RealFieldElement)zero.add(stModip[i + 2][l + 2]), (RealFieldElement)zero.add(stModip[i + 3][l + 2]), (RealFieldElement)zero.add(stModip[i + 4][l + 2]), x);
        RealFieldElement z2 = this.interpolate((RealFieldElement)zero.add(stModip[i + 1][l + 3]), (RealFieldElement)zero.add(stModip[i + 2][l + 3]), (RealFieldElement)zero.add(stModip[i + 3][l + 3]), (RealFieldElement)zero.add(stModip[i + 4][l + 3]), x);
        RealFieldElement z3 = this.interpolate((RealFieldElement)zero.add(stModip[i + 1][l + 4]), (RealFieldElement)zero.add(stModip[i + 2][l + 4]), (RealFieldElement)zero.add(stModip[i + 3][l + 4]), (RealFieldElement)zero.add(stModip[i + 4][l + 4]), x);
        RealFieldElement z4 = this.interpolate((RealFieldElement)zero.add(stModip[i + 1][l + 5]), (RealFieldElement)zero.add(stModip[i + 2][l + 5]), (RealFieldElement)zero.add(stModip[i + 3][l + 5]), (RealFieldElement)zero.add(stModip[i + 4][l + 5]), x);
        RealFieldElement b = (RealFieldElement)((RealFieldElement)longitude.add(180.0)).multiply(0.1);
        RealFieldElement bF = FastMath.floor((RealFieldElement)b);
        RealFieldElement y = (RealFieldElement)b.subtract((Object)bF);
        RealFieldElement modip = this.interpolate(z1, z2, z3, z4, y);
        return (T)modip;
    }

    private T computeAz(T modip, double[] alpha) {
        Field field = modip.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        if (alpha[0] == 0.0 && alpha[1] == 0.0 && alpha[2] == 0.0) {
            return (T)((RealFieldElement)zero.add(63.7));
        }
        RealFieldElement az = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)modip.multiply(alpha[2])).add(alpha[1])).multiply(modip)).add(alpha[0]);
        az = FastMath.max((RealFieldElement)zero, (RealFieldElement)az);
        az = FastMath.min((RealFieldElement)((RealFieldElement)zero.add(400.0)), (RealFieldElement)az);
        return (T)az;
    }

    private T computeEffectiveSolarAngle(int month, double hours, T latitude, T longitude) {
        RealFieldElement zero = (RealFieldElement)latitude.getField().getZero();
        RealFieldElement lt = (RealFieldElement)((RealFieldElement)longitude.divide(FastMath.toRadians((double)15.0))).add(hours);
        double dy = 30.5 * (double)month - 15.0;
        double t = dy + (18.0 - hours) / 24.0;
        double am = FastMath.toRadians((double)(0.9856 * t - 3.289));
        double al = am + FastMath.toRadians((double)(1.916 * FastMath.sin((double)am) + 0.02 * FastMath.sin((double)(2.0 * am)) + 282.634));
        double sDec = 0.39782 * FastMath.sin((double)al);
        double cDec = FastMath.sqrt((double)(1.0 - sDec * sDec));
        FieldSinCos scLat = FastMath.sinCos(latitude);
        RealFieldElement coef = (RealFieldElement)((RealFieldElement)((RealFieldElement)lt.negate()).add(12.0)).multiply(0.2617993877991494);
        RealFieldElement cZenith = (RealFieldElement)((RealFieldElement)((RealFieldElement)scLat.sin()).multiply(sDec)).add(((RealFieldElement)((RealFieldElement)scLat.cos()).multiply(cDec)).multiply((Object)FastMath.cos((RealFieldElement)coef)));
        RealFieldElement angle = FastMath.atan2((RealFieldElement)FastMath.sqrt((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)cZenith.multiply((Object)cZenith)).negate()).add(1.0))), (RealFieldElement)cZenith);
        RealFieldElement x = FastMath.toDegrees((RealFieldElement)angle);
        RealFieldElement xeff = this.join((RealFieldElement)((RealFieldElement)((RealFieldElement)this.clipExp((RealFieldElement)((RealFieldElement)((RealFieldElement)x.multiply(0.2)).negate()).add(20.0)).multiply(0.24)).negate()).add(90.0), x, (RealFieldElement)zero.add(12.0), (RealFieldElement)x.subtract(86.23292796211615));
        return (T)FastMath.toRadians((RealFieldElement)xeff);
    }

    private T computefoE(int month, T az, T xeff, T latitude) {
        RealFieldElement lat = FastMath.toDegrees(latitude);
        RealFieldElement sqAz = FastMath.sqrt(az);
        int seas = month == 1 || month == 2 || month == 11 || month == 12 ? -1 : (month == 3 || month == 4 || month == 9 || month == 10 ? 0 : 1);
        RealFieldElement ee = this.clipExp((RealFieldElement)lat.multiply(0.3));
        RealFieldElement seasp = (RealFieldElement)((RealFieldElement)((RealFieldElement)ee.subtract(1.0)).divide(ee.add(1.0))).multiply(seas);
        RealFieldElement coef = (RealFieldElement)((RealFieldElement)((RealFieldElement)seasp.multiply(0.019)).negate()).add(1.112);
        RealFieldElement foE = FastMath.sqrt((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)coef.multiply((Object)coef)).multiply((Object)sqAz)).multiply(FastMath.cos(xeff).pow(0.6))).add(0.49)));
        return (T)foE;
    }

    private T computehmF2(Field<T> field, T foE, T foF2, T mF2) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement fo = (RealFieldElement)foF2.divide(foE);
        RealFieldElement ratio = this.join(fo, (RealFieldElement)zero.add(1.75), (RealFieldElement)zero.add(20.0), (RealFieldElement)fo.subtract(1.75));
        RealFieldElement deltaM = (RealFieldElement)zero.subtract(0.012);
        if (foE.getReal() >= 1.0E-30) {
            deltaM = (RealFieldElement)deltaM.add(((RealFieldElement)((RealFieldElement)ratio.subtract(1.215)).divide(0.253)).reciprocal());
        }
        RealFieldElement mF2Sq = (RealFieldElement)mF2.multiply(mF2);
        RealFieldElement temp = FastMath.sqrt((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)mF2Sq.multiply(0.0196)).add(1.0)).divide(((RealFieldElement)mF2Sq.multiply(1.2967)).subtract(1.0))));
        RealFieldElement height = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)mF2.multiply(1490.0)).multiply((Object)temp)).divide(mF2.add((Object)deltaM))).subtract(176.0);
        return (T)height;
    }

    private T[] computeCF2(Field<T> field, T[][] af2, double t) {
        RealFieldElement[] cf2 = (RealFieldElement[])MathArrays.buildArray(field, (int)76);
        for (int i = 0; i < cf2.length; ++i) {
            RealFieldElement sum = (RealFieldElement)field.getZero();
            for (int k = 0; k < 6; ++k) {
                SinCos sc = FastMath.sinCos((double)((double)(k + 1) * t));
                sum = (RealFieldElement)sum.add(((RealFieldElement)af2[i][2 * k + 1].multiply(sc.sin())).add(af2[i][2 * (k + 1)].multiply(sc.cos())));
            }
            cf2[i] = (RealFieldElement)af2[i][0].add((Object)sum);
        }
        return cf2;
    }

    private T[] computeCm3(Field<T> field, T[][] am3, double t) {
        RealFieldElement[] cm3 = (RealFieldElement[])MathArrays.buildArray(field, (int)49);
        for (int i = 0; i < cm3.length; ++i) {
            RealFieldElement sum = (RealFieldElement)field.getZero();
            for (int k = 0; k < 4; ++k) {
                SinCos sc = FastMath.sinCos((double)((double)(k + 1) * t));
                sum = (RealFieldElement)sum.add(((RealFieldElement)am3[i][2 * k + 1].multiply(sc.sin())).add(am3[i][2 * (k + 1)].multiply(sc.cos())));
            }
            cm3[i] = (RealFieldElement)am3[i][0].add((Object)sum);
        }
        return cm3;
    }

    private T computefoF2(Field<T> field, T modip, T[] cf2, T latitude, T longitude) {
        RealFieldElement one = (RealFieldElement)field.getOne();
        int[] q = new int[]{12, 12, 9, 5, 2, 1, 1, 1, 1};
        Object[] g = (RealFieldElement[])MathArrays.buildArray(field, (int)cf2.length);
        g[0] = one;
        RealFieldElement sinMODIP = FastMath.sin((RealFieldElement)FastMath.toRadians(modip));
        RealFieldElement[] m = (RealFieldElement[])MathArrays.buildArray(field, (int)12);
        m[0] = one;
        for (int i = 1; i < q[0]; ++i) {
            m[i] = (RealFieldElement)sinMODIP.multiply((Object)m[i - 1]);
            g[i] = m[i];
        }
        RealFieldElement cosLat = FastMath.cos(latitude);
        RealFieldElement[] p = (RealFieldElement[])MathArrays.buildArray(field, (int)8);
        p[0] = cosLat;
        for (int n = 2; n < 9; ++n) {
            p[n - 1] = (RealFieldElement)cosLat.multiply((Object)p[n - 2]);
        }
        int index = 12;
        for (int i = 1; i < q.length; ++i) {
            FieldSinCos sc = FastMath.sinCos((RealFieldElement)((RealFieldElement)longitude.multiply(i)));
            for (int j = 0; j < q[i]; ++j) {
                g[index++] = (RealFieldElement)((RealFieldElement)m[j].multiply((Object)p[i - 1])).multiply(sc.cos());
                g[index++] = (RealFieldElement)((RealFieldElement)m[j].multiply((Object)p[i - 1])).multiply(sc.sin());
            }
        }
        RealFieldElement frequency = (RealFieldElement)one.linearCombination(g, (Object[])cf2);
        return (T)frequency;
    }

    private T computeMF2(Field<T> field, T modip, T[] cm3, T latitude, T longitude) {
        RealFieldElement one = (RealFieldElement)field.getOne();
        int[] r = new int[]{7, 8, 6, 3, 2, 1, 1};
        Object[] g = (RealFieldElement[])MathArrays.buildArray(field, (int)cm3.length);
        g[0] = one;
        RealFieldElement sinMODIP = FastMath.sin((RealFieldElement)FastMath.toRadians(modip));
        RealFieldElement[] m = (RealFieldElement[])MathArrays.buildArray(field, (int)12);
        m[0] = one;
        for (int i = 1; i < 12; ++i) {
            m[i] = (RealFieldElement)sinMODIP.multiply((Object)m[i - 1]);
            if (i >= 7) continue;
            g[i] = m[i];
        }
        RealFieldElement cosLat = FastMath.cos(latitude);
        RealFieldElement[] p = (RealFieldElement[])MathArrays.buildArray(field, (int)8);
        p[0] = cosLat;
        for (int n = 2; n < 9; ++n) {
            p[n - 1] = (RealFieldElement)cosLat.multiply((Object)p[n - 2]);
        }
        int index = 7;
        for (int i = 1; i < r.length; ++i) {
            FieldSinCos sc = FastMath.sinCos((RealFieldElement)((RealFieldElement)longitude.multiply(i)));
            for (int j = 0; j < r[i]; ++j) {
                g[index++] = (RealFieldElement)((RealFieldElement)m[j].multiply((Object)p[i - 1])).multiply(sc.cos());
                g[index++] = (RealFieldElement)((RealFieldElement)m[j].multiply((Object)p[i - 1])).multiply(sc.sin());
            }
        }
        RealFieldElement m3000 = (RealFieldElement)one.linearCombination(g, (Object[])cm3);
        return (T)m3000;
    }

    private T computefoF1(Field<T> field, T foE, T foF2) {
        RealFieldElement temp;
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement temp2 = this.join(zero, temp = this.join((RealFieldElement)foE.multiply(1.4), zero, (RealFieldElement)zero.add(1000.0), (RealFieldElement)foE.subtract(2.0)), (RealFieldElement)zero.add(1000.0), (RealFieldElement)foE.subtract((Object)temp));
        RealFieldElement value = this.join(temp2, (RealFieldElement)temp2.multiply(0.85), (RealFieldElement)zero.add(60.0), (RealFieldElement)((RealFieldElement)foF2.multiply(0.85)).subtract((Object)temp2));
        if (value.getReal() < 1.0E-6) {
            return (T)zero;
        }
        return (T)value;
    }

    private T[] computeLayerAmplitudes(Field<T> field, T nmE, T nmF1, T foF1) {
        RealFieldElement a1;
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement[] amplitude = (RealFieldElement[])MathArrays.buildArray(field, (int)3);
        amplitude[0] = a1 = (RealFieldElement)this.nmF2.multiply(4.0);
        if (foF1.getReal() < 0.5) {
            amplitude[1] = zero;
            amplitude[2] = (RealFieldElement)((RealFieldElement)nmE.subtract((Object)this.epst(a1, this.hmF2, this.b2Bot, this.hmE))).multiply(4.0);
        } else {
            RealFieldElement a2a = zero;
            RealFieldElement a3a = (RealFieldElement)nmE.multiply(4.0);
            for (int i = 0; i < 5; ++i) {
                a2a = (RealFieldElement)((RealFieldElement)((RealFieldElement)nmF1.subtract((Object)this.epst(a1, this.hmF2, this.b2Bot, this.hmF1))).subtract((Object)this.epst(a3a, this.hmE, this.beTop, this.hmF1))).multiply(4.0);
                a2a = this.join(a2a, (RealFieldElement)nmF1.multiply(0.8), (RealFieldElement)field.getOne(), (RealFieldElement)a2a.subtract(nmF1.multiply(0.8)));
                a3a = (RealFieldElement)((RealFieldElement)((RealFieldElement)nmE.subtract((Object)this.epst(a2a, this.hmF1, this.b1Bot, this.hmE))).subtract((Object)this.epst(a1, this.hmF2, this.b2Bot, this.hmE))).multiply(4.0);
            }
            amplitude[1] = a2a;
            amplitude[2] = this.join(a3a, (RealFieldElement)zero.add(0.05), (RealFieldElement)zero.add(60.0), (RealFieldElement)a3a.subtract(0.005));
        }
        return amplitude;
    }

    private T computeH0(Field<T> field, int month, T azr) {
        RealFieldElement ka;
        RealFieldElement one = (RealFieldElement)field.getOne();
        if (month > 3 && month < 10) {
            ka = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)azr.multiply(0.014)).add(this.hmF2.multiply(0.008))).negate()).add(6.705);
        } else {
            RealFieldElement ratio = (RealFieldElement)this.hmF2.divide(this.b2Bot);
            ka = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ratio.multiply((Object)ratio)).multiply(0.097)).add(this.nmF2.multiply(0.153))).add(-7.77);
        }
        RealFieldElement kb = this.join(ka, (RealFieldElement)one.multiply(2.0), one, (RealFieldElement)ka.subtract(2.0));
        kb = this.join((RealFieldElement)one.multiply(8.0), kb, one, (RealFieldElement)kb.subtract(8.0));
        RealFieldElement hA = (RealFieldElement)kb.multiply(this.b2Bot);
        RealFieldElement x = (RealFieldElement)((RealFieldElement)hA.subtract(150.0)).multiply(0.01);
        RealFieldElement v = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)x.multiply(0.041163)).subtract(0.183981)).multiply((Object)x)).add(1.424472);
        RealFieldElement h = (RealFieldElement)hA.divide((Object)v);
        return (T)h;
    }

    private T clipExp(T power) {
        RealFieldElement zero = (RealFieldElement)power.getField().getZero();
        if (power.getReal() > 80.0) {
            return (T)((RealFieldElement)zero.add(5.5406E34));
        }
        if (power.getReal() < -80.0) {
            return (T)((RealFieldElement)zero.add(1.8049E-35));
        }
        return (T)FastMath.exp(power);
    }

    private T interpolate(T z1, T z2, T z3, T z4, T x) {
        if (FastMath.abs((double)(2.0 * x.getReal())) < 1.0E-10) {
            return z2;
        }
        RealFieldElement delta = (RealFieldElement)((RealFieldElement)x.multiply(2.0)).subtract(1.0);
        RealFieldElement g1 = (RealFieldElement)z3.add(z2);
        RealFieldElement g2 = (RealFieldElement)z3.subtract(z2);
        RealFieldElement g3 = (RealFieldElement)z4.add(z1);
        RealFieldElement g4 = (RealFieldElement)((RealFieldElement)z4.subtract(z1)).divide(3.0);
        RealFieldElement a0 = (RealFieldElement)((RealFieldElement)g1.multiply(9.0)).subtract((Object)g3);
        RealFieldElement a1 = (RealFieldElement)((RealFieldElement)g2.multiply(9.0)).subtract((Object)g4);
        RealFieldElement a2 = (RealFieldElement)g3.subtract((Object)g1);
        RealFieldElement a3 = (RealFieldElement)g4.subtract((Object)g2);
        RealFieldElement zx = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)delta.multiply((Object)a3)).add((Object)a2)).multiply((Object)delta)).add((Object)a1)).multiply((Object)delta)).add((Object)a0)).multiply(0.0625);
        return (T)zx;
    }

    private T join(T dF1, T dF2, T dA, T dX) {
        RealFieldElement ee = this.clipExp((RealFieldElement)dA.multiply(dX));
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)dF1.multiply((Object)ee)).add(dF2)).divide(ee.add(1.0)));
    }

    private T epst(T x, T y, T z, T w) {
        RealFieldElement ex = this.clipExp((RealFieldElement)((RealFieldElement)w.subtract(y)).divide(z));
        RealFieldElement opex = (RealFieldElement)ex.add(1.0);
        RealFieldElement epst = (RealFieldElement)((RealFieldElement)x.multiply((Object)ex)).divide(opex.multiply((Object)opex));
        return (T)epst;
    }
}

