/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.gnss.attitude.FieldTurnSpan;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

class GNSSFieldAttitudeContext<T extends RealFieldElement<T>>
implements FieldTimeStamped<T> {
    private static final int ORDER = 2;
    private static final PVCoordinates PLUS_Y_PV = new PVCoordinates(Vector3D.PLUS_J, Vector3D.ZERO, Vector3D.ZERO);
    private static final PVCoordinates MINUS_Z_PV = new PVCoordinates(Vector3D.MINUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private static final double BETA_SIGN_CHANGE_PROTECTION = FastMath.toRadians((double)0.07);
    private final FDSFactory<T> factory;
    private final FieldPVCoordinates<T> plusY;
    private final FieldPVCoordinates<T> minusZ;
    private final AbsoluteDate dateDouble;
    private final FieldAbsoluteDate<T> date;
    private final FieldAbsoluteDate<FieldDerivativeStructure<T>> dateDS;
    private final ExtendedPVCoordinatesProvider sun;
    private final FieldPVCoordinatesProvider<T> pvProv;
    private final Frame inertialFrame;
    private final FieldDerivativeStructure<T> svbCos;
    private final boolean morning;
    private final FieldDerivativeStructure<T> delta;
    private T muRate;
    private double cNight;
    private double cNoon;
    private FieldTurnSpan<T> turnSpan;

    GNSSFieldAttitudeContext(FieldAbsoluteDate<T> date, ExtendedPVCoordinatesProvider sun, FieldPVCoordinatesProvider<T> pvProv, Frame inertialFrame, FieldTurnSpan<T> turnSpan) {
        Field<T> field = date.getField();
        this.factory = new FDSFactory(field, 1, 2);
        this.plusY = new FieldPVCoordinates<Field<T>>(field, PLUS_Y_PV);
        this.minusZ = new FieldPVCoordinates<Field<T>>(field, MINUS_Z_PV);
        this.dateDouble = date.toAbsoluteDate();
        this.date = date;
        this.dateDS = this.addDerivatives(date);
        this.sun = sun;
        this.pvProv = pvProv;
        this.inertialFrame = inertialFrame;
        TimeStampedFieldPVCoordinates<FieldDerivativeStructure<T>> sunPVDS = sun.getPVCoordinates(this.dateDS, inertialFrame);
        TimeStampedFieldPVCoordinates<T> svPV = pvProv.getPVCoordinates(date, inertialFrame);
        FieldPVCoordinates svPVDS = svPV.toDerivativeStructurePV(this.factory.getCompiler().getOrder());
        this.svbCos = ((FieldDerivativeStructure)FieldVector3D.dotProduct(sunPVDS.getPosition(), svPVDS.getPosition())).divide(((FieldDerivativeStructure)sunPVDS.getPosition().getNorm()).multiply((FieldDerivativeStructure)svPVDS.getPosition().getNorm()));
        this.morning = Vector3D.dotProduct((Vector3D)svPV.getVelocity().toVector3D(), (Vector3D)sunPVDS.getPosition().toVector3D()) >= 0.0;
        this.muRate = svPV.getAngularVelocity().getNorm();
        this.turnSpan = turnSpan;
        FieldDerivativeStructure absDelta = this.svbCos.getValue().getReal() <= 0.0 ? this.inOrbitPlaneAbsoluteAngle((T)this.svbCos.acos().negate().add(Math.PI)) : this.inOrbitPlaneAbsoluteAngle((T)this.svbCos.acos());
        this.delta = absDelta.copySign((RealFieldElement)absDelta.getPartialDerivative(new int[]{1}).negate());
    }

    private FieldAbsoluteDate<T> removeDerivatives(FieldAbsoluteDate<FieldDerivativeStructure<T>> d) {
        AbsoluteDate dd = d.toAbsoluteDate();
        FieldDerivativeStructure<T> offset = d.durationFrom(dd);
        return new FieldAbsoluteDate<RealFieldElement>(this.date.getField(), dd).shiftedBy(offset.getValue());
    }

    private FieldAbsoluteDate<FieldDerivativeStructure<T>> addDerivatives(FieldAbsoluteDate<T> d) {
        AbsoluteDate dd = d.toAbsoluteDate();
        T offset = d.durationFrom(dd);
        return new FieldAbsoluteDate<FieldDerivativeStructure>(this.factory.getDerivativeField(), dd).shiftedBy(this.factory.variable(0, offset));
    }

    public TimeStampedFieldAngularCoordinates<T> nominalYaw(FieldAbsoluteDate<T> d) {
        TimeStampedFieldPVCoordinates<T> svPV = this.pvProv.getPVCoordinates(d, this.inertialFrame);
        return new TimeStampedFieldAngularCoordinates<T>(d, svPV.normalize(), this.sun.getPVCoordinates(d, this.inertialFrame).crossProduct(svPV).normalize(), this.minusZ, this.plusY, 1.0E-9);
    }

    public T beta(FieldAbsoluteDate<T> d) {
        TimeStampedFieldPVCoordinates<T> svPV = this.pvProv.getPVCoordinates(d, this.inertialFrame);
        return (T)((RealFieldElement)((RealFieldElement)FieldVector3D.angle(this.sun.getPVCoordinates(d, this.inertialFrame).getPosition(), svPV.getMomentum()).negate()).add(1.5707963267948966));
    }

    private FieldDerivativeStructure<T> betaDS(FieldAbsoluteDate<FieldDerivativeStructure<T>> d) {
        FieldPVCoordinates svPV = this.pvProv.getPVCoordinates(this.removeDerivatives(d), this.inertialFrame).toDerivativeStructurePV(((FieldDerivativeStructure)d.getField().getZero()).getOrder());
        return ((FieldDerivativeStructure)FieldVector3D.angle(this.sun.getPVCoordinates(d, this.inertialFrame).getPosition(), svPV.getMomentum())).negate().add(1.5707963267948966);
    }

    public FieldDerivativeStructure<T> betaDS() {
        return this.betaDS(this.dateDS);
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.date;
    }

    public FieldTurnSpan<T> getTurnSpan() {
        return this.turnSpan;
    }

    public T getSVBcos() {
        return (T)this.svbCos.getValue();
    }

    public T getSecuredBeta() {
        T beta = this.beta(this.getDate());
        return FastMath.abs((double)beta.getReal()) < BETA_SIGN_CHANGE_PROTECTION ? this.beta(this.turnSpan.getTurnStartDate()) : beta;
    }

    public boolean linearModelStillActive(T linearPhi, T phiDot) {
        double dtMax;
        AbsoluteDate absDate = this.date.toAbsoluteDate();
        double dt0 = this.turnSpan.getTurnEndDate().durationFrom(this.date).getReal();
        UnivariateFunction yawReached = dt -> {
            AbsoluteDate t = absDate.shiftedBy(dt);
            Vector3D pSun = this.sun.getPVCoordinates(t, this.inertialFrame).getPosition();
            PVCoordinates pv = this.pvProv.getPVCoordinates((FieldAbsoluteDate<T>)this.date.shiftedBy(dt), this.inertialFrame).toPVCoordinates();
            Vector3D pSat = pv.getPosition();
            Vector3D targetX = Vector3D.crossProduct((Vector3D)pSat, (Vector3D)Vector3D.crossProduct((Vector3D)pSun, (Vector3D)pSat)).normalize();
            double phi = linearPhi.getReal() + dt * phiDot.getReal();
            SinCos sc = FastMath.sinCos((double)phi);
            Vector3D pU = pv.getPosition().normalize();
            Vector3D mU = pv.getMomentum().normalize();
            Vector3D omega = new Vector3D(-phiDot.getReal(), pU);
            Vector3D currentX = new Vector3D(-sc.sin(), mU, -sc.cos(), Vector3D.crossProduct((Vector3D)pU, (Vector3D)mU));
            Vector3D currentXDot = Vector3D.crossProduct((Vector3D)omega, (Vector3D)currentX);
            return Vector3D.dotProduct((Vector3D)targetX, (Vector3D)currentXDot);
        };
        double fullTurn = Math.PI * 2 / FastMath.abs((double)phiDot.getReal());
        double dtMin = FastMath.min((double)this.turnSpan.getTurnStartDate().durationFrom(this.date).getReal(), (double)(dt0 - 60.0));
        double[] bracket = UnivariateSolverUtils.bracket((UnivariateFunction)yawReached, (double)dt0, (double)dtMin, (double)(dtMax = FastMath.max((double)(dtMin + fullTurn), (double)(dt0 + 60.0))), (double)(fullTurn / 100.0), (double)1.0, (int)100);
        if (yawReached.value(bracket[0]) <= 0.0) {
            bracket = UnivariateSolverUtils.bracket((UnivariateFunction)yawReached, (double)(0.5 * (bracket[0] + bracket[1] + fullTurn)), (double)bracket[1], (double)(bracket[1] + fullTurn), (double)(fullTurn / 100.0), (double)1.0, (int)100);
        }
        double dt2 = new BracketingNthOrderBrentSolver(0.001, 5).solve(100, yawReached, bracket[0], bracket[1]);
        this.turnSpan.updateEnd((FieldAbsoluteDate<T>)this.date.shiftedBy(dt2), absDate);
        return dt2 > 0.0;
    }

    public boolean setUpTurnRegion(double cosNight, double cosNoon) {
        this.cNight = cosNight;
        this.cNoon = cosNoon;
        if (this.svbCos.getValue().getReal() < this.cNight || this.svbCos.getValue().getReal() > this.cNoon) {
            return true;
        }
        return this.inTurnTimeRange();
    }

    public FieldDerivativeStructure<T> getDeltaDS() {
        return this.delta;
    }

    public T getOrbitAngleSinceMidnight() {
        RealFieldElement absAngle = this.inOrbitPlaneAbsoluteAngle((RealFieldElement)((RealFieldElement)FastMath.acos((RealFieldElement)this.svbCos.getValue()).negate()).add(Math.PI));
        return (T)(this.morning ? absAngle : (RealFieldElement)absAngle.negate());
    }

    public boolean inSunSide() {
        return this.svbCos.getValue().getReal() > 0.0;
    }

    public T getYawStart(T sunBeta) {
        RealFieldElement halfSpan = (RealFieldElement)((RealFieldElement)this.turnSpan.getTurnDuration().multiply(this.muRate)).multiply(0.5);
        return (T)this.computePhi(sunBeta, FastMath.copySign((RealFieldElement)halfSpan, (RealFieldElement)this.svbCos.getValue()));
    }

    public T getYawEnd(T sunBeta) {
        RealFieldElement halfSpan = (RealFieldElement)((RealFieldElement)this.turnSpan.getTurnDuration().multiply(this.muRate)).multiply(0.5);
        return (T)this.computePhi(sunBeta, FastMath.copySign((RealFieldElement)halfSpan, (RealFieldElement)((RealFieldElement)this.svbCos.getValue().negate())));
    }

    public T yawRate(T sunBeta) {
        return (T)((RealFieldElement)((RealFieldElement)this.getYawEnd(sunBeta).subtract(this.getYawStart(sunBeta))).divide(this.turnSpan.getTurnDuration()));
    }

    public T getMuRate() {
        return this.muRate;
    }

    private FieldDerivativeStructure<T> inOrbitPlaneAbsoluteAngle(FieldDerivativeStructure<T> angle) {
        return (FieldDerivativeStructure)FastMath.acos((RealFieldElement)((FieldDerivativeStructure)FastMath.cos(angle)).divide(FastMath.cos(this.beta(this.getDate()))));
    }

    public T inOrbitPlaneAbsoluteAngle(T angle) {
        return (T)FastMath.acos((RealFieldElement)((RealFieldElement)FastMath.cos(angle).divide((Object)FastMath.cos(this.beta(this.getDate())))));
    }

    public T computePhi(T sunBeta, T inOrbitPlaneAngle) {
        return (T)FastMath.atan2((RealFieldElement)((RealFieldElement)FastMath.tan(sunBeta).negate()), (RealFieldElement)FastMath.sin(inOrbitPlaneAngle));
    }

    public void setHalfSpan(T halfSpan, double endMargin) {
        FieldAbsoluteDate<RealFieldElement> start = this.date.shiftedBy((RealFieldElement)((RealFieldElement)this.delta.getValue().subtract(halfSpan)).divide(this.muRate));
        FieldAbsoluteDate<RealFieldElement> end = this.date.shiftedBy((RealFieldElement)((RealFieldElement)this.delta.getValue().add(halfSpan)).divide(this.muRate));
        AbsoluteDate estimationDate = this.getDate().toAbsoluteDate();
        if (this.turnSpan == null) {
            this.turnSpan = new FieldTurnSpan<RealFieldElement>(start, end, estimationDate, endMargin);
        } else {
            this.turnSpan.updateStart(start, estimationDate);
            this.turnSpan.updateEnd(end, estimationDate);
        }
    }

    public boolean inTurnTimeRange() {
        return this.turnSpan != null && this.turnSpan.inTurnTimeRange(this.dateDouble);
    }

    public T timeSinceTurnStart() {
        return this.getDate().durationFrom(this.turnSpan.getTurnStartDate());
    }

    public TimeStampedFieldAngularCoordinates<T> turnCorrectedAttitude(T yaw, T yawDot) {
        return this.turnCorrectedAttitude(this.factory.build(new RealFieldElement[]{yaw, yawDot, (RealFieldElement)yaw.getField().getZero()}));
    }

    public TimeStampedFieldAngularCoordinates<T> turnCorrectedAttitude(FieldDerivativeStructure<T> yaw) {
        TimeStampedFieldPVCoordinates svPV = this.pvProv.getPVCoordinates(this.date, this.inertialFrame);
        FieldVector3D p = svPV.getPosition();
        FieldVector3D v = svPV.getVelocity();
        FieldVector3D a = svPV.getAcceleration();
        RealFieldElement r2 = p.getNormSq();
        RealFieldElement r = FastMath.sqrt((RealFieldElement)r2);
        FieldVector3D keplerianJerk = new FieldVector3D((RealFieldElement)((RealFieldElement)FieldVector3D.dotProduct(p, v).multiply(-3)).divide((Object)r2), a, (RealFieldElement)((RealFieldElement)a.getNorm().negate()).divide((Object)r), v);
        FieldPVCoordinates velocity = new FieldPVCoordinates(v, a, keplerianJerk);
        FieldPVCoordinates momentum = svPV.crossProduct(velocity);
        FieldSinCos sc = FastMath.sinCos(yaw);
        FieldDerivativeStructure c = ((FieldDerivativeStructure)sc.cos()).negate();
        FieldDerivativeStructure s = ((FieldDerivativeStructure)sc.sin()).negate();
        RealFieldElement z = (RealFieldElement)yaw.getFactory().getValueField().getZero();
        FieldVector3D m0 = new FieldVector3D(s.getValue(), c.getValue(), z);
        FieldVector3D m1 = new FieldVector3D(s.getPartialDerivative(new int[]{1}), c.getPartialDerivative(new int[]{1}), z);
        FieldVector3D m2 = new FieldVector3D(s.getPartialDerivative(new int[]{2}), c.getPartialDerivative(new int[]{2}), z);
        return new TimeStampedFieldAngularCoordinates<T>(this.date, svPV.normalize(), momentum.normalize(), this.minusZ, new FieldPVCoordinates(m0, m1, m2), 1.0E-9);
    }

    public TimeStampedFieldAngularCoordinates<T> orbitNormalYaw() {
        FieldTransform<T> t = LOFType.VVLH.transformFromInertial(this.date, this.pvProv.getPVCoordinates(this.date, this.inertialFrame));
        return new TimeStampedFieldAngularCoordinates<T>(this.date, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }
}

