/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.maneuvers.propulsion.ThrustPropulsionModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;

public abstract class AbstractConstantThrustPropulsionModel
implements ThrustPropulsionModel {
    private final Vector3D initialThrustVector;
    private final double initialFlowRate;
    private final String name;

    public AbstractConstantThrustPropulsionModel(double thrust, double isp, Vector3D direction, String name) {
        this.name = name;
        this.initialThrustVector = direction.normalize().scalarMultiply(thrust);
        this.initialFlowRate = -thrust / (9.80665 * isp);
    }

    protected Vector3D getInitialThrustVector() {
        return this.initialThrustVector;
    }

    protected double getInitialFlowrate() {
        return this.initialFlowRate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public double getIsp() {
        double thrust = this.getThrust();
        double flowRate = this.getFlowRate();
        return -thrust / (9.80665 * flowRate);
    }

    public Vector3D getDirection() {
        return this.getThrustVector().normalize();
    }

    public double getThrust() {
        return this.getThrustVector().getNorm();
    }

    @Override
    public Vector3D getThrustVector(SpacecraftState s) {
        return this.getThrustVector();
    }

    @Override
    public double getFlowRate(SpacecraftState s) {
        return this.getFlowRate();
    }

    @Override
    public Vector3D getThrustVector(SpacecraftState s, double[] parameters) {
        return this.getThrustVector(parameters);
    }

    @Override
    public double getFlowRate(SpacecraftState s, double[] parameters) {
        return this.getFlowRate(parameters);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> getThrustVector(FieldSpacecraftState<T> s, T[] parameters) {
        return this.getThrustVector((RealFieldElement[])parameters);
    }

    @Override
    public <T extends RealFieldElement<T>> T getFlowRate(FieldSpacecraftState<T> s, T[] parameters) {
        return (T)this.getFlowRate((RealFieldElement[])parameters);
    }

    public abstract Vector3D getThrustVector();

    public abstract double getFlowRate();

    public abstract Vector3D getThrustVector(double[] var1);

    public abstract double getFlowRate(double[] var1);

    public abstract <T extends RealFieldElement<T>> FieldVector3D<T> getThrustVector(T[] var1);

    public abstract <T extends RealFieldElement<T>> T getFlowRate(T[] var1);
}

