/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.forces.AbstractForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.utils.ParameterDriver;

public class SingleBodyAbsoluteAttraction
extends AbstractForceModel {
    public static final String ATTRACTION_COEFFICIENT_SUFFIX = " attraction coefficient";
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final CelestialBody body;
    private final ParameterDriver gmParameterDriver;

    public SingleBodyAbsoluteAttraction(CelestialBody body) {
        this.gmParameterDriver = new ParameterDriver(body.getName() + ATTRACTION_COEFFICIENT_SUFFIX, body.getGM(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.body = body;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return true;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        Vector3D bodyPosition = this.body.getPVCoordinates(s.getDate(), s.getFrame()).getPosition();
        Vector3D satToBody = bodyPosition.subtract((Vector)s.getPVCoordinates().getPosition());
        double r2Sat = satToBody.getNormSq();
        return new Vector3D(parameters[0] / (r2Sat * FastMath.sqrt((double)r2Sat)), satToBody);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldVector3D centralToBody = new FieldVector3D(s.getA().getField(), this.body.getPVCoordinates(s.getDate().toAbsoluteDate(), s.getFrame()).getPosition());
        FieldVector3D satToBody = centralToBody.subtract(s.getPVCoordinates().getPosition());
        RealFieldElement r2Sat = satToBody.getNormSq();
        return new FieldVector3D((RealFieldElement)parameters[0].divide(r2Sat.multiply(r2Sat.sqrt())), satToBody);
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.gmParameterDriver};
    }
}

