/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.AbstractForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Relativity
extends AbstractForceModel {
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final ParameterDriver gmParameterDriver;

    public Relativity(double gm) {
        this.gmParameterDriver = new ParameterDriver("central attraction coefficient", gm, MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        double gm = parameters[0];
        TimeStampedPVCoordinates pv = s.getPVCoordinates();
        Vector3D p = pv.getPosition();
        Vector3D v = pv.getVelocity();
        double r2 = p.getNormSq();
        double r = FastMath.sqrt((double)r2);
        double s2 = v.getNormSq();
        double c2 = 8.987551787368176E16;
        return new Vector3D(4.0 * gm / r - s2, p, 4.0 * p.dotProduct((Vector)v), v).scalarMultiply(gm / (r2 * r * 8.987551787368176E16));
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        T gm = parameters[0];
        TimeStampedFieldPVCoordinates<T> pv = s.getPVCoordinates();
        FieldVector3D p = pv.getPosition();
        FieldVector3D v = pv.getVelocity();
        RealFieldElement r2 = p.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement s2 = v.getNormSq();
        double c2 = 8.987551787368176E16;
        return new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)r.reciprocal()).multiply(4)).multiply(gm)).subtract((Object)s2), p, (RealFieldElement)p.dotProduct(v).multiply(4), v).scalarMultiply((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)r2.multiply((Object)r)).multiply(8.987551787368176E16)).reciprocal()).multiply(gm));
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.gmParameterDriver};
    }
}

