/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.LOFType;
import org.orekit.utils.IERSConventions;

public enum CCSDSFrame {
    EME2000(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getFrames().getEME2000();
        }
    }
    ,
    GCRF(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getFrames().getGCRF();
        }
    }
    ,
    GRC(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRFEquinox(conventions, simpleEOP);
        }
    }
    ,
    ICRF(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getFrames().getICRF();
        }
    }
    ,
    ITRF2014(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_2014, conventions, simpleEOP);
        }
    }
    ,
    ITRF2008(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_2008, conventions, simpleEOP);
        }
    }
    ,
    ITRF2005(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_2005, conventions, simpleEOP);
        }
    }
    ,
    ITRF2000(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_2000, conventions, simpleEOP);
        }
    }
    ,
    ITRF93(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_93, conventions, simpleEOP);
        }
    }
    ,
    ITRF97(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_97, conventions, simpleEOP);
        }
    }
    ,
    MCI(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getCelestialBodies().getMars().getInertiallyOrientedFrame();
        }
    }
    ,
    TDR(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getGTOD(conventions, simpleEOP);
        }
    }
    ,
    TEME(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getFrames().getTEME();
        }
    }
    ,
    TOD(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getTOD(conventions, simpleEOP);
        }
    }
    ,
    RTN(LOFType.QSW),
    RSW(LOFType.QSW),
    TNW(LOFType.TNW);

    private final LOFType lofType;

    private CCSDSFrame(LOFType lofType) {
        this.lofType = lofType;
    }

    public boolean isLof() {
        return this.lofType != null;
    }

    public LOFType getLofType() {
        return this.lofType;
    }

    @DefaultDataContext
    public Frame getFrame(IERSConventions conventions, boolean simpleEOP) {
        return this.getFrame(conventions, simpleEOP, DataContext.getDefault());
    }

    public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, this.toString());
    }
}

