/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.complex.Quaternion;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.ccsds.ADMFile;
import org.orekit.files.ccsds.ADMMetaData;
import org.orekit.time.AbsoluteDate;

public class APMFile
extends ADMFile {
    private final ADMMetaData metaData = new ADMMetaData(this);
    private AbsoluteDate epoch;
    private String qFrameA;
    private String qFrameB;
    private String qDir;
    private Quaternion quaternion;
    private Quaternion quaternionDot;
    private String eulerFrameA;
    private String eulerFrameB;
    private String eulerDir;
    private String eulerRotSeq;
    private String rateFrame;
    private Vector3D rotationAngles;
    private Vector3D rotationRates;
    private String spinFrameA;
    private String spinFrameB;
    private String spinDir;
    private double spinAlpha;
    private double spinDelta;
    private double spinAngle;
    private double spinAngleVel;
    private double nutation;
    private double nutationPer;
    private double nutationPhase;
    private String inertiaRefFrame;
    private double i11;
    private double i22;
    private double i33;
    private double i12;
    private double i13;
    private double i23;
    private List<String> epochComment = Collections.emptyList();
    private List<String> eulerComment = Collections.emptyList();
    private List<String> spinComment = Collections.emptyList();
    private List<String> spacecraftComment = Collections.emptyList();
    private List<APMManeuver> maneuvers = new ArrayList<APMManeuver>();

    public APMFile() {
        this.rotationAngles = Vector3D.ZERO;
        this.rotationRates = Vector3D.ZERO;
        this.quaternion = new Quaternion(0.0, 0.0, 0.0, 0.0);
        this.quaternionDot = new Quaternion(0.0, 0.0, 0.0, 0.0);
    }

    public ADMMetaData getMetaData() {
        return this.metaData;
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public void setEpoch(AbsoluteDate epoch) {
        this.epoch = epoch;
    }

    public String getQuaternionFrameAString() {
        return this.qFrameA;
    }

    public void setQuaternionFrameAString(String frameA) {
        this.qFrameA = frameA;
    }

    public String getQuaternionFrameBString() {
        return this.qFrameB;
    }

    public void setQuaternionFrameBString(String frameB) {
        this.qFrameB = frameB;
    }

    public String getAttitudeQuaternionDirection() {
        return this.qDir;
    }

    public void setAttitudeQuaternionDirection(String direction) {
        this.qDir = direction;
    }

    public Quaternion getQuaternion() {
        return this.quaternion;
    }

    public void setQuaternion(Quaternion q) {
        this.quaternion = q;
    }

    public Quaternion getQuaternionDot() {
        return this.quaternionDot;
    }

    public void setQuaternionDot(Quaternion qDot) {
        this.quaternionDot = qDot;
    }

    public String getEulerFrameAString() {
        return this.eulerFrameA;
    }

    public void setEulerFrameAString(String frame) {
        this.eulerFrameA = frame;
    }

    public String getEulerFrameBString() {
        return this.eulerFrameB;
    }

    public void setEulerFrameBString(String frame) {
        this.eulerFrameB = frame;
    }

    public String getEulerDirection() {
        return this.eulerDir;
    }

    public void setEulerDirection(String direction) {
        this.eulerDir = direction;
    }

    public String getEulerRotSeq() {
        return this.eulerRotSeq;
    }

    public void setEulerRotSeq(String eulerRotSeq) {
        this.eulerRotSeq = eulerRotSeq;
    }

    public String getRateFrameString() {
        return this.rateFrame;
    }

    public void setRateFrameString(String frame) {
        this.rateFrame = frame;
    }

    public Vector3D getRotationAngles() {
        return this.rotationAngles;
    }

    public void setRotationAngles(Vector3D rotationAngles) {
        this.rotationAngles = rotationAngles;
    }

    public Vector3D getRotationRates() {
        return this.rotationRates;
    }

    public void setRotationRates(Vector3D rotationRates) {
        this.rotationRates = rotationRates;
    }

    public String getSpinFrameAString() {
        return this.spinFrameA;
    }

    public void setSpinFrameAString(String frame) {
        this.spinFrameA = frame;
    }

    public String getSpinFrameBString() {
        return this.spinFrameB;
    }

    public void setSpinFrameBString(String frame) {
        this.spinFrameB = frame;
    }

    public String getSpinDirection() {
        return this.spinDir;
    }

    public void setSpinDirection(String direction) {
        this.spinDir = direction;
    }

    public double getSpinAlpha() {
        return this.spinAlpha;
    }

    public void setSpinAlpha(double spinAlpha) {
        this.spinAlpha = spinAlpha;
    }

    public double getSpinDelta() {
        return this.spinDelta;
    }

    public void setSpinDelta(double spinDelta) {
        this.spinDelta = spinDelta;
    }

    public double getSpinAngle() {
        return this.spinAngle;
    }

    public void setSpinAngle(double spinAngle) {
        this.spinAngle = spinAngle;
    }

    public double getSpinAngleVel() {
        return this.spinAngleVel;
    }

    public void setSpinAngleVel(double spinAngleVel) {
        this.spinAngleVel = spinAngleVel;
    }

    public double getNutation() {
        return this.nutation;
    }

    public void setNutation(double nutation) {
        this.nutation = nutation;
    }

    public double getNutationPeriod() {
        return this.nutationPer;
    }

    public void setNutationPeriod(double period) {
        this.nutationPer = period;
    }

    public double getNutationPhase() {
        return this.nutationPhase;
    }

    public void setNutationPhase(double nutationPhase) {
        this.nutationPhase = nutationPhase;
    }

    public String getInertiaRefFrameString() {
        return this.inertiaRefFrame;
    }

    public void setInertiaRefFrameString(String frame) {
        this.inertiaRefFrame = frame;
    }

    public double getI11() {
        return this.i11;
    }

    public void setI11(double i11) {
        this.i11 = i11;
    }

    public double getI22() {
        return this.i22;
    }

    public void setI22(double i22) {
        this.i22 = i22;
    }

    public double getI33() {
        return this.i33;
    }

    public void setI33(double i33) {
        this.i33 = i33;
    }

    public double getI12() {
        return this.i12;
    }

    public void setI12(double i12) {
        this.i12 = i12;
    }

    public double getI13() {
        return this.i13;
    }

    public void setI13(double i13) {
        this.i13 = i13;
    }

    public double getI23() {
        return this.i23;
    }

    public void setI23(double i23) {
        this.i23 = i23;
    }

    public List<String> getEpochComment() {
        return Collections.unmodifiableList(this.epochComment);
    }

    public void setEpochComment(List<String> comment) {
        this.epochComment = new ArrayList<String>(comment);
    }

    public List<String> getEulerComment() {
        return Collections.unmodifiableList(this.eulerComment);
    }

    public void setEulerComment(List<String> comment) {
        this.eulerComment = new ArrayList<String>(comment);
    }

    public List<String> getSpinComment() {
        return Collections.unmodifiableList(this.spinComment);
    }

    public void setSpinComment(List<String> comment) {
        this.spinComment = new ArrayList<String>(comment);
    }

    public List<String> getSpacecraftComment() {
        return Collections.unmodifiableList(this.spacecraftComment);
    }

    public void setSpacecraftComment(List<String> comment) {
        this.spacecraftComment = new ArrayList<String>(comment);
    }

    public int getNbManeuvers() {
        return this.maneuvers.size();
    }

    public List<APMManeuver> getManeuvers() {
        return Collections.unmodifiableList(this.maneuvers);
    }

    public APMManeuver getManeuver(int index) {
        return this.maneuvers.get(index);
    }

    public void addManeuver(APMManeuver maneuver) {
        this.maneuvers.add(maneuver);
    }

    public boolean getHasManeuver() {
        return !this.maneuvers.isEmpty();
    }

    public List<String> getMetaDataComment() {
        return this.metaData.getComment();
    }

    public static class APMManeuver {
        private AbsoluteDate epochStart;
        private String refFrame;
        private double duration;
        private Vector3D torque = Vector3D.ZERO;
        private List<String> comment = Collections.emptyList();

        public AbsoluteDate getEpochStart() {
            return this.epochStart;
        }

        public void setEpochStart(AbsoluteDate epochStart) {
            this.epochStart = epochStart;
        }

        public String getRefFrameString() {
            return this.refFrame;
        }

        public void setRefFrameString(String frame) {
            this.refFrame = frame;
        }

        public double getDuration() {
            return this.duration;
        }

        public void setDuration(double duration) {
            this.duration = duration;
        }

        public Vector3D getTorque() {
            return this.torque;
        }

        public void setTorque(Vector3D vector) {
            this.torque = vector;
        }

        public List<String> getComment() {
            return Collections.unmodifiableList(this.comment);
        }

        public void setComment(List<String> comment) {
            this.comment = new ArrayList<String>(comment);
        }
    }
}

