/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ADMParser;
import org.orekit.files.ccsds.AEMAttitudeType;
import org.orekit.files.ccsds.AEMFile;
import org.orekit.files.ccsds.CCSDSFrame;
import org.orekit.files.ccsds.KeyValue;
import org.orekit.files.general.AttitudeEphemerisFileParser;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class AEMParser
extends ADMParser
implements AttitudeEphemerisFileParser {
    private static final Pattern DASH = Pattern.compile("-");
    private static final int MAX_SIZE = 8;
    private int interpolationDegree;
    private Frame localScBodyReferenceFrameA;
    private Frame localScBodyReferenceFrameB;

    @DefaultDataContext
    public AEMParser() {
        this(DataContext.getDefault());
    }

    public AEMParser(DataContext dataContext) {
        this(AbsoluteDate.FUTURE_INFINITY, Double.NaN, null, true, 0, 0, "", 1, dataContext);
    }

    private AEMParser(AbsoluteDate missionReferenceDate, double mu, IERSConventions conventions, boolean simpleEOP, int launchYear, int launchNumber, String launchPiece, int interpolationDegree, DataContext dataContext) {
        super(missionReferenceDate, mu, conventions, simpleEOP, launchYear, launchNumber, launchPiece, dataContext);
        this.interpolationDegree = interpolationDegree;
    }

    @Override
    public AEMParser withMissionReferenceDate(AbsoluteDate newMissionReferenceDate) {
        return new AEMParser(newMissionReferenceDate, this.getMu(), this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getInterpolationDegree(), this.getDataContext());
    }

    @Override
    public AEMParser withMu(double newMu) {
        return new AEMParser(this.getMissionReferenceDate(), newMu, this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getInterpolationDegree(), this.getDataContext());
    }

    @Override
    public AEMParser withConventions(IERSConventions newConventions) {
        return new AEMParser(this.getMissionReferenceDate(), this.getMu(), newConventions, this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getInterpolationDegree(), this.getDataContext());
    }

    @Override
    public AEMParser withSimpleEOP(boolean newSimpleEOP) {
        return new AEMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), newSimpleEOP, this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getInterpolationDegree(), this.getDataContext());
    }

    @Override
    public AEMParser withInternationalDesignator(int newLaunchYear, int newLaunchNumber, String newLaunchPiece) {
        return new AEMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), this.isSimpleEOP(), newLaunchYear, newLaunchNumber, newLaunchPiece, this.getInterpolationDegree(), this.getDataContext());
    }

    @Override
    public AEMParser withDataContext(DataContext dataContext) {
        return new AEMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getInterpolationDegree(), dataContext);
    }

    public AEMParser withInterpolationDegree(int newInterpolationDegree) {
        return new AEMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), newInterpolationDegree, this.getDataContext());
    }

    public void setLocalScBodyReferenceFrameA(Frame frame) {
        this.localScBodyReferenceFrameA = frame;
    }

    public void setLocalScBodyReferenceFrameB(Frame frame) {
        this.localScBodyReferenceFrameB = frame;
    }

    public int getInterpolationDegree() {
        return this.interpolationDegree;
    }

    @Override
    public AEMFile parse(String fileName) {
        return (AEMFile)super.parse(fileName);
    }

    @Override
    public AEMFile parse(InputStream stream) {
        return (AEMFile)super.parse(stream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AEMFile parse(InputStream stream, String fileName) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            AEMFile aEMFile = this.parse(reader, fileName);
            return aEMFile;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    @Override
    public AEMFile parse(BufferedReader reader, String fileName) {
        try {
            ParseInfo pi = new ParseInfo();
            pi.fileName = fileName;
            AEMFile file = pi.file;
            pi.file.setMissionReferenceDate(this.getMissionReferenceDate());
            pi.file.setMu(this.getMu());
            pi.file.setConventions(this.getConventions());
            pi.file.setDataContext(this.getDataContext());
            String line = reader.readLine();
            while (line != null) {
                ++pi.lineNumber;
                if (line.trim().length() != 0) {
                    pi.keyValue = new KeyValue(line, pi.lineNumber, pi.fileName);
                    if (pi.keyValue.getKeyword() == null) {
                        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                    }
                    switch (pi.keyValue.getKeyword()) {
                        case CCSDS_AEM_VERS: {
                            file.setFormatVersion(pi.keyValue.getDoubleValue());
                            break;
                        }
                        case META_START: {
                            file.addAttitudeBlock();
                            pi.lastEphemeridesBlock = file.getAttitudeBlocks().get(file.getAttitudeBlocks().size() - 1);
                            pi.lastEphemeridesBlock.getMetaData().setLaunchYear(this.getLaunchYear());
                            pi.lastEphemeridesBlock.getMetaData().setLaunchNumber(this.getLaunchNumber());
                            pi.lastEphemeridesBlock.getMetaData().setLaunchPiece(this.getLaunchPiece());
                            pi.lastEphemeridesBlock.setInterpolationDegree(this.getInterpolationDegree());
                            break;
                        }
                        case REF_FRAME_A: {
                            pi.lastEphemeridesBlock.setRefFrameAString(pi.keyValue.getValue());
                            break;
                        }
                        case REF_FRAME_B: {
                            pi.lastEphemeridesBlock.setRefFrameBString(pi.keyValue.getValue());
                            break;
                        }
                        case ATTITUDE_DIR: {
                            pi.lastEphemeridesBlock.setAttitudeDirection(pi.keyValue.getValue());
                            break;
                        }
                        case START_TIME: {
                            pi.lastEphemeridesBlock.setStartTime(this.parseDate(pi.keyValue.getValue(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem()));
                            break;
                        }
                        case USEABLE_START_TIME: {
                            pi.lastEphemeridesBlock.setUseableStartTime(this.parseDate(pi.keyValue.getValue(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem()));
                            break;
                        }
                        case USEABLE_STOP_TIME: {
                            pi.lastEphemeridesBlock.setUseableStopTime(this.parseDate(pi.keyValue.getValue(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem()));
                            break;
                        }
                        case STOP_TIME: {
                            pi.lastEphemeridesBlock.setStopTime(this.parseDate(pi.keyValue.getValue(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem()));
                            break;
                        }
                        case ATTITUDE_TYPE: {
                            pi.lastEphemeridesBlock.setAttitudeType(pi.keyValue.getValue());
                            break;
                        }
                        case QUATERNION_TYPE: {
                            boolean isFirst = pi.keyValue.getValue().equals("FIRST");
                            pi.lastEphemeridesBlock.setIsFirst(isFirst);
                            break;
                        }
                        case EULER_ROT_SEQ: {
                            pi.lastEphemeridesBlock.setEulerRotSeq(pi.keyValue.getValue());
                            pi.lastEphemeridesBlock.setRotationOrder(AEMRotationOrder.getRotationOrder(pi.keyValue.getValue()));
                            break;
                        }
                        case RATE_FRAME: {
                            pi.lastEphemeridesBlock.setRateFrameString(pi.keyValue.getValue());
                            break;
                        }
                        case INTERPOLATION_METHOD: {
                            pi.lastEphemeridesBlock.setInterpolationMethod(pi.keyValue.getValue());
                            break;
                        }
                        case INTERPOLATION_DEGREE: {
                            pi.lastEphemeridesBlock.setInterpolationDegree(Integer.parseInt(pi.keyValue.getValue()));
                            break;
                        }
                        case META_STOP: {
                            this.parseReferenceFrame(pi);
                            this.parseEphemeridesDataLines(reader, pi);
                            break;
                        }
                        default: {
                            boolean parsed = false;
                            parsed = parsed || this.parseComment(pi.keyValue, pi.commentTmp);
                            boolean bl = parsed = parsed || this.parseHeaderEntry(pi.keyValue, file, pi.commentTmp);
                            if (pi.lastEphemeridesBlock != null) {
                                boolean bl2 = parsed = parsed || this.parseMetaDataEntry(pi.keyValue, pi.lastEphemeridesBlock.getMetaData(), pi.commentTmp);
                            }
                            if (parsed) break;
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                        }
                    }
                }
                line = reader.readLine();
            }
            file.checkTimeSystems();
            return file;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    private void parseEphemeridesDataLines(BufferedReader reader, ParseInfo pi) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            block23: {
                ++pi.lineNumber;
                if (line.trim().length() > 0) {
                    pi.keyValue = new KeyValue(line, pi.lineNumber, pi.fileName);
                    if (pi.keyValue.getKeyword() == null) {
                        try (Scanner sc = new Scanner(line);){
                            AbsoluteDate date = this.parseDate(sc.next(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem());
                            double[] attitudeData = new double[8];
                            int index = 0;
                            while (sc.hasNext()) {
                                attitudeData[index++] = Double.parseDouble(sc.next());
                            }
                            AEMAttitudeType attType = AEMAttitudeType.getAttitudeType(pi.lastEphemeridesBlock.getAttitudeType());
                            RotationOrder rotationOrder = pi.lastEphemeridesBlock.getRotationOrder();
                            TimeStampedAngularCoordinates epDataLine = attType.getAngularCoordinates(date, attitudeData, pi.lastEphemeridesBlock.isFirst(), rotationOrder);
                            pi.lastEphemeridesBlock.getAttitudeDataLines().add(epDataLine);
                            pi.lastEphemeridesBlock.updateAngularDerivativesFilter(attType.getAngularDerivativesFilter());
                            break block23;
                        }
                        catch (NumberFormatException nfe) {
                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, pi.lineNumber, pi.fileName, line);
                        }
                    }
                    switch (pi.keyValue.getKeyword()) {
                        case DATA_START: {
                            break;
                        }
                        case DATA_STOP: {
                            pi.lastEphemeridesBlock.setAttitudeDataLinesComment(pi.commentTmp);
                            pi.commentTmp.clear();
                            reader.reset();
                            reader.readLine();
                            return;
                        }
                        case COMMENT: {
                            pi.commentTmp.add(pi.keyValue.getValue());
                            break;
                        }
                        default: {
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                        }
                    }
                }
            }
            reader.mark(300);
            line = reader.readLine();
        }
    }

    private void parseReferenceFrame(ParseInfo pi) {
        String frameAString = DASH.matcher(AEMParser.j2000Check(pi.lastEphemeridesBlock.getRefFrameAString())).replaceAll("");
        Frame frameA = AEMParser.isDefinedFrame(frameAString) ? CCSDSFrame.valueOf(frameAString).getFrame(this.getConventions(), this.isSimpleEOP(), this.getDataContext()) : this.localScBodyReferenceFrameA;
        String frameBString = DASH.matcher(AEMParser.j2000Check(pi.lastEphemeridesBlock.getRefFrameBString())).replaceAll("");
        Frame frameB = AEMParser.isDefinedFrame(frameBString) ? CCSDSFrame.valueOf(frameBString).getFrame(this.getConventions(), this.isSimpleEOP(), this.getDataContext()) : this.localScBodyReferenceFrameB;
        String direction = pi.lastEphemeridesBlock.getAttitudeDirection();
        pi.lastEphemeridesBlock.setReferenceFrame("A2B".equals(direction) ? frameA : frameB);
    }

    private static String j2000Check(String frameName) {
        return "J2000".equals(frameName) ? "EME2000" : frameName;
    }

    private static boolean isDefinedFrame(String frameName) {
        for (CCSDSFrame ccsdsFrame : CCSDSFrame.values()) {
            if (!ccsdsFrame.name().equals(frameName)) continue;
            return true;
        }
        return false;
    }

    public static enum AEMRotationOrder {
        XYZ("123", RotationOrder.XYZ),
        XZY("132", RotationOrder.XZY),
        YXZ("213", RotationOrder.YXZ),
        YZX("231", RotationOrder.YZX),
        ZXY("312", RotationOrder.ZXY),
        ZYX("321", RotationOrder.ZYX),
        XYX("121", RotationOrder.XYX),
        XZX("131", RotationOrder.XZX),
        YXY("212", RotationOrder.YXY),
        YZY("232", RotationOrder.YZY),
        ZXZ("313", RotationOrder.ZXZ),
        ZYZ("323", RotationOrder.ZYZ);

        private static final Map<String, RotationOrder> CODES_MAP;
        private final RotationOrder order;
        private final String name;

        private AEMRotationOrder(String name, RotationOrder order) {
            this.name = name;
            this.order = order;
        }

        private String getName() {
            return this.name;
        }

        private RotationOrder getRotationOrder() {
            return this.order;
        }

        public static RotationOrder getRotationOrder(String orderName) {
            RotationOrder type = CODES_MAP.get(orderName);
            if (type == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_INVALID_ROTATION_SEQUENCE, orderName);
            }
            return type;
        }

        static {
            CODES_MAP = new HashMap<String, RotationOrder>();
            for (AEMRotationOrder type : AEMRotationOrder.values()) {
                CODES_MAP.put(type.getName(), type.getRotationOrder());
            }
        }
    }

    private static class ParseInfo {
        private AEMFile.AttitudeEphemeridesBlock lastEphemeridesBlock;
        private String fileName;
        private int lineNumber = 0;
        private AEMFile file = new AEMFile();
        private KeyValue keyValue;
        private List<String> commentTmp = new ArrayList<String>();

        protected ParseInfo() {
        }
    }
}

