/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractGradientConverter;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class TroposphericGradientConverter
extends AbstractGradientConverter {
    private final int freeStateParameters;
    private final List<FieldSpacecraftState<Gradient>> gStates;

    public TroposphericGradientConverter(SpacecraftState state, int freeStateParameters, AttitudeProvider provider) {
        super(freeStateParameters);
        this.freeStateParameters = freeStateParameters;
        GradientField field = GradientField.getField((int)freeStateParameters);
        Vector3D pos = state.getPVCoordinates().getPosition();
        FieldVector3D posG = new FieldVector3D((RealFieldElement)Gradient.variable((int)freeStateParameters, (int)0, (double)pos.getX()), (RealFieldElement)Gradient.variable((int)freeStateParameters, (int)1, (double)pos.getY()), (RealFieldElement)Gradient.variable((int)freeStateParameters, (int)2, (double)pos.getZ()));
        Vector3D vel = state.getPVCoordinates().getVelocity();
        FieldVector3D velG = freeStateParameters > 3 ? new FieldVector3D((RealFieldElement)Gradient.variable((int)freeStateParameters, (int)3, (double)vel.getX()), (RealFieldElement)Gradient.variable((int)freeStateParameters, (int)4, (double)vel.getY()), (RealFieldElement)Gradient.variable((int)freeStateParameters, (int)5, (double)vel.getZ())) : new FieldVector3D((RealFieldElement)Gradient.constant((int)freeStateParameters, (double)vel.getX()), (RealFieldElement)Gradient.constant((int)freeStateParameters, (double)vel.getY()), (RealFieldElement)Gradient.constant((int)freeStateParameters, (double)vel.getZ()));
        Vector3D acc = state.getPVCoordinates().getAcceleration();
        FieldVector3D accG = new FieldVector3D((RealFieldElement)Gradient.constant((int)freeStateParameters, (double)acc.getX()), (RealFieldElement)Gradient.constant((int)freeStateParameters, (double)acc.getY()), (RealFieldElement)Gradient.constant((int)freeStateParameters, (double)acc.getZ()));
        Gradient dsM = Gradient.constant((int)freeStateParameters, (double)state.getMass());
        FieldCartesianOrbit<Gradient> gOrbit = new FieldCartesianOrbit<Gradient>(new TimeStampedFieldPVCoordinates(state.getDate(), posG, velG, accG), state.getFrame(), ((Gradient)field.getZero()).add(state.getMu()));
        FieldAttitude<Object> gAttitude = freeStateParameters > 3 ? provider.getAttitude(gOrbit, gOrbit.getDate(), gOrbit.getFrame()) : new FieldAttitude(field, state.getAttitude());
        this.gStates = new ArrayList<FieldSpacecraftState<Gradient>>();
        this.gStates.add(new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, dsM));
    }

    @Override
    public int getFreeStateParameters() {
        return this.freeStateParameters;
    }

    public FieldSpacecraftState<Gradient> getState(DiscreteTroposphericModel tropoModel) {
        int nbParams = 0;
        for (ParameterDriver driver : tropoModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            ++nbParams;
        }
        while (this.gStates.size() < nbParams + 1) {
            this.gStates.add(null);
        }
        if (this.gStates.get(nbParams) == null) {
            int freeParameters = this.freeStateParameters + nbParams;
            FieldSpacecraftState<Gradient> s0 = this.gStates.get(0);
            TimeStampedFieldPVCoordinates<Gradient> pv0 = s0.getPVCoordinates();
            FieldCartesianOrbit<Gradient> gOrbit = new FieldCartesianOrbit<Gradient>(new TimeStampedFieldPVCoordinates<Gradient>(s0.getDate().toAbsoluteDate(), this.extend(pv0.getPosition(), freeParameters), this.extend(pv0.getVelocity(), freeParameters), this.extend(pv0.getAcceleration(), freeParameters)), s0.getFrame(), this.extend(s0.getMu(), freeParameters));
            TimeStampedFieldAngularCoordinates<Gradient> ac0 = s0.getAttitude().getOrientation();
            FieldAttitude<Gradient> gAttitude = new FieldAttitude<Gradient>(s0.getAttitude().getReferenceFrame(), new TimeStampedFieldAngularCoordinates<Gradient>(gOrbit.getDate(), this.extend(ac0.getRotation(), freeParameters), this.extend(ac0.getRotationRate(), freeParameters), this.extend(ac0.getRotationAcceleration(), freeParameters)));
            Gradient gM = this.extend(s0.getMass(), freeParameters);
            this.gStates.set(nbParams, new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, gM));
        }
        return this.gStates.get(nbParams);
    }

    public Gradient[] getParameters(FieldSpacecraftState<Gradient> state, DiscreteTroposphericModel tropoModel) {
        int freeParameters = state.getMass().getFreeParameters();
        List<ParameterDriver> drivers = tropoModel.getParametersDrivers();
        Gradient[] parameters = new Gradient[drivers.size()];
        int index = this.freeStateParameters;
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = drivers.get(i).isSelected() ? Gradient.variable((int)freeParameters, (int)index++, (double)drivers.get(i).getValue()) : Gradient.constant((int)freeParameters, (double)drivers.get(i).getValue());
        }
        return parameters;
    }
}

