/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.RangeRate;
import org.orekit.estimation.measurements.modifiers.AbstractRelativisticClockModifier;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public class RelativisticClockRangeRateModifier
extends AbstractRelativisticClockModifier
implements EstimationModifier<RangeRate> {
    private final double gm;

    public RelativisticClockRangeRateModifier(double gm) {
        this.gm = gm;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<RangeRate> estimated) {
        SpacecraftState state = estimated.getStates()[0];
        double factor = -this.gm * this.getScaleFactor();
        double dfRel = factor * (RelativisticClockRangeRateModifier.reciprocal(state.getA()) - RelativisticClockRangeRateModifier.reciprocal(state.getPVCoordinates().getPosition().getNorm()));
        double[] newValue = (double[])estimated.getEstimatedValue().clone();
        newValue[0] = newValue[0] + dfRel * 2.99792458E8;
        estimated.setEstimatedValue(newValue);
    }

    private static double reciprocal(double value) {
        return 1.0 / value;
    }
}

