/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.modifiers.OutlierFilter;

public class DynamicOutlierFilter<T extends ObservedMeasurement<T>>
extends OutlierFilter<T> {
    private double[] sigma = null;

    public DynamicOutlierFilter(int warmup, double maxSigma) {
        super(warmup, maxSigma);
    }

    public double[] getSigma() {
        return this.sigma == null ? null : (double[])this.sigma.clone();
    }

    public void setSigma(double[] sigma) {
        this.sigma = sigma == null ? null : (double[])sigma.clone();
    }

    @Override
    public void modify(EstimatedMeasurement<T> estimated) {
        if (estimated.getIteration() > this.getWarmup() && this.sigma != null) {
            double[] observed = estimated.getObservedMeasurement().getObservedValue();
            double[] theoretical = estimated.getEstimatedValue();
            if (observed.length != this.sigma.length) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{this.sigma.length, this.getSigma().length});
            }
            for (int i = 0; i < observed.length; ++i) {
                if (!(FastMath.abs((double)(observed[i] - theoretical[i])) > this.getMaxSigma() * this.sigma[i])) continue;
                estimated.setStatus(EstimatedMeasurement.Status.REJECTED);
            }
        }
    }
}

