/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.SortedSet;
import java.util.TreeSet;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.gnss.IntegerLeastSquareSolution;
import org.orekit.estimation.measurements.gnss.IntegerLeastSquareSolver;

public abstract class AbstractLambdaMethod
implements IntegerLeastSquareSolver {
    private int n;
    private double[] decorrelated;
    private double[] low;
    private double[] diag;
    private int[] zInverseTransformation;
    private int maxSolutions;
    private SortedSet<IntegerLeastSquareSolution> solutions;

    @Override
    public IntegerLeastSquareSolution[] solveILS(int nbSol, double[] floatAmbiguities, int[] indirection, RealMatrix covariance) {
        this.initializeProblem(floatAmbiguities, indirection, covariance, nbSol);
        this.ltdlDecomposition();
        this.reduction();
        this.inverseDecomposition();
        this.discreteSearch();
        return this.recoverAmbiguities();
    }

    private void initializeProblem(double[] floatAmbiguities, int[] indirection, RealMatrix globalCovariance, int nbSol) {
        this.n = floatAmbiguities.length;
        this.decorrelated = (double[])floatAmbiguities.clone();
        this.low = new double[this.n * (this.n - 1) / 2];
        this.diag = new double[this.n];
        this.zInverseTransformation = new int[this.n * this.n];
        this.maxSolutions = nbSol;
        this.solutions = new TreeSet<IntegerLeastSquareSolution>();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < i; ++j) {
                this.low[this.lIndex((int)i, (int)j)] = globalCovariance.getEntry(indirection[i], indirection[j]);
            }
            this.diag[i] = globalCovariance.getEntry(indirection[i], indirection[i]);
            this.zInverseTransformation[this.zIndex((int)i, (int)i)] = 1;
        }
    }

    protected double[] getDiagReference() {
        return this.diag;
    }

    protected double[] getLowReference() {
        return this.low;
    }

    protected double[] getDecorrelatedReference() {
        return this.decorrelated;
    }

    protected int getMaxSolution() {
        return this.maxSolutions;
    }

    protected void addSolution(long[] fixed, double squaredNorm) {
        this.solutions.add(new IntegerLeastSquareSolution(fixed, squaredNorm));
    }

    protected void removeSolution() {
        this.solutions.remove(this.solutions.last());
    }

    protected int getSolutionsSize() {
        return this.solutions.size();
    }

    protected double getMaxDistance() {
        return this.solutions.last().getSquaredDistance();
    }

    protected int[] getZInverseTransformationReference() {
        return this.zInverseTransformation;
    }

    protected int getSize() {
        return this.n;
    }

    protected abstract void ltdlDecomposition();

    protected abstract void reduction();

    protected abstract void discreteSearch();

    protected abstract void inverseDecomposition();

    protected void integerGaussTransformation(int row, int col) {
        int mu = (int)FastMath.rint((double)this.low[this.lIndex(row, col)]);
        if (mu != 0) {
            int i;
            int n = this.lIndex(row, col);
            this.low[n] = this.low[n] - (double)mu;
            for (i = row + 1; i < this.n; ++i) {
                int n2 = this.lIndex(i, col);
                this.low[n2] = this.low[n2] - (double)mu * this.low[this.lIndex(i, row)];
            }
            for (i = 0; i < this.n; ++i) {
                int n3 = this.zIndex(row, i);
                this.zInverseTransformation[n3] = this.zInverseTransformation[n3] + mu * this.zInverseTransformation[this.zIndex(col, i)];
            }
            int n4 = col;
            this.decorrelated[n4] = this.decorrelated[n4] - (double)mu * this.decorrelated[row];
        }
    }

    protected void permutation(int k0, double delta) {
        int i;
        int k1 = k0 + 1;
        int k2 = k0 + 2;
        int indexk1k0 = this.lIndex(k1, k0);
        double lk1k0 = this.low[indexk1k0];
        double eta = this.diag[k0] / delta;
        double lambda = this.diag[k1] * lk1k0 / delta;
        this.diag[k0] = eta * this.diag[k1];
        this.diag[k1] = delta;
        for (int j = 0; j < k0; ++j) {
            int indexk0j = this.lIndex(k0, j);
            int indexk1j = this.lIndex(k1, j);
            double lk0j = this.low[indexk0j];
            double lk1j = this.low[indexk1j];
            this.low[indexk0j] = lk1j - lk1k0 * lk0j;
            this.low[indexk1j] = lambda * lk1j + eta * lk0j;
        }
        this.low[indexk1k0] = lambda;
        for (i = k2; i < this.n; ++i) {
            int indexik0 = this.lIndex(i, k0);
            int indexik1 = indexik0 + 1;
            double tmp = this.low[indexik0];
            this.low[indexik0] = this.low[indexik1];
            this.low[indexik1] = tmp;
        }
        for (i = 0; i < this.n; ++i) {
            int indexk0i = this.zIndex(k0, i);
            int indexk1i = indexk0i + this.n;
            int tmp2 = this.zInverseTransformation[indexk0i];
            this.zInverseTransformation[indexk0i] = this.zInverseTransformation[indexk1i];
            this.zInverseTransformation[indexk1i] = tmp2;
        }
        double tmp = this.decorrelated[k0];
        this.decorrelated[k0] = this.decorrelated[k1];
        this.decorrelated[k1] = tmp;
    }

    protected IntegerLeastSquareSolution[] recoverAmbiguities() {
        IntegerLeastSquareSolution[] recovered = new IntegerLeastSquareSolution[this.solutions.size()];
        int k = 0;
        long[] a = new long[this.n];
        for (IntegerLeastSquareSolution solution : this.solutions) {
            long[] s = solution.getSolution();
            for (int i = 0; i < this.n; ++i) {
                long ai = 0L;
                int l = this.zIndex(0, i);
                for (int j = 0; j < this.n; ++j) {
                    ai += (long)this.zInverseTransformation[l] * s[j];
                    l += this.n;
                }
                a[i] = ai;
            }
            recovered[k++] = new IntegerLeastSquareSolution(a, solution.getSquaredDistance());
        }
        return recovered;
    }

    protected int lIndex(int row, int col) {
        return row * (row - 1) / 2 + col;
    }

    protected int zIndex(int row, int col) {
        return row * this.n + col;
    }
}

