/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Incrementor;
import org.hipparchus.util.Pair;
import org.orekit.estimation.leastsquares.BatchLSODModel;
import org.orekit.estimation.leastsquares.MeasurementHandler;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.leastsquares.PreCompensation;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.PropagatorsParallelizer;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.IntegratedPropagatorBuilder;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.propagation.semianalytical.dsst.DSSTJacobiansMapper;
import org.orekit.propagation.semianalytical.dsst.DSSTPartialDerivativesEquations;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class DSSTBatchLSModel
implements BatchLSODModel {
    private final IntegratedPropagatorBuilder[] builders;
    private final ParameterDriversList[] estimatedPropagationParameters;
    private final ParameterDriversList estimatedMeasurementsParameters;
    private final List<ObservedMeasurement<?>> measurements;
    private final int[] orbitsStartColumns;
    private final int[] orbitsEndColumns;
    private final Map<String, Integer> propagationParameterColumns;
    private final Map<String, Integer> measurementParameterColumns;
    private final Map<ObservedMeasurement<?>, EstimatedMeasurement<?>> evaluations;
    private final ModelObserver observer;
    private Incrementor evaluationsCounter;
    private Incrementor iterationsCounter;
    private AbsoluteDate firstDate;
    private AbsoluteDate lastDate;
    private final boolean forwardPropagation;
    private DSSTJacobiansMapper[] mappers;
    private RealVector value;
    private RealMatrix jacobian;
    private PropagationType propagationType;
    private PropagationType stateType;

    public DSSTBatchLSModel(IntegratedPropagatorBuilder[] propagatorBuilders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer, PropagationType propagationType, PropagationType stateType) {
        this.builders = (IntegratedPropagatorBuilder[])propagatorBuilders.clone();
        this.measurements = measurements;
        this.estimatedMeasurementsParameters = estimatedMeasurementsParameters;
        this.measurementParameterColumns = new HashMap<String, Integer>(estimatedMeasurementsParameters.getDrivers().size());
        this.estimatedPropagationParameters = new ParameterDriversList[this.builders.length];
        this.evaluations = new IdentityHashMap(measurements.size());
        this.observer = observer;
        this.mappers = new DSSTJacobiansMapper[this.builders.length];
        this.propagationType = propagationType;
        this.stateType = stateType;
        int rows = 0;
        for (ObservedMeasurement<?> measurement : measurements) {
            rows += measurement.getDimension();
        }
        this.orbitsStartColumns = new int[this.builders.length];
        this.orbitsEndColumns = new int[this.builders.length];
        int columns = 0;
        for (int i = 0; i < this.builders.length; ++i) {
            this.orbitsStartColumns[i] = columns;
            for (ParameterDriver parameterDriver : this.builders[i].getOrbitalParametersDrivers().getDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                ++columns;
            }
            this.orbitsEndColumns[i] = columns;
        }
        ArrayList<String> estimatedPropagationParametersNames = new ArrayList<String>();
        for (int i = 0; i < this.builders.length; ++i) {
            for (ParameterDriversList.DelegatingDriver delegating : this.getSelectedPropagationDriversForBuilder(i).getDrivers()) {
                String driverName = delegating.getName();
                if (estimatedPropagationParametersNames.contains(driverName)) continue;
                estimatedPropagationParametersNames.add(driverName);
            }
        }
        this.propagationParameterColumns = new HashMap<String, Integer>(estimatedPropagationParametersNames.size());
        for (String string : estimatedPropagationParametersNames) {
            this.propagationParameterColumns.put(string, columns);
            ++columns;
        }
        for (ParameterDriver parameterDriver : estimatedMeasurementsParameters.getDrivers()) {
            this.measurementParameterColumns.put(parameterDriver.getName(), columns);
            ++columns;
        }
        this.value = new ArrayRealVector(rows);
        this.jacobian = MatrixUtils.createRealMatrix((int)rows, (int)columns);
        AbsoluteDate refDate = this.builders[0].getInitialOrbitDate();
        measurements.sort(new ChronologicalComparator());
        this.firstDate = measurements.get(0).getDate();
        this.lastDate = measurements.get(measurements.size() - 1).getDate();
        this.forwardPropagation = FastMath.abs((double)refDate.durationFrom(this.firstDate)) <= FastMath.abs((double)refDate.durationFrom(this.lastDate));
    }

    @Override
    public void setEvaluationsCounter(Incrementor evaluationsCounter) {
        this.evaluationsCounter = evaluationsCounter;
    }

    @Override
    public void setIterationsCounter(Incrementor iterationsCounter) {
        this.iterationsCounter = iterationsCounter;
    }

    @Override
    public boolean isForwardPropagation() {
        return this.forwardPropagation;
    }

    public Pair<RealVector, RealMatrix> value(RealVector point) {
        DSSTPropagator[] propagators = this.createPropagators(point);
        Orbit[] orbits = new Orbit[propagators.length];
        for (int i = 0; i < propagators.length; ++i) {
            this.mappers[i] = this.configureDerivatives(propagators[i]);
            SpacecraftState initial = propagators[i].initialIsOsculating() ? DSSTPropagator.computeMeanState(propagators[i].getInitialState(), propagators[i].getAttitudeProvider(), propagators[i].getAllForceModels()) : propagators[i].getInitialState();
            orbits[i] = initial.getOrbit();
            this.mappers[i].setShortPeriodJacobians(initial);
        }
        PropagatorsParallelizer parallelizer = new PropagatorsParallelizer(Arrays.asList(propagators), this.configureMeasurements(point));
        this.evaluations.clear();
        this.value.set(0.0);
        for (int i = 0; i < this.jacobian.getRowDimension(); ++i) {
            for (int j = 0; j < this.jacobian.getColumnDimension(); ++j) {
                this.jacobian.setEntry(i, j, 0.0);
            }
        }
        if (this.forwardPropagation) {
            parallelizer.propagate(this.firstDate.shiftedBy(-1.0), this.lastDate.shiftedBy(1.0));
        } else {
            parallelizer.propagate(this.lastDate.shiftedBy(1.0), this.firstDate.shiftedBy(-1.0));
        }
        this.observer.modelCalled(orbits, this.evaluations);
        return new Pair((Object)this.value, (Object)this.jacobian);
    }

    @Override
    public int getIterationsCount() {
        return this.iterationsCounter.getCount();
    }

    @Override
    public int getEvaluationsCount() {
        return this.evaluationsCounter.getCount();
    }

    @Override
    public ParameterDriversList getSelectedPropagationDriversForBuilder(int iBuilder) {
        if (this.estimatedPropagationParameters[iBuilder] == null) {
            ParameterDriversList selectedPropagationDrivers = new ParameterDriversList();
            for (ParameterDriversList.DelegatingDriver delegating : this.builders[iBuilder].getPropagationParametersDrivers().getDrivers()) {
                if (!delegating.isSelected()) continue;
                for (ParameterDriver driver : delegating.getRawDrivers()) {
                    selectedPropagationDrivers.add(driver);
                }
            }
            selectedPropagationDrivers.sort();
            this.estimatedPropagationParameters[iBuilder] = selectedPropagationDrivers;
        }
        return this.estimatedPropagationParameters[iBuilder];
    }

    public DSSTPropagator[] createPropagators(RealVector point) {
        DSSTPropagator[] propagators = new DSSTPropagator[this.builders.length];
        for (int i = 0; i < this.builders.length; ++i) {
            int j;
            int nbOrb = this.orbitsEndColumns[i] - this.orbitsStartColumns[i];
            ParameterDriversList selectedPropagationDrivers = this.getSelectedPropagationDriversForBuilder(i);
            int nbParams = selectedPropagationDrivers.getNbParams();
            double[] propagatorArray = new double[nbOrb + nbParams];
            for (j = 0; j < nbOrb; ++j) {
                propagatorArray[j] = point.getEntry(this.orbitsStartColumns[i] + j);
            }
            for (j = 0; j < nbParams; ++j) {
                propagatorArray[nbOrb + j] = point.getEntry(this.propagationParameterColumns.get(selectedPropagationDrivers.getDrivers().get(j).getName()).intValue());
            }
            propagators[i] = (DSSTPropagator)this.builders[i].buildPropagator(propagatorArray);
        }
        return propagators;
    }

    private MultiSatStepHandler configureMeasurements(RealVector point) {
        int index = this.orbitsEndColumns[this.builders.length - 1] + this.propagationParameterColumns.size();
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            parameterDriver.setNormalizedValue(point.getEntry(index++));
        }
        ArrayList<PreCompensation> precompensated = new ArrayList<PreCompensation>();
        for (ObservedMeasurement<?> measurement : this.measurements) {
            if (!measurement.isEnabled()) continue;
            precompensated.add(new PreCompensation(measurement, this.evaluations.get(measurement)));
        }
        precompensated.sort(new ChronologicalComparator());
        this.firstDate = ((PreCompensation)precompensated.get(0)).getDate();
        this.lastDate = ((PreCompensation)precompensated.get(precompensated.size() - 1)).getDate();
        if (!this.forwardPropagation) {
            Collections.reverse(precompensated);
        }
        return new MeasurementHandler(this, precompensated);
    }

    private DSSTJacobiansMapper configureDerivatives(DSSTPropagator propagators) {
        String equationName = DSSTBatchLSModel.class.getName() + "-derivatives";
        DSSTPartialDerivativesEquations partials = new DSSTPartialDerivativesEquations(equationName, propagators, this.propagationType);
        SpacecraftState rawState = propagators.getInitialState();
        SpacecraftState stateWithDerivatives = partials.setInitialJacobians(rawState);
        propagators.setInitialState(stateWithDerivatives, this.stateType);
        return partials.getMapper();
    }

    @Override
    public void fetchEvaluatedMeasurement(int index, EstimatedMeasurement<?> evaluation) {
        SpacecraftState[] evaluationStates = evaluation.getStates();
        Object observedMeasurement = evaluation.getObservedMeasurement();
        this.evaluations.put((ObservedMeasurement<?>)observedMeasurement, evaluation);
        if (evaluation.getStatus() == EstimatedMeasurement.Status.REJECTED) {
            return;
        }
        double[] evaluated = evaluation.getEstimatedValue();
        double[] observed = observedMeasurement.getObservedValue();
        double[] sigma = observedMeasurement.getTheoreticalStandardDeviation();
        double[] weight = evaluation.getObservedMeasurement().getBaseWeight();
        for (int i = 0; i < evaluated.length; ++i) {
            this.value.setEntry(index + i, weight[i] * (evaluated[i] - observed[i]) / sigma[i]);
        }
        for (int k = 0; k < evaluationStates.length; ++k) {
            int p = observedMeasurement.getSatellites().get(k).getPropagatorIndex();
            double[][] aCY = new double[6][6];
            Orbit currentOrbit = evaluationStates[k].getOrbit();
            currentOrbit.getJacobianWrtParameters(this.builders[p].getPositionAngle(), aCY);
            Array2DRowRealMatrix dCdY = new Array2DRowRealMatrix(aCY, false);
            Array2DRowRealMatrix dMdC = new Array2DRowRealMatrix(evaluation.getStateDerivatives(k), false);
            RealMatrix dMdY = dMdC.multiply((RealMatrix)dCdY);
            double[][] aYY0 = new double[6][6];
            this.mappers[p].getStateJacobian(evaluationStates[k], aYY0);
            Array2DRowRealMatrix dYdY0 = new Array2DRowRealMatrix(aYY0, false);
            RealMatrix dMdY0 = dMdY.multiply((RealMatrix)dYdY0);
            for (int i = 0; i < dMdY0.getRowDimension(); ++i) {
                int jOrb = this.orbitsStartColumns[p];
                for (int j = 0; j < dMdY0.getColumnDimension(); ++j) {
                    ParameterDriver driver = this.builders[p].getOrbitalParametersDrivers().getDrivers().get(j);
                    if (!driver.isSelected()) continue;
                    this.jacobian.setEntry(index + i, jOrb++, weight[i] * dMdY0.getEntry(i, j) / sigma[i] * driver.getScale());
                }
            }
            ParameterDriversList selectedPropagationDrivers = this.getSelectedPropagationDriversForBuilder(p);
            int nbParams = selectedPropagationDrivers.getNbParams();
            if (nbParams <= 0) continue;
            double[][] aYPp = new double[6][nbParams];
            this.mappers[p].getParametersJacobian(evaluationStates[k], aYPp);
            Array2DRowRealMatrix dYdPp = new Array2DRowRealMatrix(aYPp, false);
            RealMatrix dMdPp = dMdY.multiply((RealMatrix)dYdPp);
            for (int i = 0; i < dMdPp.getRowDimension(); ++i) {
                for (int j = 0; j < nbParams; ++j) {
                    ParameterDriver delegating = selectedPropagationDrivers.getDrivers().get(j);
                    this.jacobian.addToEntry(index + i, this.propagationParameterColumns.get(delegating.getName()).intValue(), weight[i] * dMdPp.getEntry(i, j) / sigma[i] * delegating.getScale());
                }
            }
        }
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            double[] aMPm = evaluation.getParameterDerivatives(driver);
            for (int i = 0; i < aMPm.length; ++i) {
                this.jacobian.setEntry(index + i, this.measurementParameterColumns.get(driver.getName()).intValue(), weight[i] * aMPm[i] / sigma[i] * driver.getScale());
            }
        }
    }
}

