/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.los;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.rugged.los.LOSTransform;
import org.orekit.rugged.los.TimeDependentLOS;
import org.orekit.rugged.los.TimeIndependentLOSTransform;
import org.orekit.rugged.utils.DerivativeGenerator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;

public class LOSBuilder {
    private final List<Vector3D> rawLOS;
    private final List<LOSTransform> transforms;
    private boolean timeIndependent;

    public LOSBuilder(List<Vector3D> rawLOS) {
        this.rawLOS = rawLOS;
        this.transforms = new ArrayList<LOSTransform>();
        this.timeIndependent = true;
    }

    public LOSBuilder addTransform(TimeIndependentLOSTransform transform) {
        this.transforms.add(new TransformAdapter(transform));
        return this;
    }

    public LOSBuilder addTransform(LOSTransform transform) {
        this.transforms.add(transform);
        this.timeIndependent = false;
        return this;
    }

    public TimeDependentLOS build() {
        if (this.timeIndependent) {
            return new FixedLOS(this.rawLOS, this.transforms);
        }
        return new TransformsSequenceLOS(this.rawLOS, this.transforms);
    }

    private static class FixedLOS
    extends TransformsSequenceLOS {
        private final Vector3D[] transformed;

        FixedLOS(List<Vector3D> raw, List<LOSTransform> transforms) {
            super(raw, transforms);
            this.transformed = new Vector3D[raw.size()];
            ParameterObserver resettingObserver = new ParameterObserver(){

                public void valueChanged(double previousValue, ParameterDriver driver) {
                    Arrays.fill(transformed, null);
                }
            };
            this.getParametersDrivers().forEach(driver -> driver.addObserver(resettingObserver));
        }

        @Override
        public Vector3D getLOS(int index, AbsoluteDate date) {
            if (this.transformed[index] == null) {
                this.transformed[index] = super.getLOS(index, date);
            }
            return this.transformed[index];
        }
    }

    private static class TransformsSequenceLOS
    implements TimeDependentLOS {
        private final Vector3D[] raw;
        private final List<LOSTransform> transforms;

        TransformsSequenceLOS(List<Vector3D> raw, List<LOSTransform> transforms) {
            this.raw = new Vector3D[raw.size()];
            for (int i = 0; i < raw.size(); ++i) {
                this.raw[i] = raw.get(i);
            }
            this.transforms = new ArrayList<LOSTransform>(transforms);
        }

        @Override
        public int getNbPixels() {
            return this.raw.length;
        }

        @Override
        public Vector3D getLOS(int index, AbsoluteDate date) {
            Vector3D los = this.raw[index];
            for (LOSTransform transform : this.transforms) {
                los = transform.transformLOS(index, los, date);
            }
            return los.normalize();
        }

        @Override
        public <T extends Derivative<T>> FieldVector3D<T> getLOSDerivatives(int index, AbsoluteDate date, DerivativeGenerator<T> generator) {
            FieldVector3D<T> los = new FieldVector3D<T>(generator.constant(this.raw[index].getX()), generator.constant(this.raw[index].getY()), generator.constant(this.raw[index].getZ()));
            for (LOSTransform transform : this.transforms) {
                los = transform.transformLOS(index, los, date, generator);
            }
            return los.normalize();
        }

        @Override
        public Stream<ParameterDriver> getParametersDrivers() {
            Stream<ParameterDriver> drivers = Stream.empty();
            for (LOSTransform transform : this.transforms) {
                drivers = Stream.concat(drivers, transform.getParametersDrivers());
            }
            return drivers;
        }
    }

    private static class TransformAdapter
    implements LOSTransform {
        private final TimeIndependentLOSTransform transform;

        TransformAdapter(TimeIndependentLOSTransform transform) {
            this.transform = transform;
        }

        @Override
        public Vector3D transformLOS(int i, Vector3D los, AbsoluteDate date) {
            return this.transform.transformLOS(i, los);
        }

        @Override
        public <T extends Derivative<T>> FieldVector3D<T> transformLOS(int i, FieldVector3D<T> los, AbsoluteDate date, DerivativeGenerator<T> generator) {
            return this.transform.transformLOS(i, los, generator);
        }

        @Override
        public Stream<ParameterDriver> getParametersDrivers() {
            return this.transform.getParametersDrivers();
        }
    }
}

