/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.util.Arrays;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;

public final class MathUtils {
    public static final double TWO_PI = Math.PI * 2;
    public static final double PI_SQUARED = Math.PI * Math.PI;

    private MathUtils() {
    }

    public static int hash(double value) {
        return Double.hashCode(value);
    }

    public static boolean equals(double x, double y) {
        return new Double(x).equals(new Double(y));
    }

    public static int hash(double[] value) {
        return Arrays.hashCode(value);
    }

    public static double normalizeAngle(double a, double center) {
        return a - Math.PI * 2 * FastMath.floor((a + Math.PI - center) / (Math.PI * 2));
    }

    public static <T extends RealFieldElement<T>> T normalizeAngle(T a, T center) {
        return (T)((RealFieldElement)a.subtract(FastMath.floor((RealFieldElement)((RealFieldElement)a.add(Math.PI)).subtract(center).divide(Math.PI * 2)).multiply(Math.PI * 2)));
    }

    public static <T extends RealFieldElement<T>> T max(T e1, T e2) {
        return e1.subtract(e2).getReal() >= 0.0 ? e1 : e2;
    }

    public static <T extends RealFieldElement<T>> T min(T e1, T e2) {
        return e1.subtract(e2).getReal() >= 0.0 ? e2 : e1;
    }

    public static double reduce(double a, double period, double offset) {
        double p = FastMath.abs(period);
        return a - p * FastMath.floor((a - offset) / p) - offset;
    }

    public static byte copySign(byte magnitude, byte sign) throws MathRuntimeException {
        if (magnitude >= 0 && sign >= 0 || magnitude < 0 && sign < 0) {
            return magnitude;
        }
        if (sign >= 0 && magnitude == -128) {
            throw new MathRuntimeException(LocalizedCoreFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static short copySign(short magnitude, short sign) throws MathRuntimeException {
        if (magnitude >= 0 && sign >= 0 || magnitude < 0 && sign < 0) {
            return magnitude;
        }
        if (sign >= 0 && magnitude == Short.MIN_VALUE) {
            throw new MathRuntimeException(LocalizedCoreFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static int copySign(int magnitude, int sign) throws MathRuntimeException {
        if (magnitude >= 0 && sign >= 0 || magnitude < 0 && sign < 0) {
            return magnitude;
        }
        if (sign >= 0 && magnitude == Integer.MIN_VALUE) {
            throw new MathRuntimeException(LocalizedCoreFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static long copySign(long magnitude, long sign) throws MathRuntimeException {
        if (magnitude >= 0L && sign >= 0L || magnitude < 0L && sign < 0L) {
            return magnitude;
        }
        if (sign >= 0L && magnitude == Long.MIN_VALUE) {
            throw new MathRuntimeException(LocalizedCoreFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static void checkFinite(double x) throws MathIllegalArgumentException {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_FINITE_NUMBER, x);
        }
    }

    public static void checkFinite(double[] val) throws MathIllegalArgumentException {
        for (int i = 0; i < val.length; ++i) {
            double x = val[i];
            if (!Double.isInfinite(x) && !Double.isNaN(x)) continue;
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_FINITE_NUMBER, x);
        }
    }

    public static void checkNotNull(Object o, Localizable pattern, Object ... args) throws NullArgumentException {
        if (o == null) {
            throw new NullArgumentException(pattern, args);
        }
    }

    public static void checkNotNull(Object o) throws NullArgumentException {
        if (o == null) {
            throw new NullArgumentException(LocalizedCoreFormats.NULL_NOT_ALLOWED, new Object[0]);
        }
    }

    public static void checkRangeInclusive(long value, long lo, long hi) {
        if (value < lo || value > hi) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, value, lo, hi);
        }
    }

    public static void checkRangeInclusive(double value, double lo, double hi) {
        if (value < lo || value > hi) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, value, lo, hi);
        }
    }

    public static void checkDimension(int dimension, int otherDimension) {
        if (dimension != otherDimension) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, dimension, otherDimension);
        }
    }
}

